/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.account.web;

import com.axelor.apps.account.db.FECImport;
import com.axelor.apps.account.db.repo.FECImportRepository;
import com.axelor.apps.base.db.ImportConfiguration;
import com.axelor.apps.base.db.ImportHistory;
import com.axelor.apps.base.service.imports.importer.FactoryImporter;
import com.axelor.auth.AuthUtils;
import com.axelor.exception.service.TraceBackService;
import com.axelor.inject.Beans;
import com.axelor.meta.MetaFiles;
import com.axelor.meta.db.MetaFile;
import com.axelor.rpc.ActionRequest;
import com.axelor.rpc.ActionResponse;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;

public class FECImportController {
    public void runImport(ActionRequest request, ActionResponse response) {
        try {
            FECImport fecImport = (FECImport)((Object)request.getContext().asType(FECImport.class));
            fecImport = (FECImport)((Object)((FECImportRepository)((Object)Beans.get(FECImportRepository.class))).find(fecImport.getId()));
            ImportConfiguration importConfig = new ImportConfiguration();
            importConfig.setBindMetaFile(fecImport.getBindMetaFile());
            importConfig.setDataMetaFile(((MetaFiles)Beans.get(MetaFiles.class)).upload((InputStream)new FileInputStream(MetaFiles.getPath((MetaFile)fecImport.getDataMetaFile()).toFile()), "FEC.csv"));
            ImportHistory importHistory = ((FactoryImporter)Beans.get(FactoryImporter.class)).createImporter(importConfig).run();
            File readFile = MetaFiles.getPath((MetaFile)importHistory.getLogMetaFile()).toFile();
            response.setNotify(FileUtils.readFileToString((File)readFile, (Charset)StandardCharsets.UTF_8).replaceAll("(\r\n|\n\r|\r|\n)", "<br />"));
        }
        catch (Exception e) {
            TraceBackService.trace((ActionResponse)response, (Throwable)e);
        }
    }

    public void setDefault(ActionRequest request, ActionResponse response) {
        try {
            FECImport fecImport = (FECImport)((Object)request.getContext().asType(FECImport.class));
            fecImport.setUser(AuthUtils.getUser());
            File configFile = File.createTempFile("input-config", ".xml");
            InputStream bindFileInputStream = this.getClass().getResourceAsStream("/FEC-config/import-FEC-config.xml");
            FileOutputStream outputStream = new FileOutputStream(configFile);
            IOUtils.copy((InputStream)bindFileInputStream, (OutputStream)outputStream);
            fecImport.setBindMetaFile(((MetaFiles)Beans.get(MetaFiles.class)).upload(configFile));
            FileUtils.forceDelete((File)configFile);
            response.setValues((Object)fecImport);
        }
        catch (Exception e) {
            TraceBackService.trace((ActionResponse)response, (Throwable)e);
        }
    }
}

