/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.account.web;

import com.axelor.apps.account.db.AccountingSituation;
import com.axelor.apps.account.db.Invoice;
import com.axelor.apps.account.db.InvoicePayment;
import com.axelor.apps.account.db.PaymentCondition;
import com.axelor.apps.account.db.PaymentMode;
import com.axelor.apps.account.db.repo.InvoiceRepository;
import com.axelor.apps.account.service.AccountingSituationService;
import com.axelor.apps.account.service.IrrecoverableService;
import com.axelor.apps.account.service.app.AppAccountService;
import com.axelor.apps.account.service.invoice.InvoiceService;
import com.axelor.apps.account.service.invoice.InvoiceToolService;
import com.axelor.apps.account.service.invoice.print.InvoicePrintService;
import com.axelor.apps.account.service.payment.invoice.payment.InvoicePaymentCreateService;
import com.axelor.apps.base.db.BankDetails;
import com.axelor.apps.base.db.Company;
import com.axelor.apps.base.db.Currency;
import com.axelor.apps.base.db.Language;
import com.axelor.apps.base.db.Partner;
import com.axelor.apps.base.db.PriceList;
import com.axelor.apps.base.db.Wizard;
import com.axelor.apps.base.db.repo.LanguageRepository;
import com.axelor.apps.base.db.repo.PartnerRepository;
import com.axelor.apps.base.service.AddressService;
import com.axelor.apps.base.service.BankDetailsService;
import com.axelor.apps.base.service.PartnerPriceListService;
import com.axelor.apps.base.service.PartnerService;
import com.axelor.apps.base.service.TradingNameService;
import com.axelor.apps.tool.StringTool;
import com.axelor.common.ObjectUtils;
import com.axelor.db.JPA;
import com.axelor.db.Model;
import com.axelor.exception.AxelorException;
import com.axelor.exception.ResponseMessageType;
import com.axelor.exception.service.TraceBackService;
import com.axelor.i18n.I18n;
import com.axelor.inject.Beans;
import com.axelor.meta.schema.actions.ActionView;
import com.axelor.rpc.ActionRequest;
import com.axelor.rpc.ActionResponse;
import com.axelor.rpc.Context;
import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.inject.Singleton;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.tuple.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class InvoiceController {
    private final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());

    public void compute(ActionRequest request, ActionResponse response) {
        Invoice invoice = (Invoice)((Object)request.getContext().asType(Invoice.class));
        try {
            invoice = ((InvoiceService)Beans.get(InvoiceService.class)).compute(invoice);
            response.setValues((Object)invoice);
        }
        catch (Exception e) {
            TraceBackService.trace((ActionResponse)response, (Throwable)e);
        }
    }

    public void validate(ActionRequest request, ActionResponse response) throws AxelorException {
        Invoice invoice = (Invoice)((Object)request.getContext().asType(Invoice.class));
        invoice = (Invoice)((Object)((InvoiceRepository)((Object)Beans.get(InvoiceRepository.class))).find(invoice.getId()));
        try {
            TraceBackService traceBackService = (TraceBackService)Beans.get(TraceBackService.class);
            long tracebackCount = traceBackService.countMessageTraceBack((Model)((Object)invoice));
            ((InvoiceService)Beans.get(InvoiceService.class)).validate(invoice);
            response.setReload(true);
            if (traceBackService.countMessageTraceBack((Model)((Object)invoice)) > tracebackCount) {
                traceBackService.findLastMessageTraceBack((Model)((Object)invoice)).ifPresent(traceback -> response.setNotify(String.format(I18n.get((String)"Error when sending email: %s"), traceback.getMessage())));
            }
        }
        catch (Exception e) {
            TraceBackService.trace((ActionResponse)response, (Throwable)e);
        }
    }

    public void ventilate(ActionRequest request, ActionResponse response) {
        Invoice invoice = (Invoice)((Object)request.getContext().asType(Invoice.class));
        invoice = (Invoice)((Object)((InvoiceRepository)((Object)Beans.get(InvoiceRepository.class))).find(invoice.getId()));
        try {
            TraceBackService traceBackService = (TraceBackService)Beans.get(TraceBackService.class);
            long tracebackCount = traceBackService.countMessageTraceBack((Model)((Object)invoice));
            ((InvoiceService)Beans.get(InvoiceService.class)).ventilate(invoice);
            response.setReload(true);
            if (traceBackService.countMessageTraceBack((Model)((Object)invoice)) > tracebackCount) {
                traceBackService.findLastMessageTraceBack((Model)((Object)invoice)).ifPresent(traceback -> response.setNotify(String.format(I18n.get((String)"Error when sending email: %s"), traceback.getMessage())));
            }
        }
        catch (Exception e) {
            TraceBackService.trace((ActionResponse)response, (Throwable)e);
        }
    }

    public void validateAndVentilate(ActionRequest request, ActionResponse response) {
        Invoice invoice = (Invoice)((Object)request.getContext().asType(Invoice.class));
        invoice = (Invoice)((Object)((InvoiceRepository)((Object)Beans.get(InvoiceRepository.class))).find(invoice.getId()));
        try {
            TraceBackService traceBackService = (TraceBackService)Beans.get(TraceBackService.class);
            long tracebackCount = traceBackService.countMessageTraceBack((Model)((Object)invoice));
            ((InvoiceService)Beans.get(InvoiceService.class)).validateAndVentilate(invoice);
            response.setReload(true);
            if (traceBackService.countMessageTraceBack((Model)((Object)invoice)) > tracebackCount) {
                traceBackService.findLastMessageTraceBack((Model)((Object)invoice)).ifPresent(traceback -> response.setNotify(String.format(I18n.get((String)"Error when sending email: %s"), traceback.getMessage())));
            }
        }
        catch (Exception e) {
            TraceBackService.trace((ActionResponse)response, (Throwable)e);
        }
    }

    public void cancel(ActionRequest request, ActionResponse response) throws AxelorException {
        Invoice invoice = (Invoice)((Object)request.getContext().asType(Invoice.class));
        invoice = (Invoice)((Object)((InvoiceRepository)((Object)Beans.get(InvoiceRepository.class))).find(invoice.getId()));
        if (invoice.getStatusSelect() == 3 && invoice.getCompany().getAccountConfig() != null && !invoice.getCompany().getAccountConfig().getAllowCancelVentilatedInvoice().booleanValue()) {
            response.setError(I18n.get((String)"It is not possible to go back to validate status or cancel a ventilated invoice."));
            return;
        }
        ((InvoiceService)Beans.get(InvoiceService.class)).cancel(invoice);
        response.setFlash(I18n.get((String)"Invoice canceled"));
        response.setReload(true);
    }

    public void fillPaymentModeAndCondition(ActionRequest request, ActionResponse response) {
        Invoice invoice = (Invoice)((Object)request.getContext().asType(Invoice.class));
        try {
            if (invoice.getOperationTypeSelect() == null) {
                return;
            }
            PaymentMode paymentMode = InvoiceToolService.getPaymentMode(invoice);
            PaymentCondition paymentCondition = InvoiceToolService.getPaymentCondition(invoice);
            response.setValue("paymentMode", (Object)paymentMode);
            response.setValue("paymentCondition", (Object)paymentCondition);
        }
        catch (Exception e) {
            TraceBackService.trace((ActionResponse)response, (Throwable)e);
        }
    }

    public void checkNotImputedRefunds(ActionRequest request, ActionResponse response) {
        Invoice invoice = (Invoice)((Object)request.getContext().asType(Invoice.class));
        invoice = (Invoice)((Object)((InvoiceRepository)((Object)Beans.get(InvoiceRepository.class))).find(invoice.getId()));
        try {
            String msg = ((InvoiceService)Beans.get(InvoiceService.class)).checkNotImputedRefunds(invoice);
            if (msg != null) {
                response.setFlash(msg);
            }
        }
        catch (AxelorException e) {
            TraceBackService.trace((ActionResponse)response, (Throwable)e);
        }
    }

    public void checkNotLetteredAdvancePaymentMoveLines(ActionRequest request, ActionResponse response) {
        Invoice invoice = (Invoice)((Object)request.getContext().asType(Invoice.class));
        invoice = (Invoice)((Object)((InvoiceRepository)((Object)Beans.get(InvoiceRepository.class))).find(invoice.getId()));
        try {
            String msg = ((InvoiceService)Beans.get(InvoiceService.class)).checkNotLetteredAdvancePaymentMoveLines(invoice);
            if (msg != null) {
                response.setFlash(msg);
            }
        }
        catch (AxelorException e) {
            TraceBackService.trace((ActionResponse)response, (Throwable)e);
        }
    }

    public void createRefund(ActionRequest request, ActionResponse response) {
        Invoice invoice = (Invoice)((Object)request.getContext().asType(Invoice.class));
        try {
            invoice = (Invoice)((Object)((InvoiceRepository)((Object)Beans.get(InvoiceRepository.class))).find(invoice.getId()));
            Invoice refund = ((InvoiceService)Beans.get(InvoiceService.class)).createRefund(invoice);
            response.setReload(true);
            response.setNotify(I18n.get((String)"Credit note created"));
            response.setView(ActionView.define((String)String.format(I18n.get((String)"Refunds from invoice %s"), invoice.getInvoiceId())).model(Invoice.class.getName()).add("form", "invoice-form").add("grid", "invoice-grid").param("search-filters", "customer-invoices-filters").param("forceTitle", "true").context("_showRecord", (Object)refund.getId().toString()).domain("self.originalInvoice.id = " + invoice.getId()).map());
        }
        catch (Exception e) {
            TraceBackService.trace((ActionResponse)response, (Throwable)e);
        }
    }

    public void usherProcess(ActionRequest request, ActionResponse response) {
        Invoice invoice = (Invoice)((Object)request.getContext().asType(Invoice.class));
        invoice = (Invoice)((Object)((InvoiceRepository)((Object)Beans.get(InvoiceRepository.class))).find(invoice.getId()));
        try {
            ((InvoiceService)Beans.get(InvoiceService.class)).usherProcess(invoice);
        }
        catch (Exception e) {
            TraceBackService.trace((ActionResponse)response, (Throwable)e);
        }
    }

    public void passInIrrecoverable(ActionRequest request, ActionResponse response) {
        Invoice invoice = (Invoice)((Object)request.getContext().asType(Invoice.class));
        invoice = (Invoice)((Object)((InvoiceRepository)((Object)Beans.get(InvoiceRepository.class))).find(invoice.getId()));
        try {
            ((IrrecoverableService)Beans.get(IrrecoverableService.class)).passInIrrecoverable(invoice, true);
            response.setReload(true);
        }
        catch (Exception e) {
            TraceBackService.trace((ActionResponse)response, (Throwable)e);
        }
    }

    public void notPassInIrrecoverable(ActionRequest request, ActionResponse response) {
        Invoice invoice = (Invoice)((Object)request.getContext().asType(Invoice.class));
        invoice = (Invoice)((Object)((InvoiceRepository)((Object)Beans.get(InvoiceRepository.class))).find(invoice.getId()));
        try {
            ((IrrecoverableService)Beans.get(IrrecoverableService.class)).notPassInIrrecoverable(invoice);
            response.setReload(true);
        }
        catch (Exception e) {
            TraceBackService.trace((ActionResponse)response, (Throwable)e);
        }
    }

    public void showInvoice(ActionRequest request, ActionResponse response) {
        Context context = request.getContext();
        try {
            String title;
            String fileLink;
            if (!ObjectUtils.isEmpty((Object)request.getContext().get((Object)"_ids"))) {
                List<Long> ids = ((List)context.get((Object)"_ids")).stream().filter(ObjectUtils::notEmpty).map(input -> Long.parseLong(input.toString())).collect(Collectors.toList());
                fileLink = ((InvoicePrintService)Beans.get(InvoicePrintService.class)).printInvoices(ids);
                title = I18n.get((String)"Invoices");
            } else if (context.get((Object)"id") != null) {
                String format = context.get((Object)"format") != null ? context.get((Object)"format").toString() : "pdf";
                Integer reportType = context.get((Object)"reportType") != null ? Integer.valueOf(Integer.parseInt(context.get((Object)"reportType").toString())) : null;
                Map languageMap = reportType != null && (reportType == 1 || reportType == 3) && context.get((Object)"language") != null ? (Map)request.getContext().get((Object)"language") : null;
                String locale = languageMap != null && languageMap.get("id") != null ? ((Language)((LanguageRepository)Beans.get(LanguageRepository.class)).find(Long.valueOf(Long.parseLong(languageMap.get("id").toString())))).getCode() : null;
                fileLink = ((InvoicePrintService)Beans.get(InvoicePrintService.class)).printInvoice((Invoice)((Object)((InvoiceRepository)((Object)Beans.get(InvoiceRepository.class))).find(Long.parseLong(context.get((Object)"id").toString()))), false, format, reportType, locale);
                title = I18n.get((String)"Invoice");
            } else {
                throw new AxelorException(1, I18n.get((String)"Please select the invoice(s) to print."));
            }
            response.setView(ActionView.define((String)title).add("html", fileLink).map());
        }
        catch (Exception e) {
            TraceBackService.trace((ActionResponse)response, (Throwable)e);
        }
    }

    public void regenerateAndShowInvoice(ActionRequest request, ActionResponse response) {
        Context context = request.getContext();
        Invoice invoice = (Invoice)((Object)((InvoiceRepository)((Object)Beans.get(InvoiceRepository.class))).find(Long.parseLong(context.get((Object)"id").toString())));
        Integer reportType = context.get((Object)"reportType") != null ? Integer.valueOf(Integer.parseInt(context.get((Object)"reportType").toString())) : null;
        try {
            response.setCanClose(true);
            response.setView(ActionView.define((String)I18n.get((String)"Invoice")).add("html", ((InvoicePrintService)Beans.get(InvoicePrintService.class)).printInvoice(invoice, true, "pdf", reportType, null)).map());
        }
        catch (Exception e) {
            TraceBackService.trace((ActionResponse)response, (Throwable)e);
        }
    }

    private String buildMassMessage(int doneCount, int errorCount) {
        StringBuilder sb = new StringBuilder();
        sb.append(String.format(I18n.get((String)"%d record processed successfully,", (String)"%d records processed successfully,", (int)doneCount), doneCount));
        sb.append(" ");
        sb.append(String.format(I18n.get((String)"%d anomaly.", (String)"%d anomalies.", (int)errorCount), errorCount));
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void massProcess(ActionRequest request, ActionResponse response, Function<Collection<? extends Number>, Pair<Integer, Integer>> function) {
        try {
            List ids = (List)request.getContext().get((Object)"_ids");
            if (ObjectUtils.isEmpty((Object)ids)) {
                response.setError("Please select at least one record.");
                return;
            }
            Pair massCount = (Pair)function.apply((Object)ids);
            String message = this.buildMassMessage((Integer)massCount.getLeft(), (Integer)massCount.getRight());
            response.setFlash(message);
        }
        catch (Exception e) {
            TraceBackService.trace((ActionResponse)response, (Throwable)e);
        }
        finally {
            response.setReload(true);
        }
    }

    public void massValidation(ActionRequest request, ActionResponse response) {
        try {
            Function function = ((AppAccountService)Beans.get(AppAccountService.class)).getAppInvoice().getIsVentilationSkipped().booleanValue() ? ((InvoiceService)Beans.get(InvoiceService.class))::massValidateAndVentilate : ((InvoiceService)Beans.get(InvoiceService.class))::massValidate;
            this.massProcess(request, response, (Function<Collection<? extends Number>, Pair<Integer, Integer>>)function);
        }
        catch (Exception e) {
            TraceBackService.trace((ActionResponse)response, (Throwable)e);
        }
    }

    public void massVentilation(ActionRequest request, ActionResponse response) {
        try {
            this.massProcess(request, response, (Function<Collection<? extends Number>, Pair<Integer, Integer>>)((Function)((InvoiceService)Beans.get(InvoiceService.class))::massVentilate));
        }
        catch (Exception e) {
            TraceBackService.trace((ActionResponse)response, (Throwable)e);
        }
    }

    public void mergeInvoice(ActionRequest request, ActionResponse response) {
        ArrayList<Invoice> invoiceList = new ArrayList<Invoice>();
        ArrayList<Long> invoiceIdList = new ArrayList<Long>();
        boolean fromPopup = false;
        if (request.getContext().get((Object)"invoiceToMerge") != null) {
            if (request.getContext().get((Object)"invoiceToMerge") instanceof List) {
                List invoiceMap = (List)request.getContext().get((Object)"invoiceToMerge");
                for (Map map : invoiceMap) {
                    invoiceIdList.add(new Long(((Integer)map.get("id")).intValue()));
                }
            } else {
                String invoiceIdListStr = (String)request.getContext().get((Object)"invoiceToMerge");
                for (String invoiceId : invoiceIdListStr.split(",")) {
                    invoiceIdList.add(new Long(invoiceId));
                }
                fromPopup = true;
            }
        }
        Company commonCompany = null;
        Currency commonCurrency = null;
        Partner commonPartner = null;
        PaymentCondition commonPaymentCondition = null;
        boolean existPaymentConditionDiff = false;
        Partner commonContactPartner = null;
        boolean existContactPartnerDiff = false;
        PriceList commonPriceList = null;
        boolean existPriceListDiff = false;
        PaymentMode commonPaymentMode = null;
        boolean existPaymentModeDiff = false;
        int count = 1;
        for (Long invoiceId : invoiceIdList) {
            Invoice invoiceTemp = (Invoice)((Object)((InvoiceRepository)((Object)Beans.get(InvoiceRepository.class))).find(invoiceId));
            invoiceList.add(invoiceTemp);
            if (count == 1) {
                commonCompany = invoiceTemp.getCompany();
                commonCurrency = invoiceTemp.getCurrency();
                commonPartner = invoiceTemp.getPartner();
                commonPaymentCondition = invoiceTemp.getPaymentCondition();
                commonContactPartner = invoiceTemp.getContactPartner();
                commonPriceList = invoiceTemp.getPriceList();
                commonPaymentMode = invoiceTemp.getPaymentMode();
            } else {
                if (commonCompany != null && !commonCompany.equals((Object)invoiceTemp.getCompany())) {
                    commonCompany = null;
                }
                if (commonCurrency != null && !commonCurrency.equals((Object)invoiceTemp.getCurrency())) {
                    commonCurrency = null;
                }
                if (commonPartner != null && !commonPartner.equals((Object)invoiceTemp.getPartner())) {
                    commonPartner = null;
                }
                if (commonPaymentCondition != null && !commonPaymentCondition.equals((Object)invoiceTemp.getPaymentCondition())) {
                    commonPaymentCondition = null;
                    existPaymentConditionDiff = true;
                }
                if (commonContactPartner != null && !commonContactPartner.equals((Object)invoiceTemp.getContactPartner())) {
                    commonContactPartner = null;
                    existContactPartnerDiff = true;
                }
                if (commonPriceList != null && !commonPriceList.equals((Object)invoiceTemp.getPriceList())) {
                    commonPriceList = null;
                    existPriceListDiff = true;
                }
                if (commonPaymentMode != null && !commonPaymentMode.equals((Object)invoiceTemp.getPaymentMode())) {
                    commonPaymentMode = null;
                    existPaymentModeDiff = true;
                }
            }
            ++count;
        }
        StringBuilder fieldErrors = new StringBuilder();
        if (commonCurrency == null) {
            fieldErrors.append(I18n.get((String)"The currency is required and must be the same for all invoices"));
        }
        if (commonCompany == null) {
            if (fieldErrors.length() > 0) {
                fieldErrors.append("<br/>");
            }
            fieldErrors.append(I18n.get((String)"The company is required and must be the same for all invoices"));
        }
        if (commonPartner == null) {
            if (fieldErrors.length() > 0) {
                fieldErrors.append("<br/>");
            }
            fieldErrors.append(I18n.get((String)"The partner is required and must be the same for all invoices"));
        }
        if (fieldErrors.length() > 0) {
            response.setFlash(fieldErrors.toString());
            return;
        }
        if (request.getContext().get((Object)"contactPartner") != null) {
            commonContactPartner = (Partner)((Object)JPA.em().find(Partner.class, (Object)new Long(((Integer)((Map)request.getContext().get((Object)"contactPartner")).get("id")).intValue())));
        }
        if (request.getContext().get((Object)"priceList") != null) {
            commonPriceList = (PriceList)JPA.em().find(PriceList.class, (Object)new Long(((Integer)((Map)request.getContext().get((Object)"priceList")).get("id")).intValue()));
        }
        if (request.getContext().get((Object)"paymentMode") != null) {
            commonPaymentMode = (PaymentMode)((Object)JPA.em().find(PaymentMode.class, (Object)new Long(((Integer)((Map)request.getContext().get((Object)"paymentMode")).get("id")).intValue())));
        }
        if (request.getContext().get((Object)"paymentCondition") != null) {
            commonPaymentCondition = (PaymentCondition)((Object)JPA.em().find(PaymentCondition.class, (Object)new Long(((Integer)((Map)request.getContext().get((Object)"paymentCondition")).get("id")).intValue())));
        }
        if (!fromPopup && (existPaymentConditionDiff || existContactPartnerDiff || existPriceListDiff || existPaymentModeDiff)) {
            ActionView.ActionViewBuilder confirmView = ActionView.define((String)"Confirm merge invoice").model(Wizard.class.getName()).add("form", "customer-invoices-merge-confirm-form").param("popup", "true").param("show-toolbar", "false").param("show-confirm", "false").param("popup-save", "false").param("forceEdit", "true");
            if (existContactPartnerDiff) {
                confirmView.context("contextContactPartnerToCheck", (Object)"true");
                confirmView.context("contextPartnerId", (Object)commonPartner.getId().toString());
            }
            if (existPriceListDiff) {
                confirmView.context("contextPriceListToCheck", (Object)"true");
            }
            if (existPaymentModeDiff) {
                confirmView.context("contextPaymentModeToCheck", (Object)"true");
            }
            if (existPaymentConditionDiff) {
                confirmView.context("contextPaymentConditionToCheck", (Object)"true");
            }
            confirmView.context("invoiceToMerge", (Object)Joiner.on((String)",").join(invoiceIdList));
            response.setView(confirmView.map());
            return;
        }
        try {
            Invoice invoice = ((InvoiceService)Beans.get(InvoiceService.class)).mergeInvoiceProcess(invoiceList, commonCompany, commonCurrency, commonPartner, commonContactPartner, commonPriceList, commonPaymentMode, commonPaymentCondition);
            if (invoice != null) {
                response.setView(ActionView.define((String)"Invoice").model(Invoice.class.getName()).add("grid", "invoice-grid").add("form", "invoice-form").param("search-filters", "customer-invoices-filters").param("forceEdit", "true").context("_showRecord", (Object)String.valueOf(invoice.getId())).map());
                response.setCanClose(true);
            }
        }
        catch (Exception e) {
            response.setFlash(e.getLocalizedMessage());
        }
    }

    public void computeAddressStr(ActionRequest request, ActionResponse response) {
        Invoice invoice = (Invoice)((Object)request.getContext().asType(Invoice.class));
        response.setValue("addressStr", (Object)((AddressService)Beans.get(AddressService.class)).computeAddressStr(invoice.getAddress()));
    }

    public void computeDeliveryAddressStr(ActionRequest request, ActionResponse response) {
        Invoice invoice = (Invoice)((Object)request.getContext().asType(Invoice.class));
        response.setValue("deliveryAddressStr", (Object)((AddressService)Beans.get(AddressService.class)).computeAddressStr(invoice.getDeliveryAddress()));
    }

    public void fillCompanyBankDetails(ActionRequest request, ActionResponse response) throws AxelorException {
        Invoice invoice = (Invoice)((Object)request.getContext().asType(Invoice.class));
        PaymentMode paymentMode = invoice.getPaymentMode();
        Company company = invoice.getCompany();
        Partner partner = invoice.getPartner();
        if (company == null) {
            return;
        }
        if (partner != null) {
            partner = (Partner)((Object)((PartnerRepository)((Object)Beans.get(PartnerRepository.class))).find(partner.getId()));
        }
        BankDetails defaultBankDetails = ((BankDetailsService)Beans.get(BankDetailsService.class)).getDefaultCompanyBankDetails(company, paymentMode, partner, invoice.getOperationTypeSelect());
        response.setValue("companyBankDetails", (Object)defaultBankDetails);
    }

    public void fillAdvancePaymentInvoiceSetDomain(ActionRequest request, ActionResponse response) {
        Invoice invoice = (Invoice)((Object)request.getContext().asType(Invoice.class));
        try {
            String domain = ((InvoiceService)Beans.get(InvoiceService.class)).createAdvancePaymentInvoiceSetDomain(invoice);
            response.setAttr("advancePaymentInvoiceSet", "domain", (Object)domain);
        }
        catch (Exception e) {
            TraceBackService.trace((Throwable)e);
            response.setError(e.getMessage());
        }
    }

    public void fillAdvancePaymentInvoiceSet(ActionRequest request, ActionResponse response) {
        Invoice invoice = (Invoice)((Object)request.getContext().asType(Invoice.class));
        try {
            Set<Invoice> invoices = ((InvoiceService)Beans.get(InvoiceService.class)).getDefaultAdvancePaymentInvoice(invoice);
            response.setValue("advancePaymentInvoiceSet", invoices);
        }
        catch (Exception e) {
            TraceBackService.trace((ActionResponse)response, (Throwable)e);
        }
    }

    public void setDefaultMail(ActionRequest request, ActionResponse response) {
        AccountingSituation accountingSituation;
        Invoice invoice = (Invoice)((Object)request.getContext().asType(Invoice.class));
        Company company = invoice.getCompany();
        Partner partner = invoice.getPartner();
        if (company != null && partner != null && (accountingSituation = ((AccountingSituationService)Beans.get(AccountingSituationService.class)).getAccountingSituation(partner, company)) != null) {
            response.setValue("invoiceAutomaticMail", (Object)accountingSituation.getInvoiceAutomaticMail());
            response.setValue("invoiceMessageTemplate", (Object)accountingSituation.getInvoiceMessageTemplate());
            response.setValue("invoiceAutomaticMailOnValidate", (Object)accountingSituation.getInvoiceAutomaticMailOnValidate());
            response.setValue("invoiceMessageTemplateOnValidate", (Object)accountingSituation.getInvoiceMessageTemplateOnValidate());
        }
    }

    public void filterPrintingSettings(ActionRequest request, ActionResponse response) {
        Invoice invoice = (Invoice)((Object)request.getContext().asType(Invoice.class));
        List printingSettingsList = ((TradingNameService)Beans.get(TradingNameService.class)).getPrintingSettingsList(invoice.getTradingName(), invoice.getCompany());
        String domain = String.format("self.id IN (%s)", !printingSettingsList.isEmpty() ? StringTool.getIdListString((Collection)printingSettingsList) : "0");
        response.setAttr("printingSettings", "domain", (Object)domain);
    }

    public void fillDefaultPrintingSettings(ActionRequest request, ActionResponse response) {
        try {
            Invoice invoice = (Invoice)((Object)request.getContext().asType(Invoice.class));
            response.setValue("printingSettings", (Object)((TradingNameService)Beans.get(TradingNameService.class)).getDefaultPrintingSettings(invoice.getTradingName(), invoice.getCompany()));
        }
        catch (Exception e) {
            TraceBackService.trace((ActionResponse)response, (Throwable)e);
        }
    }

    public void fillPriceList(ActionRequest request, ActionResponse response) {
        try {
            Invoice invoice = (Invoice)((Object)request.getContext().asType(Invoice.class));
            Partner partner = invoice.getPartner();
            if (partner == null) {
                return;
            }
            int priceListTypeSelect = ((InvoiceService)Beans.get(InvoiceService.class)).getPurchaseTypeOrSaleType(invoice);
            response.setValue("priceList", (Object)((PartnerPriceListService)Beans.get(PartnerPriceListService.class)).getDefaultPriceList(partner, priceListTypeSelect));
        }
        catch (Exception e) {
            TraceBackService.trace((ActionResponse)response, (Throwable)e);
        }
    }

    public void changePriceListDomain(ActionRequest request, ActionResponse response) {
        try {
            Invoice invoice = (Invoice)((Object)request.getContext().asType(Invoice.class));
            int priceListTypeSelect = ((InvoiceService)Beans.get(InvoiceService.class)).getPurchaseTypeOrSaleType(invoice);
            String domain = ((PartnerPriceListService)Beans.get(PartnerPriceListService.class)).getPriceListDomain(invoice.getPartner(), priceListTypeSelect);
            response.setAttr("priceList", "domain", (Object)domain);
        }
        catch (Exception e) {
            TraceBackService.trace((ActionResponse)response, (Throwable)e);
        }
    }

    public void massPaymentOnSupplierInvoices(ActionRequest request, ActionResponse response) {
        try {
            Context context = request.getContext();
            if (!ObjectUtils.isEmpty((Object)context.get((Object)"_ids"))) {
                List<Long> invoiceIdList = ((List)context.get((Object)"_ids")).stream().filter(ObjectUtils::notEmpty).map(input -> Long.parseLong(input.toString())).collect(Collectors.toList());
                List<Long> invoiceToPay = ((InvoicePaymentCreateService)Beans.get(InvoicePaymentCreateService.class)).getInvoiceIdsToPay(invoiceIdList);
                if (invoiceToPay.isEmpty()) {
                    response.setError(I18n.get((String)"No invoice to pay"));
                }
                response.setView(ActionView.define((String)I18n.get((String)"Register a mass payment")).model(InvoicePayment.class.getName()).add("form", "invoice-payment-mass-form").param("popup", "reload").param("show-toolbar", "false").param("show-confirm", "false").param("popup-save", "false").param("forceEdit", "true").context("_invoices", invoiceToPay).map());
            }
        }
        catch (Exception e) {
            TraceBackService.trace((ActionResponse)response, (Throwable)e, (ResponseMessageType)ResponseMessageType.ERROR);
        }
    }

    public void checkPartnerBankDetailsList(ActionRequest request, ActionResponse response) {
        Invoice invoice = (Invoice)((Object)request.getContext().asType(Invoice.class));
        response.setAttr("$partnerBankDetailsListWarning", "hidden", (Object)((InvoiceService)Beans.get(InvoiceService.class)).checkPartnerBankDetailsList(invoice));
    }

    public void refusalToPay(ActionRequest request, ActionResponse response) {
        Invoice invoice = (Invoice)((Object)request.getContext().asType(Invoice.class));
        ((InvoiceService)Beans.get(InvoiceService.class)).refusalToPay((Invoice)((Object)((InvoiceRepository)((Object)Beans.get(InvoiceRepository.class))).find(invoice.getId())), invoice.getReasonOfRefusalToPay(), invoice.getReasonOfRefusalToPayStr());
        response.setCanClose(true);
    }

    public void setPfpValidatorUser(ActionRequest request, ActionResponse response) {
        Invoice invoice = (Invoice)((Object)request.getContext().asType(Invoice.class));
        response.setValue("pfpValidatorUser", (Object)((InvoiceService)Beans.get(InvoiceService.class)).getPfpValidatorUser(invoice));
    }

    public void setPfpValidatorUserDomain(ActionRequest request, ActionResponse response) {
        Invoice invoice = (Invoice)((Object)request.getContext().asType(Invoice.class));
        response.setAttr("pfpValidatorUser", "domain", (Object)((InvoiceService)Beans.get(InvoiceService.class)).getPfpValidatorUserDomain(invoice));
    }

    public void hideSendEmailPfpBtn(ActionRequest request, ActionResponse response) {
        Invoice invoice = (Invoice)((Object)request.getContext().asType(Invoice.class));
        if (invoice.getPfpValidatorUser() == null) {
            return;
        }
        response.setAttr("$isSelectedPfpValidatorEqualsPartnerPfpValidator", "value", (Object)invoice.getPfpValidatorUser().equals((Object)((InvoiceService)Beans.get(InvoiceService.class)).getPfpValidatorUser(invoice)));
    }

    public void getInvoicePartnerDomain(ActionRequest request, ActionResponse response) {
        Invoice invoice = (Invoice)((Object)request.getContext().asType(Invoice.class));
        Company company = invoice.getCompany();
        long companyId = company.getPartner() == null ? 0L : company.getPartner().getId();
        String domain = String.format("self.id != %d AND self.isContact = false ", companyId);
        domain = domain + " AND :company member of self.companySet";
        int invoiceTypeSelect = ((InvoiceService)Beans.get(InvoiceService.class)).getPurchaseTypeOrSaleType(invoice);
        domain = invoiceTypeSelect == 1 ? domain + " AND self.isCustomer = true " : domain + " AND self.isSupplier = true ";
        try {
            if (invoice.getInvoiceLineList() != null && !invoice.getInvoiceLineList().isEmpty() && invoiceTypeSelect == 1) {
                domain = domain + ((PartnerService)Beans.get(PartnerService.class)).getPartnerDomain(invoice.getPartner());
            }
        }
        catch (Exception e) {
            TraceBackService.trace((Throwable)e);
            response.setError(e.getMessage());
        }
        response.setAttr("partner", "domain", (Object)domain);
    }
}

