/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.account.web;

import com.axelor.apps.account.db.Account;
import com.axelor.apps.account.db.AccountManagement;
import com.axelor.apps.account.db.FixedAssetCategory;
import com.axelor.apps.account.db.Invoice;
import com.axelor.apps.account.db.InvoiceLine;
import com.axelor.apps.account.db.TaxLine;
import com.axelor.apps.account.service.AccountManagementServiceAccountImpl;
import com.axelor.apps.account.service.app.AppAccountService;
import com.axelor.apps.account.service.invoice.InvoiceLineService;
import com.axelor.apps.account.service.invoice.InvoiceToolService;
import com.axelor.apps.account.service.invoice.generator.line.InvoiceLineManagement;
import com.axelor.apps.base.db.Product;
import com.axelor.db.mapper.Mapper;
import com.axelor.exception.AxelorException;
import com.axelor.exception.service.TraceBackService;
import com.axelor.inject.Beans;
import com.axelor.rpc.ActionRequest;
import com.axelor.rpc.ActionResponse;
import com.axelor.rpc.Context;
import com.google.common.base.Strings;
import com.google.inject.Singleton;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;

@Singleton
public class InvoiceLineController {
    public void getAndComputeAnalyticDistribution(ActionRequest request, ActionResponse response) throws AxelorException {
        InvoiceLine invoiceLine = (InvoiceLine)((Object)request.getContext().asType(InvoiceLine.class));
        Invoice invoice = invoiceLine.getInvoice();
        if (invoice == null) {
            invoice = (Invoice)((Object)request.getContext().getParent().asType(Invoice.class));
        }
        response.setValue("analyticMoveLineList", ((InvoiceLineService)Beans.get(InvoiceLineService.class)).getAndComputeAnalyticDistribution(invoiceLine, invoice));
        response.setValue("analyticDistributionTemplate", (Object)invoiceLine.getAnalyticDistributionTemplate());
    }

    public void createAnalyticDistributionWithTemplate(ActionRequest request, ActionResponse response) throws AxelorException {
        InvoiceLine invoiceLine = (InvoiceLine)((Object)request.getContext().asType(InvoiceLine.class));
        response.setValue("analyticMoveLineList", ((InvoiceLineService)Beans.get(InvoiceLineService.class)).createAnalyticDistributionWithTemplate(invoiceLine));
    }

    public void computeAnalyticDistribution(ActionRequest request, ActionResponse response) throws AxelorException {
        Context context = request.getContext();
        InvoiceLine invoiceLine = (InvoiceLine)((Object)context.asType(InvoiceLine.class));
        if (((AppAccountService)Beans.get(AppAccountService.class)).getAppAccount().getManageAnalyticAccounting().booleanValue()) {
            response.setValue("analyticMoveLineList", ((InvoiceLineService)Beans.get(InvoiceLineService.class)).computeAnalyticDistribution(invoiceLine));
        }
    }

    public void compute(ActionRequest request, ActionResponse response) throws AxelorException {
        BigDecimal inTaxTotal;
        BigDecimal exTaxTotal;
        Invoice invoice;
        Context context = request.getContext();
        InvoiceLineService invoiceLineService = (InvoiceLineService)Beans.get(InvoiceLineService.class);
        InvoiceLine invoiceLine = (InvoiceLine)((Object)context.asType(InvoiceLine.class));
        if (context.getParent().getContextClass() == InvoiceLine.class) {
            context = request.getContext().getParent();
        }
        if ((invoice = this.getInvoice(context)) == null || invoiceLine.getPrice() == null || invoiceLine.getInTaxPrice() == null || invoiceLine.getQty() == null) {
            return;
        }
        BigDecimal priceDiscounted = invoiceLineService.computeDiscount(invoiceLine, invoice.getInAti());
        response.setValue("priceDiscounted", (Object)priceDiscounted);
        response.setAttr("priceDiscounted", "hidden", (Object)(priceDiscounted.compareTo(invoice.getInAti() != false ? invoiceLine.getInTaxPrice() : invoiceLine.getPrice()) == 0 ? 1 : 0));
        BigDecimal taxRate = BigDecimal.ZERO;
        if (invoiceLine.getTaxLine() != null) {
            taxRate = invoiceLine.getTaxLine().getValue();
            response.setValue("taxRate", (Object)taxRate);
            response.setValue("taxCode", (Object)invoiceLine.getTaxLine().getTax().getCode());
        }
        if (!invoice.getInAti().booleanValue()) {
            exTaxTotal = InvoiceLineManagement.computeAmount(invoiceLine.getQty(), priceDiscounted);
            inTaxTotal = exTaxTotal.add(exTaxTotal.multiply(taxRate));
        } else {
            inTaxTotal = InvoiceLineManagement.computeAmount(invoiceLine.getQty(), priceDiscounted);
            exTaxTotal = inTaxTotal.divide(taxRate.add(BigDecimal.ONE), 2, 4);
        }
        BigDecimal companyExTaxTotal = invoiceLineService.getCompanyExTaxTotal(exTaxTotal, invoice);
        BigDecimal companyInTaxTotal = invoiceLineService.getCompanyExTaxTotal(inTaxTotal, invoice);
        response.setValue("exTaxTotal", (Object)exTaxTotal);
        response.setValue("inTaxTotal", (Object)inTaxTotal);
        response.setValue("companyInTaxTotal", (Object)companyInTaxTotal);
        response.setValue("companyExTaxTotal", (Object)companyExTaxTotal);
    }

    public void getProductInformation(ActionRequest request, ActionResponse response) throws AxelorException {
        Context context = request.getContext();
        InvoiceLine invoiceLine = (InvoiceLine)((Object)context.asType(InvoiceLine.class));
        if (context.getParent().getContextClass() == InvoiceLine.class) {
            context = request.getContext().getParent();
        }
        Invoice invoice = this.getInvoice(context);
        Product product = invoiceLine.getProduct();
        Map<Object, Object> productInformation = new HashMap();
        if (invoice != null && product != null) {
            try {
                productInformation = ((InvoiceLineService)Beans.get(InvoiceLineService.class)).fillProductInformation(invoice, invoiceLine);
                String errorMsg = (String)productInformation.get("error");
                if (!Strings.isNullOrEmpty((String)errorMsg)) {
                    response.setFlash(errorMsg);
                }
            }
            catch (Exception e) {
                TraceBackService.trace((ActionResponse)response, (Throwable)e);
            }
        } else {
            productInformation = ((InvoiceLineService)Beans.get(InvoiceLineService.class)).resetProductInformation(invoice);
        }
        response.setValues(productInformation);
    }

    public void getDiscount(ActionRequest request, ActionResponse response) {
        Invoice invoice;
        Context context = request.getContext();
        InvoiceLine invoiceLine = (InvoiceLine)((Object)context.asType(InvoiceLine.class));
        if (context.getParent().getContextClass() == InvoiceLine.class) {
            context = request.getContext().getParent();
        }
        if ((invoice = this.getInvoice(context)) == null || invoiceLine.getProduct() == null) {
            return;
        }
        try {
            Map<String, Object> discounts = ((InvoiceLineService)Beans.get(InvoiceLineService.class)).getDiscount(invoice, invoiceLine, invoiceLine.getProduct().getInAti() != false ? ((InvoiceLineService)Beans.get(InvoiceLineService.class)).getInTaxUnitPrice(invoice, invoiceLine, invoiceLine.getTaxLine(), InvoiceToolService.isPurchase(invoice)) : ((InvoiceLineService)Beans.get(InvoiceLineService.class)).getExTaxUnitPrice(invoice, invoiceLine, invoiceLine.getTaxLine(), InvoiceToolService.isPurchase(invoice)));
            for (Map.Entry<String, Object> entry : discounts.entrySet()) {
                response.setValue(entry.getKey(), entry.getValue());
            }
        }
        catch (Exception e) {
            response.setFlash(e.getMessage());
        }
    }

    public void updatePrice(ActionRequest request, ActionResponse response) {
        Context context = request.getContext();
        InvoiceLine invoiceLine = (InvoiceLine)((Object)context.asType(InvoiceLine.class));
        try {
            BigDecimal inTaxPrice = invoiceLine.getInTaxPrice();
            TaxLine taxLine = invoiceLine.getTaxLine();
            response.setValue("price", (Object)((InvoiceLineService)Beans.get(InvoiceLineService.class)).convertUnitPrice(true, taxLine, inTaxPrice));
        }
        catch (Exception e) {
            TraceBackService.trace((ActionResponse)response, (Throwable)e);
        }
    }

    public void updateInTaxPrice(ActionRequest request, ActionResponse response) {
        Context context = request.getContext();
        InvoiceLine invoiceLine = (InvoiceLine)((Object)context.asType(InvoiceLine.class));
        try {
            BigDecimal exTaxPrice = invoiceLine.getPrice();
            TaxLine taxLine = invoiceLine.getTaxLine();
            response.setValue("inTaxPrice", (Object)((InvoiceLineService)Beans.get(InvoiceLineService.class)).convertUnitPrice(false, taxLine, exTaxPrice));
        }
        catch (Exception e) {
            TraceBackService.trace((ActionResponse)response, (Throwable)e);
        }
    }

    public void convertUnitPrice(ActionRequest request, ActionResponse response) {
        Invoice invoice;
        Context context = request.getContext();
        InvoiceLine invoiceLine = (InvoiceLine)((Object)context.asType(InvoiceLine.class));
        if (context.getParent().getContextClass() == InvoiceLine.class) {
            context = request.getContext().getParent();
        }
        if ((invoice = this.getInvoice(context)) == null || invoiceLine.getProduct() == null || invoiceLine.getPrice() == null || invoiceLine.getInTaxPrice() == null) {
            return;
        }
        try {
            BigDecimal price = invoiceLine.getPrice();
            BigDecimal inTaxPrice = price.add(price.multiply(invoiceLine.getTaxLine().getValue()));
            response.setValue("inTaxPrice", (Object)inTaxPrice);
        }
        catch (Exception e) {
            response.setFlash(e.getMessage());
        }
    }

    public void emptyLine(ActionRequest request, ActionResponse response) {
        InvoiceLine invoiceLine = (InvoiceLine)((Object)request.getContext().asType(InvoiceLine.class));
        if (invoiceLine.getTypeSelect() != 0) {
            Map newInvoiceLine = Mapper.toMap((Object)((Object)new InvoiceLine()));
            newInvoiceLine.put("qty", BigDecimal.ZERO);
            newInvoiceLine.put("id", invoiceLine.getId());
            newInvoiceLine.put("version", invoiceLine.getVersion());
            newInvoiceLine.put("typeSelect", invoiceLine.getTypeSelect());
            response.setValues((Object)newInvoiceLine);
        }
    }

    public Invoice getInvoice(Context context) {
        Context parentContext = context.getParent();
        Invoice invoice = (Invoice)((Object)parentContext.asType(Invoice.class));
        if (!parentContext.getContextClass().toString().equals(Invoice.class.toString())) {
            InvoiceLine invoiceLine = (InvoiceLine)((Object)context.asType(InvoiceLine.class));
            invoice = invoiceLine.getInvoice();
        }
        return invoice;
    }

    public void getAccount(ActionRequest request, ActionResponse response) {
        try {
            InvoiceLine invoiceLine = (InvoiceLine)((Object)request.getContext().asType(InvoiceLine.class));
            if (invoiceLine != null) {
                Product product = invoiceLine.getProduct();
                Invoice invoice = this.getInvoice(request.getContext());
                if (product != null) {
                    Account account = ((AccountManagementServiceAccountImpl)Beans.get(AccountManagementServiceAccountImpl.class)).getProductAccount(product, invoice.getCompany(), invoice.getPartner().getFiscalPosition(), InvoiceToolService.isPurchase(invoice), invoiceLine.getFixedAssets());
                    response.setValue("account", (Object)account);
                }
            }
        }
        catch (Exception e) {
            TraceBackService.trace((ActionResponse)response, (Throwable)e);
        }
    }

    public void filterAccount(ActionRequest request, ActionResponse response) throws AxelorException {
        Context context = request.getContext();
        Invoice invoice = this.getInvoice(context);
        InvoiceLine invoiceLine = (InvoiceLine)((Object)request.getContext().asType(InvoiceLine.class));
        if (invoice != null && invoice.getCompany() != null) {
            ArrayList<String> technicalTypeSelectList = new ArrayList<String>();
            if (InvoiceToolService.isPurchase(invoice)) {
                if (invoiceLine.getFixedAssets().booleanValue()) {
                    technicalTypeSelectList.add("immobilisation");
                } else {
                    technicalTypeSelectList.add("debt");
                    technicalTypeSelectList.add("charge");
                }
            } else {
                technicalTypeSelectList.add("income");
            }
            String domain = "self.company.id = " + invoice.getCompany().getId() + " AND self.accountType.technicalTypeSelect IN " + technicalTypeSelectList.stream().collect(Collectors.joining("','", "('", "')"));
            response.setAttr("account", "domain", (Object)domain);
        }
    }

    public void getFixedAssetCategory(ActionRequest request, ActionResponse response) {
        Context context = request.getContext();
        InvoiceLine invoiceLine = (InvoiceLine)((Object)context.asType(InvoiceLine.class));
        if (context.getParent().getContextClass() == InvoiceLine.class) {
            context = request.getContext().getParent();
        }
        Invoice invoice = this.getInvoice(context);
        Product product = invoiceLine.getProduct();
        if (invoice == null || product == null) {
            return;
        }
        FixedAssetCategory fixedAssetCategory = null;
        if (!(product.getAccountManagementList().isEmpty() || invoice.getOperationTypeSelect() != 1 && invoice.getOperationTypeSelect() != 2)) {
            Optional<AccountManagement> optionalFixedAssetCategory = product.getAccountManagementList().stream().filter(am -> am.getCompany() == invoice.getCompany()).findFirst();
            fixedAssetCategory = optionalFixedAssetCategory.isPresent() ? optionalFixedAssetCategory.get().getFixedAssetCategory() : null;
        }
        response.setValue("fixedAssetCategory", fixedAssetCategory);
    }
}

