/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.account.web;

import com.axelor.apps.ReportFactory;
import com.axelor.apps.account.db.Irrecoverable;
import com.axelor.apps.account.db.repo.IrrecoverableRepository;
import com.axelor.apps.account.service.IrrecoverableService;
import com.axelor.db.Model;
import com.axelor.exception.AxelorException;
import com.axelor.exception.service.TraceBackService;
import com.axelor.i18n.I18n;
import com.axelor.inject.Beans;
import com.axelor.meta.schema.actions.ActionView;
import com.axelor.rpc.ActionRequest;
import com.axelor.rpc.ActionResponse;
import com.google.inject.Singleton;
import java.lang.invoke.MethodHandles;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class IrrecoverableController {
    private final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());

    public void getIrrecoverable(ActionRequest request, ActionResponse response) {
        Irrecoverable irrecoverable = (Irrecoverable)((Object)request.getContext().asType(Irrecoverable.class));
        irrecoverable = (Irrecoverable)((Object)((IrrecoverableRepository)((Object)Beans.get(IrrecoverableRepository.class))).find(irrecoverable.getId()));
        try {
            ((IrrecoverableService)Beans.get(IrrecoverableService.class)).getIrrecoverable(irrecoverable);
            response.setReload(true);
        }
        catch (Exception e) {
            TraceBackService.trace((ActionResponse)response, (Throwable)e);
        }
    }

    public void createIrrecoverableReport(ActionRequest request, ActionResponse response) {
        Irrecoverable irrecoverable = (Irrecoverable)((Object)request.getContext().asType(Irrecoverable.class));
        irrecoverable = (Irrecoverable)((Object)((IrrecoverableRepository)((Object)Beans.get(IrrecoverableRepository.class))).find(irrecoverable.getId()));
        try {
            ((IrrecoverableService)Beans.get(IrrecoverableService.class)).createIrrecoverableReport(irrecoverable);
            response.setReload(true);
        }
        catch (Exception e) {
            TraceBackService.trace((ActionResponse)response, (Throwable)e);
        }
    }

    public void passInIrrecoverable(ActionRequest request, ActionResponse response) {
        Irrecoverable irrecoverable = (Irrecoverable)((Object)request.getContext().asType(Irrecoverable.class));
        irrecoverable = (Irrecoverable)((Object)((IrrecoverableRepository)((Object)Beans.get(IrrecoverableRepository.class))).find(irrecoverable.getId()));
        try {
            int anomaly = ((IrrecoverableService)Beans.get(IrrecoverableService.class)).passInIrrecoverable(irrecoverable);
            response.setReload(true);
            response.setFlash(I18n.get((String)"Treatment finished") + " - " + anomaly + " " + I18n.get((String)"Anomalies generated"));
        }
        catch (Exception e) {
            TraceBackService.trace((ActionResponse)response, (Throwable)e);
        }
    }

    public void printIrrecoverable(ActionRequest request, ActionResponse response) throws AxelorException {
        Irrecoverable irrecoverable = (Irrecoverable)((Object)request.getContext().asType(Irrecoverable.class));
        if (irrecoverable.getExportTypeSelect() == null) {
            response.setFlash(I18n.get((String)"You must select a printing type"));
        } else {
            String name = I18n.get((String)"Irrecoverable reporting") + " " + irrecoverable.getName();
            String fileLink = ReportFactory.createReport((String)"Irrecoverable.rptdesign", (String)(name + "-${date}")).addParam("IrrecoverableID", (Object)irrecoverable.getId()).addParam("Timezone", irrecoverable.getCompany() != null ? irrecoverable.getCompany().getTimezone() : null).addFormat(irrecoverable.getExportTypeSelect()).toAttach((Model)((Object)irrecoverable)).generate().getFileLink();
            this.logger.debug("Printing " + name);
            response.setView(ActionView.define((String)name).add("html", fileLink).map());
        }
    }
}

