/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.account.web;

import com.axelor.apps.account.db.Move;
import com.axelor.apps.account.db.MoveLine;
import com.axelor.apps.account.db.repo.MoveLineRepository;
import com.axelor.apps.account.service.IrrecoverableService;
import com.axelor.apps.account.service.app.AppAccountService;
import com.axelor.apps.account.service.move.MoveLineService;
import com.axelor.apps.account.service.move.MoveService;
import com.axelor.apps.base.db.Currency;
import com.axelor.apps.base.db.Wizard;
import com.axelor.apps.base.service.CurrencyService;
import com.axelor.exception.AxelorException;
import com.axelor.exception.service.TraceBackService;
import com.axelor.i18n.I18n;
import com.axelor.inject.Beans;
import com.axelor.meta.schema.actions.ActionView;
import com.axelor.rpc.ActionRequest;
import com.axelor.rpc.ActionResponse;
import com.axelor.rpc.Context;
import com.google.inject.Singleton;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;

@Singleton
public class MoveLineController {
    public void computeAnalyticDistribution(ActionRequest request, ActionResponse response) {
        MoveLine moveLine = (MoveLine)((Object)request.getContext().asType(MoveLine.class));
        try {
            if (((AppAccountService)Beans.get(AppAccountService.class)).getAppAccount().getManageAnalyticAccounting().booleanValue()) {
                moveLine = ((MoveLineService)Beans.get(MoveLineService.class)).computeAnalyticDistribution(moveLine);
                response.setValue("analyticMoveLineList", moveLine.getAnalyticMoveLineList());
            }
        }
        catch (Exception e) {
            TraceBackService.trace((ActionResponse)response, (Throwable)e);
        }
    }

    public void createAnalyticDistributionWithTemplate(ActionRequest request, ActionResponse response) throws AxelorException {
        try {
            MoveLine moveLine = (MoveLine)((Object)request.getContext().asType(MoveLine.class));
            moveLine = ((MoveLineService)Beans.get(MoveLineService.class)).createAnalyticDistributionWithTemplate(moveLine);
            response.setValue("analyticMoveLineList", moveLine.getAnalyticMoveLineList());
        }
        catch (Exception e) {
            TraceBackService.trace((ActionResponse)response, (Throwable)e);
        }
    }

    public void usherProcess(ActionRequest request, ActionResponse response) {
        MoveLine moveLine = (MoveLine)((Object)request.getContext().asType(MoveLine.class));
        moveLine = (MoveLine)((Object)((MoveLineRepository)((Object)Beans.get(MoveLineRepository.class))).find(moveLine.getId()));
        try {
            ((MoveLineService)Beans.get(MoveLineService.class)).usherProcess(moveLine);
        }
        catch (Exception e) {
            TraceBackService.trace((ActionResponse)response, (Throwable)e);
        }
    }

    public void passInIrrecoverable(ActionRequest request, ActionResponse response) {
        MoveLine moveLine = (MoveLine)((Object)request.getContext().asType(MoveLine.class));
        moveLine = (MoveLine)((Object)((MoveLineRepository)((Object)Beans.get(MoveLineRepository.class))).find(moveLine.getId()));
        try {
            ((IrrecoverableService)Beans.get(IrrecoverableService.class)).passInIrrecoverable(moveLine, true, true);
            response.setReload(true);
        }
        catch (Exception e) {
            TraceBackService.trace((ActionResponse)response, (Throwable)e);
        }
    }

    public void notPassInIrrecoverable(ActionRequest request, ActionResponse response) {
        MoveLine moveLine = (MoveLine)((Object)request.getContext().asType(MoveLine.class));
        moveLine = (MoveLine)((Object)((MoveLineRepository)((Object)Beans.get(MoveLineRepository.class))).find(moveLine.getId()));
        try {
            ((IrrecoverableService)Beans.get(IrrecoverableService.class)).notPassInIrrecoverable(moveLine, true);
            response.setReload(true);
        }
        catch (Exception e) {
            TraceBackService.trace((ActionResponse)response, (Throwable)e);
        }
    }

    public void accountingReconcile(ActionRequest request, ActionResponse response) {
        ArrayList<MoveLine> moveLineList = new ArrayList<MoveLine>();
        List idList = (List)request.getContext().get((Object)"_ids");
        try {
            if (idList != null) {
                for (Integer it : idList) {
                    MoveLine moveLine = (MoveLine)((Object)((MoveLineRepository)((Object)Beans.get(MoveLineRepository.class))).find(it.longValue()));
                    if (moveLine.getMove().getStatusSelect() != 3 && moveLine.getMove().getStatusSelect() != 2 || moveLine.getAmountRemaining().compareTo(BigDecimal.ZERO) <= 0) continue;
                    moveLineList.add(moveLine);
                }
            }
            if (!moveLineList.isEmpty()) {
                ((MoveLineService)Beans.get(MoveLineService.class)).reconcileMoveLinesWithCacheManagement(moveLineList);
                response.setReload(true);
            }
        }
        catch (Exception e) {
            TraceBackService.trace((ActionResponse)response, (Throwable)e);
        }
    }

    public void showCalculatedBalance(ActionRequest request, ActionResponse response) {
        BigDecimal totalCredit = new BigDecimal(0);
        BigDecimal totalDebit = new BigDecimal(0);
        List idList = (List)request.getContext().get((Object)"_ids");
        try {
            if (idList != null && !idList.isEmpty()) {
                MoveLineRepository moveLineRepository = (MoveLineRepository)((Object)Beans.get(MoveLineRepository.class));
                for (Integer id : idList) {
                    if (id != null) {
                        MoveLine moveLine = (MoveLine)((Object)moveLineRepository.find(id.longValue()));
                        if (moveLine != null && moveLine.getMove() != null) {
                            Integer statusSelect = moveLine.getMove().getStatusSelect();
                            if (!statusSelect.equals(3) && !statusSelect.equals(2)) continue;
                            totalCredit = totalCredit.add(moveLine.getCredit());
                            totalDebit = totalDebit.add(moveLine.getDebit());
                            continue;
                        }
                        throw new AxelorException(3, I18n.get((String)"Cannot find the move line with id: %s"), new Object[]{id.longValue()});
                    }
                    throw new AxelorException(MoveLine.class, 3, I18n.get((String)"One id is null"));
                }
                BigDecimal finalBalance = totalDebit.subtract(totalCredit);
                response.setView(ActionView.define((String)"Calculation").model(Wizard.class.getName()).add("form", "account-move-line-calculation-wizard-form").param("popup", "true").param("show-toolbar", "false").param("show-confirm", "false").param("width", "500").param("popup-save", "false").context("_credit", (Object)totalCredit).context("_debit", (Object)totalDebit).context("_balance", (Object)finalBalance).map());
            } else {
                response.setAlert(I18n.get((String)"No Lines selected"));
            }
        }
        catch (Exception e) {
            TraceBackService.trace((ActionResponse)response, (Throwable)e);
        }
    }

    public void computeTaxAmount(ActionRequest request, ActionResponse response) {
        try {
            MoveLine moveLine = (MoveLine)((Object)request.getContext().asType(MoveLine.class));
            moveLine = ((MoveLineService)Beans.get(MoveLineService.class)).computeTaxAmount(moveLine);
            response.setValues((Object)moveLine);
        }
        catch (Exception e) {
            TraceBackService.trace((ActionResponse)response, (Throwable)e);
        }
    }

    public void filterPartner(ActionRequest request, ActionResponse response) {
        Move move = (Move)((Object)request.getContext().getParent().asType(Move.class));
        if (move != null) {
            String domain = ((MoveService)Beans.get(MoveService.class)).filterPartner(move);
            response.setAttr("partner", "domain", (Object)domain);
        }
    }

    public void computeCurrentRate(ActionRequest request, ActionResponse response) {
        try {
            Context parentContext = request.getContext().getParent();
            BigDecimal currencyRate = BigDecimal.ONE;
            if (parentContext != null && Move.class.equals((Object)parentContext.getContextClass())) {
                Move move = (Move)((Object)parentContext.asType(Move.class));
                Currency currency = move.getCurrency();
                Currency companyCurrency = move.getCompanyCurrency();
                if (currency != null && companyCurrency != null && !currency.equals((Object)companyCurrency)) {
                    currencyRate = ((CurrencyService)Beans.get(CurrencyService.class)).getCurrencyConversionRate(currency, companyCurrency);
                }
            }
            response.setValue("currencyRate", (Object)currencyRate);
        }
        catch (AxelorException e) {
            TraceBackService.trace((ActionResponse)response, (Throwable)e);
        }
    }
}

