/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.account.web;

import com.axelor.apps.account.db.MoveLine;
import com.axelor.apps.account.db.Notification;
import com.axelor.apps.account.db.NotificationItem;
import com.axelor.apps.account.db.repo.NotificationRepository;
import com.axelor.apps.account.service.NotificationService;
import com.axelor.exception.ResponseMessageType;
import com.axelor.exception.service.TraceBackService;
import com.axelor.inject.Beans;
import com.axelor.meta.schema.actions.ActionView;
import com.axelor.rpc.ActionRequest;
import com.axelor.rpc.ActionResponse;
import com.google.common.base.Joiner;
import com.google.inject.Singleton;
import java.util.ArrayList;

@Singleton
public class NotificationController {
    public void populateNotificationItemList(ActionRequest request, ActionResponse response) {
        try {
            Notification notification = (Notification)((Object)request.getContext().asType(Notification.class));
            ((NotificationService)Beans.get(NotificationService.class)).populateNotificationItemList(notification);
            response.setValue("notificationItemList", notification.getNotificationItemList());
        }
        catch (Exception e) {
            TraceBackService.trace((ActionResponse)response, (Throwable)e, (ResponseMessageType)ResponseMessageType.ERROR);
        }
    }

    public void validate(ActionRequest request, ActionResponse response) {
        try {
            Notification notification = (Notification)((Object)request.getContext().asType(Notification.class));
            notification = (Notification)((Object)((NotificationRepository)((Object)Beans.get(NotificationRepository.class))).find(notification.getId()));
            ((NotificationService)Beans.get(NotificationService.class)).validate(notification);
            response.setReload(true);
        }
        catch (Exception e) {
            TraceBackService.trace((ActionResponse)response, (Throwable)e, (ResponseMessageType)ResponseMessageType.ERROR);
        }
    }

    public void displayMoveLines(ActionRequest request, ActionResponse response) {
        try {
            Notification notification = (Notification)((Object)request.getContext().asType(Notification.class));
            ArrayList<Long> moveLineIdList = new ArrayList<Long>();
            for (NotificationItem notificationItem : notification.getNotificationItemList()) {
                for (MoveLine moveLine : notificationItem.getMove().getMoveLineList()) {
                    moveLineIdList.add(moveLine.getId());
                }
            }
            response.setView(ActionView.define((String)"MoveLines").model(MoveLine.class.getName()).add("grid", "move-line-grid").add("form", "move-line-form").param("search-filters", "move-line-filters").domain("self.id in (" + Joiner.on((String)",").join(moveLineIdList) + ")").map());
        }
        catch (Exception e) {
            TraceBackService.trace((ActionResponse)response, (Throwable)e, (ResponseMessageType)ResponseMessageType.ERROR);
        }
    }
}

