/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.account.web;

import com.axelor.apps.account.db.PayVoucherElementToPay;
import com.axelor.apps.account.db.repo.PayVoucherElementToPayRepository;
import com.axelor.apps.base.db.Currency;
import com.axelor.apps.base.service.CurrencyService;
import com.axelor.db.Model;
import com.axelor.exception.service.TraceBackService;
import com.axelor.inject.Beans;
import com.axelor.rpc.ActionRequest;
import com.axelor.rpc.ActionResponse;
import com.google.inject.Singleton;
import com.google.inject.persist.Transactional;
import java.math.BigDecimal;

@Singleton
public class PayVoucherElementController {
    @Transactional
    public void updateAmountToPayCurrency(ActionRequest request, ActionResponse response) {
        PayVoucherElementToPay elementToPayContext = (PayVoucherElementToPay)((Object)request.getContext().asType(PayVoucherElementToPay.class));
        PayVoucherElementToPay elementToPay = (PayVoucherElementToPay)((Object)((PayVoucherElementToPayRepository)((Object)Beans.get(PayVoucherElementToPayRepository.class))).find(elementToPayContext.getId()));
        Currency paymentVoucherCurrency = elementToPay.getPaymentVoucher().getCurrency();
        BigDecimal amountToPayCurrency = null;
        try {
            amountToPayCurrency = ((CurrencyService)Beans.get(CurrencyService.class)).getAmountCurrencyConvertedAtDate(elementToPay.getCurrency(), paymentVoucherCurrency, elementToPay.getAmountToPay(), elementToPay.getPaymentVoucher().getPaymentDate());
        }
        catch (Exception e) {
            TraceBackService.trace((ActionResponse)response, (Throwable)e);
        }
        if (amountToPayCurrency != null) {
            elementToPay.setAmountToPayCurrency(amountToPayCurrency);
            ((PayVoucherElementToPayRepository)((Object)Beans.get(PayVoucherElementToPayRepository.class))).save((Model)((Object)elementToPay));
            response.setReload(true);
        }
    }
}

