/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.account.web;

import com.axelor.apps.ReportFactory;
import com.axelor.apps.account.db.Invoice;
import com.axelor.apps.account.db.Journal;
import com.axelor.apps.account.db.PaymentMode;
import com.axelor.apps.account.db.PaymentVoucher;
import com.axelor.apps.account.db.repo.InvoiceRepository;
import com.axelor.apps.account.db.repo.PaymentVoucherRepository;
import com.axelor.apps.account.service.payment.PaymentModeService;
import com.axelor.apps.account.service.payment.paymentvoucher.PaymentVoucherConfirmService;
import com.axelor.apps.account.service.payment.paymentvoucher.PaymentVoucherLoadService;
import com.axelor.apps.account.service.payment.paymentvoucher.PaymentVoucherSequenceService;
import com.axelor.apps.base.db.BankDetails;
import com.axelor.apps.base.db.Company;
import com.axelor.apps.base.db.Partner;
import com.axelor.apps.base.db.repo.PartnerRepository;
import com.axelor.apps.base.service.BankDetailsService;
import com.axelor.db.mapper.Mapper;
import com.axelor.exception.AxelorException;
import com.axelor.exception.service.TraceBackService;
import com.axelor.i18n.I18n;
import com.axelor.inject.Beans;
import com.axelor.meta.schema.actions.ActionView;
import com.axelor.rpc.ActionRequest;
import com.axelor.rpc.ActionResponse;
import com.google.common.base.Strings;
import com.google.inject.Singleton;
import java.lang.invoke.MethodHandles;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class PaymentVoucherController {
    private final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());

    public void paymentVoucherSetNum(ActionRequest request, ActionResponse response) throws AxelorException {
        PaymentVoucher paymentVoucher = (PaymentVoucher)((Object)request.getContext().asType(PaymentVoucher.class));
        if (Strings.isNullOrEmpty((String)paymentVoucher.getRef())) {
            response.setValue("ref", (Object)((PaymentVoucherSequenceService)Beans.get(PaymentVoucherSequenceService.class)).getReference(paymentVoucher));
        }
    }

    public void loadMoveLines(ActionRequest request, ActionResponse response) {
        PaymentVoucher paymentVoucher = (PaymentVoucher)((Object)request.getContext().asType(PaymentVoucher.class));
        paymentVoucher = (PaymentVoucher)((Object)((PaymentVoucherRepository)((Object)Beans.get(PaymentVoucherRepository.class))).find(paymentVoucher.getId()));
        try {
            ((PaymentVoucherLoadService)Beans.get(PaymentVoucherLoadService.class)).searchDueElements(paymentVoucher);
            response.setReload(true);
        }
        catch (Exception e) {
            TraceBackService.trace((ActionResponse)response, (Throwable)e);
        }
    }

    public void loadSelectedLines(ActionRequest request, ActionResponse response) {
        PaymentVoucher paymentVoucherContext = (PaymentVoucher)((Object)request.getContext().asType(PaymentVoucher.class));
        PaymentVoucher paymentVoucher = (PaymentVoucher)((Object)((PaymentVoucherRepository)((Object)Beans.get(PaymentVoucherRepository.class))).find(paymentVoucherContext.getId()));
        try {
            ((PaymentVoucherLoadService)Beans.get(PaymentVoucherLoadService.class)).loadSelectedLines(paymentVoucher, paymentVoucherContext);
            response.setReload(true);
        }
        catch (Exception e) {
            TraceBackService.trace((ActionResponse)response, (Throwable)e);
        }
    }

    public void resetImputation(ActionRequest request, ActionResponse response) {
        PaymentVoucher paymentVoucherContext = (PaymentVoucher)((Object)request.getContext().asType(PaymentVoucher.class));
        PaymentVoucher paymentVoucher = (PaymentVoucher)((Object)((PaymentVoucherRepository)((Object)Beans.get(PaymentVoucherRepository.class))).find(paymentVoucherContext.getId()));
        try {
            ((PaymentVoucherLoadService)Beans.get(PaymentVoucherLoadService.class)).resetImputation(paymentVoucher);
            response.setReload(true);
        }
        catch (Exception e) {
            TraceBackService.trace((ActionResponse)response, (Throwable)e);
        }
    }

    public void askPaymentVoucher(ActionRequest request, ActionResponse response) {
        PaymentVoucher paymentVoucher = (PaymentVoucher)((Object)request.getContext().asType(PaymentVoucher.class));
        if (paymentVoucher.getHasAutoInput().booleanValue()) {
            PaymentMode paymentMode = paymentVoucher.getPaymentMode();
            Company company = paymentVoucher.getCompany();
            BankDetails companyBankDetails = paymentVoucher.getCompanyBankDetails();
            try {
                Journal journal = ((PaymentModeService)Beans.get(PaymentModeService.class)).getPaymentModeJournal(paymentMode, company, companyBankDetails);
                if (journal.getExcessPaymentOk().booleanValue()) {
                    response.setAlert(I18n.get((String)"No items have been selected. Do you want to continue?"));
                }
            }
            catch (Exception e) {
                TraceBackService.trace((ActionResponse)response, (Throwable)e);
            }
        }
    }

    public void confirmPaymentVoucher(ActionRequest request, ActionResponse response) {
        PaymentVoucher paymentVoucher = (PaymentVoucher)((Object)request.getContext().asType(PaymentVoucher.class));
        paymentVoucher = (PaymentVoucher)((Object)((PaymentVoucherRepository)((Object)Beans.get(PaymentVoucherRepository.class))).find(paymentVoucher.getId()));
        try {
            ((PaymentVoucherConfirmService)Beans.get(PaymentVoucherConfirmService.class)).confirmPaymentVoucher(paymentVoucher);
            response.setReload(true);
        }
        catch (Exception e) {
            TraceBackService.trace((ActionResponse)response, (Throwable)e);
        }
    }

    public void printPaymentVoucher(ActionRequest request, ActionResponse response) throws AxelorException {
        PaymentVoucher paymentVoucher = (PaymentVoucher)((Object)request.getContext().asType(PaymentVoucher.class));
        String name = I18n.get((String)"Payment voucher");
        if (!Strings.isNullOrEmpty((String)paymentVoucher.getReceiptNo())) {
            name = name + " " + paymentVoucher.getReceiptNo();
        }
        String fileLink = ReportFactory.createReport((String)"PaymentVoucher.rptdesign", (String)(name + "-${date}")).addParam("PaymentVoucherId", (Object)paymentVoucher.getId()).addParam("Timezone", paymentVoucher.getCompany() != null ? paymentVoucher.getCompany().getTimezone() : null).generate().getFileLink();
        this.logger.debug("Printing " + name);
        response.setView(ActionView.define((String)name).add("html", fileLink).map());
    }

    public void fillCompanyBankDetails(ActionRequest request, ActionResponse response) throws AxelorException {
        PaymentVoucher paymentVoucher = (PaymentVoucher)((Object)request.getContext().asType(PaymentVoucher.class));
        PaymentMode paymentMode = paymentVoucher.getPaymentMode();
        Company company = paymentVoucher.getCompany();
        Partner partner = paymentVoucher.getPartner();
        if (company == null) {
            return;
        }
        if (partner != null) {
            partner = (Partner)((Object)((PartnerRepository)((Object)Beans.get(PartnerRepository.class))).find(partner.getId()));
        }
        BankDetails defaultBankDetails = ((BankDetailsService)Beans.get(BankDetailsService.class)).getDefaultCompanyBankDetails(company, paymentMode, partner, null);
        response.setValue("companyBankDetails", (Object)defaultBankDetails);
    }

    public void initFromInvoice(ActionRequest request, ActionResponse response) {
        PaymentVoucher paymentVoucher = (PaymentVoucher)((Object)request.getContext().asType(PaymentVoucher.class));
        Invoice invoice = (Invoice)((Object)Mapper.toBean(Invoice.class, (Map)((Map)request.getContext().get((Object)"_invoice"))));
        invoice = (Invoice)((Object)((InvoiceRepository)((Object)Beans.get(InvoiceRepository.class))).find(invoice.getId()));
        try {
            ((PaymentVoucherLoadService)Beans.get(PaymentVoucherLoadService.class)).initFromInvoice(paymentVoucher, invoice);
            response.setValues((Object)paymentVoucher);
        }
        catch (Exception e) {
            TraceBackService.trace((ActionResponse)response, (Throwable)e);
        }
    }
}

