/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.csv.script;

import com.axelor.apps.account.db.Invoice;
import com.axelor.apps.account.db.repo.InvoiceRepository;
import com.axelor.apps.account.service.invoice.InvoiceService;
import com.axelor.apps.base.service.AddressService;
import com.axelor.db.Model;
import com.axelor.exception.AxelorException;
import com.google.inject.persist.Transactional;
import java.util.Map;
import javax.inject.Inject;

public class ImportInvoice {
    @Inject
    private AddressService addressService;
    @Inject
    private InvoiceService invoiceService;
    @Inject
    private InvoiceRepository invoiceRepo;

    @Transactional(rollbackOn={Exception.class})
    public Object importInvoice(Object bean, Map<String, Object> values) throws AxelorException {
        assert (bean instanceof Invoice);
        Invoice invoice = (Invoice)((Object)bean);
        if (invoice.getAddress() != null) {
            invoice.setAddressStr(this.addressService.computeAddressStr(invoice.getAddress()));
        }
        this.invoiceRepo.save((Model)((Object)invoice));
        if (invoice.getStatusSelect() == 1) {
            this.invoiceService.setDraftSequence(invoice);
        }
        return invoice;
    }
}

