/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.csv.script;

import com.axelor.apps.account.db.Account;
import com.axelor.apps.account.db.Journal;
import com.axelor.apps.account.db.Move;
import com.axelor.apps.account.db.MoveLine;
import com.axelor.apps.account.db.repo.AccountRepository;
import com.axelor.apps.account.db.repo.JournalRepository;
import com.axelor.apps.account.db.repo.MoveLineRepository;
import com.axelor.apps.account.db.repo.MoveRepository;
import com.axelor.apps.base.db.Company;
import com.axelor.apps.base.db.Partner;
import com.axelor.apps.base.db.repo.CompanyRepository;
import com.axelor.apps.base.db.repo.CurrencyRepository;
import com.axelor.apps.base.db.repo.PartnerRepository;
import com.axelor.apps.base.service.PeriodService;
import com.axelor.auth.AuthUtils;
import com.axelor.auth.db.User;
import com.axelor.db.Model;
import com.axelor.exception.AxelorException;
import com.axelor.exception.service.TraceBackService;
import com.axelor.inject.Beans;
import com.google.inject.Inject;
import java.nio.file.Path;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.Map;
import java.util.Optional;
import javax.transaction.Transactional;

public class ImportMove {
    @Inject
    private MoveRepository moveRepository;
    @Inject
    private MoveLineRepository moveLineRepo;

    @Transactional
    public Object importFECMove(Object bean, Map<String, Object> values) throws AxelorException {
        assert (bean instanceof MoveLine);
        MoveLine moveLine = (MoveLine)((Object)bean);
        try {
            Move move;
            moveLine.setCounter(1);
            if (values.get("EcritureNum") == null) {
                return null;
            }
            String moveReference = values.get("EcritureNum").toString();
            MoveLine mvLine = (MoveLine)((Object)this.moveLineRepo.all().filter("self.name LIKE '" + moveReference + "-%'").order("-counter").fetchOne());
            if (mvLine != null) {
                int counter = mvLine.getCounter() + 1;
                moveLine.setCounter(counter);
            }
            if (values.get("EcritureDate") != null) {
                LocalDate moveLineDate = LocalDate.parse(values.get("EcritureDate").toString(), DateTimeFormatter.BASIC_ISO_DATE);
                moveLine.setDate(moveLineDate);
            }
            if ((move = (Move)((Object)this.moveRepository.all().filter("self.reference = ?", new Object[]{moveReference}).fetchOne())) == null) {
                move = new Move();
                move.setReference(moveReference);
                if (values.get("ValidDate") != null) {
                    move.setStatusSelect(3);
                    move.setValidationDate(LocalDate.parse(values.get("ValidDate").toString(), DateTimeFormatter.BASIC_ISO_DATE));
                } else {
                    move.setStatusSelect(1);
                }
                move.setCompany(this.getCompany(values));
                move.setCompanyCurrency(move.getCompany().getCurrency());
                move.setDate(LocalDate.parse(values.get("EcritureDate").toString(), DateTimeFormatter.BASIC_ISO_DATE));
                move.setPeriod(((PeriodService)Beans.get(PeriodService.class)).getPeriod(move.getDate(), move.getCompany(), 1));
                if (values.get("Idevise") != null) {
                    move.setCurrency(((CurrencyRepository)Beans.get(CurrencyRepository.class)).findByCode(values.get("Idevise").toString()));
                    move.setCurrencyCode(values.get("Idevise").toString());
                }
                if (values.get("JournalCode") != null) {
                    Journal journal = (Journal)((Object)((JournalRepository)((Object)Beans.get(JournalRepository.class))).all().filter("self.code = ?1 AND self.company.id = ?2", new Object[]{values.get("JournalCode").toString(), move.getCompany().getId()}).fetchOne());
                    move.setJournal(journal);
                }
                if (values.get("CompAuxNum") != null) {
                    Partner partner = (Partner)((Object)((PartnerRepository)((Object)Beans.get(PartnerRepository.class))).all().filter("self.partnerSeq = ?", new Object[]{values.get("CompAuxNum").toString()}).fetchOne());
                    move.setPartner(partner);
                }
                this.moveRepository.save((Model)((Object)move));
            }
            if (values.get("CompteNum") != null) {
                Account account = (Account)((Object)((AccountRepository)((Object)Beans.get(AccountRepository.class))).all().filter("self.code = ?1 AND self.company.id = ?2", new Object[]{values.get("CompteNum").toString(), move.getCompany().getId()}).fetchOne());
                moveLine.setAccount(account);
            }
            moveLine.setMove(move);
        }
        catch (Exception e) {
            TraceBackService.trace((Throwable)e);
            throw new AxelorException(4, e.getMessage());
        }
        return moveLine;
    }

    private Company getCompany(Map<String, Object> values) {
        Path path = (Path)values.get("__path__");
        String fileName = path.getFileName().toString();
        String registrationCode = fileName.substring(0, fileName.indexOf(70));
        Company company = (Company)((Object)((CompanyRepository)((Object)Beans.get(CompanyRepository.class))).all().filter("self.partner.registrationCode = ?", new Object[]{registrationCode}).fetchOne());
        if (company != null) {
            return company;
        }
        if (Optional.ofNullable(AuthUtils.getUser()).map(User::getActiveCompany).orElse(null) != null) {
            return Optional.ofNullable(AuthUtils.getUser()).map(User::getActiveCompany).orElse(null);
        }
        return (Company)((Object)((CompanyRepository)((Object)Beans.get(CompanyRepository.class))).all().fetchOne());
    }
}

