/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.csv.script;

import com.axelor.apps.account.db.Invoice;
import com.axelor.apps.account.db.MoveLine;
import com.axelor.apps.account.db.PayVoucherDueElement;
import com.axelor.apps.account.db.PaymentVoucher;
import com.axelor.apps.account.db.repo.InvoiceRepository;
import com.axelor.apps.account.service.payment.paymentvoucher.PaymentVoucherConfirmService;
import com.axelor.apps.account.service.payment.paymentvoucher.PaymentVoucherLoadService;
import com.axelor.apps.account.service.payment.paymentvoucher.PaymentVoucherToolService;
import com.axelor.exception.AxelorException;
import com.axelor.inject.Beans;
import com.google.common.base.Strings;
import com.google.inject.Inject;
import java.math.BigDecimal;
import java.util.Map;

public class ImportPaymentVoucher {
    @Inject
    PaymentVoucherLoadService paymentVoucherLoadService;
    @Inject
    PaymentVoucherToolService paymentVoucherToolService;
    @Inject
    PaymentVoucherConfirmService paymentVoucherConfirmService;

    public Object importPaymentVoucher(Object bean, Map values) {
        assert (bean instanceof PaymentVoucher);
        try {
            PaymentVoucher paymentVoucher = (PaymentVoucher)((Object)bean);
            Invoice invoiceToPay = this.getInvoice((String)values.get("orderImport"));
            MoveLine moveLineToPay = this.getMoveLineToPay(paymentVoucher, invoiceToPay);
            if (moveLineToPay != null) {
                PayVoucherDueElement payVoucherDueElement = this.paymentVoucherLoadService.createPayVoucherDueElement(moveLineToPay);
                paymentVoucher.addPayVoucherElementToPayListItem(this.paymentVoucherLoadService.createPayVoucherElementToPay(payVoucherDueElement, 1));
            }
            if (paymentVoucher.getStatusSelect() == 3) {
                this.paymentVoucherConfirmService.confirmPaymentVoucher(paymentVoucher);
            }
            return paymentVoucher;
        }
        catch (Exception e) {
            e.printStackTrace();
            return bean;
        }
    }

    public Invoice getInvoice(String orderType_orderImportId) {
        if (!Strings.isNullOrEmpty((String)orderType_orderImportId)) {
            String orderType = orderType_orderImportId.split("_")[0];
            String orderImportId = orderType_orderImportId.split("_")[1];
            String filter = orderType.equals("S") ? "self.saleOrder.importId = ?" : "self.purchaseOrder.importId = ?";
            return (Invoice)((Object)((InvoiceRepository)((Object)Beans.get(InvoiceRepository.class))).all().filter(filter, new Object[]{orderImportId}).fetchOne());
        }
        return null;
    }

    public MoveLine getMoveLineToPay(PaymentVoucher paymentVoucher, Invoice invoice) throws AxelorException {
        if (invoice != null) {
            if (this.paymentVoucherToolService.isDebitToPay(paymentVoucher)) {
                return this.getInvoiceDebitMoveline(invoice);
            }
            return this.getInvoiceCreditMoveline(invoice);
        }
        return null;
    }

    public MoveLine getInvoiceDebitMoveline(Invoice invoice) {
        if (invoice.getMove() != null && invoice.getMove().getMoveLineList() != null) {
            for (MoveLine moveLine : invoice.getMove().getMoveLineList()) {
                if (!moveLine.getAccount().equals((Object)invoice.getPartnerAccount()) || !moveLine.getAccount().getUseForPartnerBalance().booleanValue() || moveLine.getDebit().compareTo(BigDecimal.ZERO) <= 0) continue;
                return moveLine;
            }
        }
        return null;
    }

    public MoveLine getInvoiceCreditMoveline(Invoice invoice) {
        if (invoice.getMove() != null && invoice.getMove().getMoveLineList() != null) {
            for (MoveLine moveLine : invoice.getMove().getMoveLineList()) {
                if (!moveLine.getAccount().equals((Object)invoice.getPartnerAccount()) || !moveLine.getAccount().getUseForPartnerBalance().booleanValue() || moveLine.getCredit().compareTo(BigDecimal.ZERO) <= 0) continue;
                return moveLine;
            }
        }
        return null;
    }
}

