/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.impl.document.stream;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.birt.core.archive.RAOutputStream;
import org.eclipse.birt.core.util.IOUtil;
import org.eclipse.birt.data.engine.api.DataEngineContext;
import org.eclipse.birt.data.engine.core.DataException;
import org.eclipse.birt.data.engine.impl.DataEngineSession;

public class VersionManager {
    public static final int VERSION_2_0 = 0;
    public static final int VERSION_2_1 = 1;
    public static final int VERSION_2_2 = 2;
    public static final int VERSION_2_2_0 = 10;
    public static final int VERSION_2_2_1 = 20;
    public static final int VERSION_2_2_1_1 = 25;
    public static final int VERSION_2_2_1_2 = 30;
    public static final int VERSION_2_2_1_3 = 50;
    public static final int VERSION_2_3_1 = 70;
    public static final int VERSION_2_3_2 = 90;
    public static final int VERSION_2_3_2_1 = 95;
    public static final int VERSION_2_5_0_1 = 100;
    public static final int VERSION_2_5_1_0 = 110;
    public static final int VERSION_2_5_1_1 = 120;
    public static final int VERSION_2_5_2_0 = 130;
    public static final int VERSION_2_5_2_1 = 140;
    public static final int VERSION_2_6_2_1 = 150;
    public static final int VERSION_2_6_2_2 = 160;
    public static final int VERSION_2_6_2_3 = 170;
    public static final int VERSION_2_6_3_1 = 180;
    public static final int VERSION_2_6_3_2 = 190;
    public static final int VERSION_3_7_2_1 = 200;
    public static final int VERSION_4_2_1_1 = 200;
    public static final int VERSION_4_2_1_2 = 210;
    public static final int VERSION_4_2_2_1 = 220;
    public static final int VERSION_4_2_2 = 300;
    private DataEngineContext dataEngineContext;
    private static Logger logger = Logger.getLogger(VersionManager.class.getName());

    public VersionManager(DataEngineContext context) {
        this.dataEngineContext = context;
    }

    private int getVersion() {
        int version = VersionManager.getLatestVersion();
        if (!this.dataEngineContext.hasInStream(null, null, 11)) {
            version = 0;
            return version;
        }
        try {
            DataInputStream is = new DataInputStream(this.dataEngineContext.getInputStream(null, null, 11));
            version = IOUtil.readInt(is);
            is.close();
        }
        catch (DataException e) {
            logger.log(Level.FINE, e.getMessage(), e);
        }
        catch (IOException e) {
            logger.log(Level.FINE, e.getMessage(), e);
        }
        return version;
    }

    private void setVersion(int version) throws DataException {
        RAOutputStream versionOs = this.dataEngineContext.getOutputStream(null, null, 11);
        DataOutputStream versionDos = new DataOutputStream(versionOs);
        try {
            IOUtil.writeInt(versionDos, version);
            versionDos.close();
            versionOs.close();
        }
        catch (IOException e) {
            throw new DataException("data.engine.SaveReportDocumentError", e);
        }
    }

    void setVersion(int version, String queryResultId) throws DataException {
        if (queryResultId == null || queryResultId.trim().length() == 0) {
            this.setVersion(version);
            return;
        }
        Map<String, Integer> idVersionMap = this.getQueryIdVersionMap();
        idVersionMap.put(queryResultId, version);
        DataEngineSession.getVersionForQuRsMap().put(queryResultId, version);
        this.dataEngineContext.dropStream(null, null, 130);
        RAOutputStream versionOs = this.dataEngineContext.getOutputStream(null, null, 130);
        DataOutputStream versionDos = new DataOutputStream(versionOs);
        try {
            IOUtil.writeMap(versionDos, idVersionMap);
            versionDos.close();
            versionOs.close();
        }
        catch (IOException e) {
            throw new DataException("data.engine.SaveReportDocumentError", e);
        }
    }

    private Map<String, Integer> getQueryIdVersionMap() throws DataException {
        Map<String, Integer> result = new HashMap<String, Integer>();
        if (!this.dataEngineContext.hasInStream(null, null, 130)) {
            return result;
        }
        try {
            DataInputStream is = new DataInputStream(this.dataEngineContext.getInputStream(null, null, 130));
            result = IOUtil.readMap(is);
            is.close();
        }
        catch (DataException e) {
            logger.log(Level.FINE, e.getMessage(), e);
        }
        catch (IOException e) {
            logger.log(Level.FINE, e.getMessage(), e);
        }
        DataEngineSession.getVersionForQuRsMap().putAll(result);
        return DataEngineSession.getVersionForQuRsMap();
    }

    public int getVersion(String queryResultId) throws DataException {
        Integer version;
        if (queryResultId != null && queryResultId.trim().length() > 0 && (version = this.getQueryIdVersionMap().get(queryResultId)) != null) {
            return version;
        }
        return this.getVersion();
    }

    public static int getLatestVersion() {
        return 300;
    }
}

