/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.supplierportal.db;

import com.axelor.apps.base.db.Currency;
import com.axelor.apps.base.db.Product;
import com.axelor.apps.base.db.Unit;
import com.axelor.auth.db.AuditableModel;
import com.axelor.db.annotations.HashKey;
import com.axelor.db.annotations.Widget;
import com.axelor.meta.db.MetaFile;
import com.google.common.base.MoreObjects;
import java.math.BigDecimal;
import java.util.Objects;
import javax.persistence.Basic;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Index;
import javax.persistence.Lob;
import javax.persistence.ManyToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.validation.constraints.Digits;
import org.hibernate.annotations.Type;

@Entity
@Table(name="SUPPLIERPORTAL_PRODUCT_SUPPLIER", indexes={@Index(columnList="img_product"), @Index(columnList="purchase_unit"), @Index(columnList="purchase_currency"), @Index(columnList="product_created")})
public class ProductSupplier
extends AuditableModel {
    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="SUPPLIERPORTAL_PRODUCT_SUPPLIER_SEQ")
    @SequenceGenerator(name="SUPPLIERPORTAL_PRODUCT_SUPPLIER_SEQ", sequenceName="SUPPLIERPORTAL_PRODUCT_SUPPLIER_SEQ", allocationSize=1)
    private Long id;
    @HashKey
    @Widget(title="Code")
    @Column(unique=true)
    private String productCode;
    @Widget(title="Name")
    private String productName;
    @Widget(title="Picture")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private MetaFile imgProduct;
    @Widget(title="Purchase unit")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Unit purchaseUnit;
    @Widget(title="Purchase price W.T.")
    @Digits(integer=10, fraction=10)
    private BigDecimal purchasePrice = BigDecimal.ZERO;
    @Widget(title="Purchase currency")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Currency purchaseCurrency;
    @Widget(title="Description", translatable=true)
    @Lob
    @Basic(fetch=FetchType.LAZY)
    @Type(type="text")
    private String description;
    @Widget(title="Product created", readonly=true)
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Product productCreated;
    @Widget(title="Attributes")
    @Basic(fetch=FetchType.LAZY)
    @Type(type="json")
    private String attrs;

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getProductCode() {
        return this.productCode;
    }

    public void setProductCode(String productCode) {
        this.productCode = productCode;
    }

    public String getProductName() {
        return this.productName;
    }

    public void setProductName(String productName) {
        this.productName = productName;
    }

    public MetaFile getImgProduct() {
        return this.imgProduct;
    }

    public void setImgProduct(MetaFile imgProduct) {
        this.imgProduct = imgProduct;
    }

    public Unit getPurchaseUnit() {
        return this.purchaseUnit;
    }

    public void setPurchaseUnit(Unit purchaseUnit) {
        this.purchaseUnit = purchaseUnit;
    }

    public BigDecimal getPurchasePrice() {
        return this.purchasePrice == null ? BigDecimal.ZERO : this.purchasePrice;
    }

    public void setPurchasePrice(BigDecimal purchasePrice) {
        this.purchasePrice = purchasePrice;
    }

    public Currency getPurchaseCurrency() {
        return this.purchaseCurrency;
    }

    public void setPurchaseCurrency(Currency purchaseCurrency) {
        this.purchaseCurrency = purchaseCurrency;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public Product getProductCreated() {
        return this.productCreated;
    }

    public void setProductCreated(Product productCreated) {
        this.productCreated = productCreated;
    }

    public String getAttrs() {
        return this.attrs;
    }

    public void setAttrs(String attrs) {
        this.attrs = attrs;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof ProductSupplier)) {
            return false;
        }
        ProductSupplier other = (ProductSupplier)((Object)obj);
        if (this.getId() != null || other.getId() != null) {
            return Objects.equals(this.getId(), other.getId());
        }
        return Objects.equals(this.getProductCode(), other.getProductCode());
    }

    public int hashCode() {
        return Objects.hash(1781433275, this.getProductCode());
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)((Object)this)).add("id", (Object)this.getId()).add("productCode", (Object)this.getProductCode()).add("productName", (Object)this.getProductName()).add("purchasePrice", (Object)this.getPurchasePrice()).omitNullValues().toString();
    }
}

