/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.supplierportal.service;

import com.axelor.apps.base.db.Product;
import com.axelor.apps.base.db.repo.ProductRepository;
import com.axelor.apps.supplierportal.db.ProductSupplier;
import com.axelor.apps.supplierportal.db.repo.ProductSupplierRepository;
import com.axelor.apps.supplierportal.service.ProductSupplierService;
import com.axelor.db.Model;
import com.axelor.exception.AxelorException;
import com.axelor.i18n.I18n;
import com.axelor.inject.Beans;
import com.google.inject.persist.Transactional;

public class ProductSupplierServiceImpl
implements ProductSupplierService {
    @Override
    @Transactional(rollbackOn={Exception.class})
    public Product addOnCatalog(ProductSupplier productSupplier) throws AxelorException {
        ProductRepository productRepo = (ProductRepository)((Object)Beans.get(ProductRepository.class));
        if (productSupplier.getProductCode() == null) {
            throw new AxelorException((Model)((Object)productSupplier), 3, I18n.get((String)"Product has no code."));
        }
        if (productSupplier.getProductName() == null) {
            throw new AxelorException((Model)((Object)productSupplier), 3, I18n.get((String)"Product has no name."), new Object[]{productSupplier.getProductCode()});
        }
        if (productRepo.findByCode(productSupplier.getProductCode()) != null) {
            throw new AxelorException((Model)((Object)productSupplier), 4, I18n.get((String)"The code is already in database. Please choose another one."));
        }
        Product productCreated = this.createProductFromProductSupplier(productSupplier);
        productSupplier.setProductCreated(productCreated);
        ((ProductSupplierRepository)((Object)Beans.get(ProductSupplierRepository.class))).save((Model)((Object)productSupplier));
        return productCreated;
    }

    protected Product createProductFromProductSupplier(ProductSupplier productSupplier) {
        Product product = new Product(productSupplier.getProductCode(), productSupplier.getProductCode(), productSupplier.getDescription(), null, productSupplier.getImgProduct(), null, null, productSupplier.getPurchaseUnit(), null, "storable", null, productSupplier.getPurchaseCurrency(), productSupplier.getPurchaseCurrency(), null, null);
        product.setPurchasePrice(productSupplier.getPurchasePrice());
        return product;
    }
}

