/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.supplierportal.service;

import com.axelor.apps.base.service.user.UserService;
import com.axelor.apps.supplierportal.service.SupplierViewService;
import com.axelor.auth.db.User;
import com.axelor.inject.Beans;
import java.time.format.DateTimeFormatter;
import java.util.HashMap;
import java.util.Map;

public class SupplierViewServiceImpl
implements SupplierViewService {
    protected static final DateTimeFormatter DATE_FORMATTER = DateTimeFormatter.ofPattern("dd/MM/yyyy");

    @Override
    public User getSupplierUser() {
        return ((UserService)Beans.get(UserService.class)).getUser();
    }

    @Override
    public Map<String, Object> updateSupplierViewIndicators() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("$orders", 2);
        map.put("$quotationInProgress", 4);
        map.put("$lastOrder", "19/02/2019");
        map.put("$lastDelivery", "15/01/2019");
        map.put("$nextDelivery", "28/02/2019");
        map.put("$deliveriesToPrepare", 4);
        map.put("$overdueInvoices", 1);
        map.put("$awaitingInvoices", 1);
        map.put("$totalRemaining", 157);
        map.put("$supplierTickets", 2);
        map.put("$companyTickets", 105);
        map.put("$resolvedTickets", 84);
        return map;
    }

    @Override
    public String getPurchaseOrdersOfSupplier(User user) {
        return "self.supplierPartner.id = " + user.getPartner().getId() + " AND self.statusSelect IN (" + 4 + "," + 3 + ")";
    }

    @Override
    public String getPurchaseQuotationsInProgressOfSupplier(User user) {
        return "self.supplierPartner.id = " + user.getPartner().getId() + " AND self.statusSelect IN (" + 1 + "," + 2 + ")";
    }

    @Override
    public String getLastPurchaseOrderOfSupplier(User user) {
        return "self.supplierPartner.id = " + user.getPartner().getId() + " AND self.statusSelect = " + 4 + " ORDER BY self.validationDate DESC";
    }

    @Override
    public String getLastDeliveryOfSupplier(User user) {
        return "self.partner.id = " + user.getPartner().getId() + " AND self.typeSelect = " + 3 + " AND self.statusSelect = " + 3 + " ORDER BY self.realDate DESC";
    }

    @Override
    public String getNextDeliveryOfSupplier(User user) {
        return "self.partner.id = " + user.getPartner().getId() + " AND self.typeSelect = " + 3 + " AND self.statusSelect = " + 2 + " ORDER BY self.estimatedDate ASC";
    }

    @Override
    public String getDeliveriesToPrepareOfSupplier(User user) {
        return "self.partner.id = " + user.getPartner().getId() + " AND self.typeSelect = " + 3 + " AND self.statusSelect IN (" + 1 + ", " + 1 + ", " + 2 + ")";
    }

    @Override
    public String getAwaitingInvoicesOfSupplier(User user) {
        return "self.partner.id = " + user.getPartner().getId() + " AND self.dueDate < current_date()  AND self.amountRemaining != 0 AND self.statusSelect != " + 4;
    }

    @Override
    public String getTotalRemainingOfSupplier(User user) {
        return "self.partner.id = " + user.getPartner().getId() + " AND self.amountRemaining != 0 AND self.statusSelect != " + 4;
    }
}

