/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.supplierportal.web;

import com.axelor.apps.account.db.Invoice;
import com.axelor.apps.purchase.db.PurchaseOrder;
import com.axelor.apps.stock.db.StockMove;
import com.axelor.apps.supplierportal.service.SupplierViewService;
import com.axelor.auth.db.User;
import com.axelor.exception.service.TraceBackService;
import com.axelor.i18n.I18n;
import com.axelor.inject.Beans;
import com.axelor.meta.schema.actions.ActionView;
import com.axelor.rpc.ActionRequest;
import com.axelor.rpc.ActionResponse;
import java.util.Map;

public class SupplierViewController {
    public void completeSupplierViewIndicators(ActionRequest request, ActionResponse response) {
        try {
            Map<String, Object> map = ((SupplierViewService)Beans.get(SupplierViewService.class)).updateSupplierViewIndicators();
            response.setValues(map);
        }
        catch (Exception e) {
            TraceBackService.trace((ActionResponse)response, (Throwable)e);
        }
    }

    public void getPurchaseOrders(ActionRequest request, ActionResponse response) {
        try {
            SupplierViewService supplierViewService = (SupplierViewService)Beans.get(SupplierViewService.class);
            User user = supplierViewService.getSupplierUser();
            String domain = ((SupplierViewService)Beans.get(SupplierViewService.class)).getAwaitingInvoicesOfSupplier(user);
            response.setView(ActionView.define((String)I18n.get((String)"Purchase orders")).model(PurchaseOrder.class.getName()).add("grid", "purchase-order-grid").add("form", "purchase-order-form").domain(domain).map());
        }
        catch (Exception e) {
            TraceBackService.trace((ActionResponse)response, (Throwable)e);
        }
    }

    public void getPurchaseQuotationInProgress(ActionRequest request, ActionResponse response) {
        try {
            SupplierViewService supplierViewService = (SupplierViewService)Beans.get(SupplierViewService.class);
            User user = supplierViewService.getSupplierUser();
            String domain = ((SupplierViewService)Beans.get(SupplierViewService.class)).getPurchaseQuotationsInProgressOfSupplier(user);
            response.setView(ActionView.define((String)I18n.get((String)"Quotation In Progress")).model(PurchaseOrder.class.getName()).add("grid", "purchase-order-grid").add("form", "purchase-order-form").domain(domain).map());
        }
        catch (Exception e) {
            TraceBackService.trace((ActionResponse)response, (Throwable)e);
        }
    }

    public void getLastOrder(ActionRequest request, ActionResponse response) {
        try {
            SupplierViewService supplierViewService = (SupplierViewService)Beans.get(SupplierViewService.class);
            User user = supplierViewService.getSupplierUser();
            String domain = ((SupplierViewService)Beans.get(SupplierViewService.class)).getLastPurchaseOrderOfSupplier(user);
            response.setView(ActionView.define((String)I18n.get((String)"Last order")).model(PurchaseOrder.class.getName()).add("grid", "purchase-order-grid").add("form", "purchase-order-form").domain(domain).map());
        }
        catch (Exception e) {
            TraceBackService.trace((ActionResponse)response, (Throwable)e);
        }
    }

    public void getLastDelivery(ActionRequest request, ActionResponse response) {
        try {
            SupplierViewService supplierViewService = (SupplierViewService)Beans.get(SupplierViewService.class);
            User user = supplierViewService.getSupplierUser();
            String domain = ((SupplierViewService)Beans.get(SupplierViewService.class)).getLastDeliveryOfSupplier(user);
            response.setView(ActionView.define((String)I18n.get((String)"Last delivery")).model(StockMove.class.getName()).add("grid", "stock-move-supplier-grid").add("form", "stock-move-supplier-form").domain(domain).map());
        }
        catch (Exception e) {
            TraceBackService.trace((ActionResponse)response, (Throwable)e);
        }
    }

    public void getNextDelivery(ActionRequest request, ActionResponse response) {
        try {
            SupplierViewService supplierViewService = (SupplierViewService)Beans.get(SupplierViewService.class);
            User user = supplierViewService.getSupplierUser();
            String domain = ((SupplierViewService)Beans.get(SupplierViewService.class)).getNextDeliveryOfSupplier(user);
            response.setView(ActionView.define((String)I18n.get((String)"Next delivery")).model(StockMove.class.getName()).add("grid", "stock-move-supplier-grid").add("form", "stock-move-supplier-form").domain(domain).map());
        }
        catch (Exception e) {
            TraceBackService.trace((ActionResponse)response, (Throwable)e);
        }
    }

    public void getDeliveriesToPrepare(ActionRequest request, ActionResponse response) {
        try {
            SupplierViewService supplierViewService = (SupplierViewService)Beans.get(SupplierViewService.class);
            User user = supplierViewService.getSupplierUser();
            String domain = ((SupplierViewService)Beans.get(SupplierViewService.class)).getDeliveriesToPrepareOfSupplier(user);
            response.setView(ActionView.define((String)I18n.get((String)"Deliveries to prepare")).model(StockMove.class.getName()).add("grid", "stock-move-supplier-grid").add("form", "stock-move-supplier-form").domain(domain).map());
        }
        catch (Exception e) {
            TraceBackService.trace((ActionResponse)response, (Throwable)e);
        }
    }

    public void getOverdueInvoice(ActionRequest request, ActionResponse response) {
        try {
            SupplierViewService supplierViewService = (SupplierViewService)Beans.get(SupplierViewService.class);
            User user = supplierViewService.getSupplierUser();
            String domain = ((SupplierViewService)Beans.get(SupplierViewService.class)).getAwaitingInvoicesOfSupplier(user);
            response.setView(ActionView.define((String)I18n.get((String)"Overdue invoices")).model(Invoice.class.getName()).add("grid", "invoice-grid").add("form", "invoice-form").domain(domain).map());
        }
        catch (Exception e) {
            TraceBackService.trace((ActionResponse)response, (Throwable)e);
        }
    }

    public void getAwaitingInvoice(ActionRequest request, ActionResponse response) {
        try {
            SupplierViewService supplierViewService = (SupplierViewService)Beans.get(SupplierViewService.class);
            User user = supplierViewService.getSupplierUser();
            String domain = ((SupplierViewService)Beans.get(SupplierViewService.class)).getAwaitingInvoicesOfSupplier(user);
            response.setView(ActionView.define((String)I18n.get((String)"Awaiting invoice")).model(Invoice.class.getName()).add("grid", "invoice-grid").add("form", "invoice-form").domain(domain).map());
        }
        catch (Exception e) {
            TraceBackService.trace((ActionResponse)response, (Throwable)e);
        }
    }

    public void getTotalRemaining(ActionRequest request, ActionResponse response) {
        try {
            SupplierViewService supplierViewService = (SupplierViewService)Beans.get(SupplierViewService.class);
            User user = supplierViewService.getSupplierUser();
            String domain = ((SupplierViewService)Beans.get(SupplierViewService.class)).getTotalRemainingOfSupplier(user);
            response.setView(ActionView.define((String)I18n.get((String)"Total remaining")).model(Invoice.class.getName()).add("grid", "invoice-grid").add("form", "invoice-form").domain(domain).map());
        }
        catch (Exception e) {
            TraceBackService.trace((ActionResponse)response, (Throwable)e);
        }
    }
}

