/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.analyzer.impl;

import org.apache.lucene.analysis.Analyzer;
import org.hibernate.search.analyzer.impl.LuceneAnalyzerReference;
import org.hibernate.search.exception.AssertionFailure;
import org.hibernate.search.util.logging.impl.Log;
import org.hibernate.search.util.logging.impl.LoggerFactory;

public class NamedLuceneAnalyzerReference
extends LuceneAnalyzerReference {
    private static final Log LOG = LoggerFactory.make();
    private String name;
    private Analyzer analyzer;

    public NamedLuceneAnalyzerReference(String name) {
        this.name = name;
        this.analyzer = null;
    }

    public NamedLuceneAnalyzerReference(String name, Analyzer analyzer) {
        this.name = name;
        this.analyzer = analyzer;
    }

    public String getAnalyzerName() {
        return this.name;
    }

    @Override
    public Analyzer getAnalyzer() {
        if (this.analyzer == null) {
            throw LOG.lazyLuceneAnalyzerReferenceNotInitialized(this);
        }
        return this.analyzer;
    }

    public boolean isInitialized() {
        return this.analyzer != null;
    }

    public void initialize(Analyzer analyzer) {
        if (this.analyzer != null) {
            throw new AssertionFailure("A lucene analyzer reference has been initialized more than once: " + this);
        }
        this.analyzer = analyzer;
    }

    @Override
    public void close() {
        if (this.analyzer != null) {
            this.analyzer.close();
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getSimpleName());
        sb.append("<");
        if (this.analyzer != null) {
            sb.append(this.analyzer);
        } else {
            sb.append(this.name);
        }
        sb.append(">");
        return sb.toString();
    }
}

