/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.launcher;

import com.axelor.launcher.command.CommandContext;
import com.axelor.launcher.gui.SwingUtils;
import com.axelor.launcher.gui.Tray;
import java.awt.EventQueue;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import org.apache.commons.io.FileUtils;
import org.zeroturnaround.process.PidUtil;
import org.zeroturnaround.process.Processes;

public final class App {
    private static Path getPidFile() {
        return CommandContext.getInstance().fromData("axelor.pid", new String[0]);
    }

    private static int getPid() {
        return PidUtil.getMyPid();
    }

    private static int readPid() {
        try {
            return Integer.parseInt(FileUtils.readFileToString(App.getPidFile().toFile(), StandardCharsets.UTF_8));
        }
        catch (Exception e) {
            return -1;
        }
    }

    private static void writePid() throws IOException {
        Path pidFile = App.getPidFile();
        int pid = App.getPid();
        Files.createDirectories(pidFile.getParent(), new FileAttribute[0]);
        Files.deleteIfExists(pidFile);
        FileUtils.writeStringToFile(pidFile.toFile(), "" + pid, StandardCharsets.UTF_8);
        pidFile.toFile().deleteOnExit();
    }

    private static boolean isRunning() {
        int pid = App.readPid();
        if (pid == -1) {
            return false;
        }
        try {
            return Processes.newPidProcess(pid).isAlive();
        }
        catch (Exception e) {
            return false;
        }
    }

    private static boolean isRootUser() {
        return "root".equals(System.getProperty("user.name"));
    }

    public static void main(String[] args) throws Exception {
        if (App.isRootUser() || App.isRunning()) {
            System.exit(0);
            return;
        }
        App.writePid();
        SwingUtils.setLookAndFeel();
        EventQueue.invokeLater(Tray::start);
    }
}

