/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.launcher.command;

import com.axelor.launcher.command.CallableWorker;
import com.axelor.launcher.command.Command;
import com.axelor.launcher.command.ServiceStatus;
import dorkbox.util.OS;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;

public abstract class AbstractService {
    private List<Consumer<String>> errConsumers = new ArrayList<Consumer<String>>();
    private List<Consumer<ServiceStatus>> statusConsumers = new ArrayList<Consumer<ServiceStatus>>();
    private ServiceStatus status = ServiceStatus.STOPPED;

    public void changed(Consumer<ServiceStatus> status) {
        this.statusConsumers.add(status);
        status.accept(this.getStatus());
    }

    public void addErrConsumer(Consumer<String> line) {
        this.errConsumers.add(line);
    }

    public ServiceStatus getStatus() {
        return this.status;
    }

    protected void setStatus(ServiceStatus status) {
        this.status = status;
        this.statusConsumers.forEach(listener -> listener.accept(status));
    }

    protected void publish(String line) {
        this.errConsumers.forEach(listener -> listener.accept(line));
    }

    public boolean canStart() {
        return this.status == ServiceStatus.STOPPED;
    }

    public boolean canStop() {
        return this.status == ServiceStatus.STARTED;
    }

    public abstract boolean isInitialized();

    public abstract void start();

    public abstract void stop();

    public void open(String ... args) {
        ArrayList<String> command = new ArrayList<String>();
        if (OS.isWindows()) {
            command.add("cmd");
            command.add("/c");
            command.add("start");
        } else if (OS.isMacOsX()) {
            command.add("open");
        } else {
            command.add("xdg-open");
        }
        for (String arg : args) {
            command.add(arg);
        }
        CallableWorker.execute(new Command(command));
    }
}

