/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.launcher.command;

import com.axelor.launcher.command.CommandContext;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.function.Consumer;
import org.zeroturnaround.exec.ProcessExecutor;
import org.zeroturnaround.exec.StartedProcess;
import org.zeroturnaround.exec.stream.LogOutputStream;

public class Command
implements Callable<Integer> {
    private final List<Consumer<String>> errConsumers = new ArrayList<Consumer<String>>();
    private final ProcessExecutor executor;

    public Command(String ... command) {
        this(Arrays.asList(command));
    }

    public Command(List<String> command) {
        this.executor = new ProcessExecutor(command);
        this.executor.redirectOutput(new LogOutputStream(){

            @Override
            protected void processLine(String line) {
                Command.this.publish(line);
            }
        });
    }

    public Command directory(File directory) {
        this.executor.directory(directory);
        return this;
    }

    public Command environment(Map<String, String> environment) {
        this.executor.environment(environment);
        return this;
    }

    public Command environment(String name, String value) {
        this.executor.environment(name, value);
        return this;
    }

    @Override
    public Integer call() throws Exception {
        return this.start().waitFor();
    }

    public Process start() throws IOException {
        CommandContext context = CommandContext.getInstance();
        this.directory(context.dataDir.toFile());
        this.environment(context.environment());
        StartedProcess process = this.executor.start();
        return process.getProcess();
    }

    public void addErrConsumer(Consumer<String> processor) {
        this.errConsumers.add(processor);
    }

    private void publish(String line) {
        this.errConsumers.forEach(c -> c.accept(line));
    }

    public String toString() {
        return String.join((CharSequence)" ", this.executor.getCommand());
    }
}

