/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.launcher.command;

import com.axelor.launcher.command.AbstractService;
import com.axelor.launcher.command.DatabaseService;
import com.axelor.launcher.command.ServiceStatus;
import com.axelor.launcher.command.TomcatService;

public class CompositeService
extends AbstractService {
    private final AbstractService tomcat = new TomcatService();
    private final AbstractService database = new DatabaseService();

    public CompositeService() {
        this.tomcat.addErrConsumer(this::publish);
        this.database.addErrConsumer(this::publish);
        boolean[] started = new boolean[]{false};
        this.database.changed(status -> {
            switch (status) {
                case STOPPED: 
                case STARTING: {
                    this.setStatus((ServiceStatus)((Object)status));
                    started[0] = false;
                    break;
                }
                case STARTED: {
                    this.tomcat.start();
                    break;
                }
            }
        });
        this.tomcat.changed(status -> {
            switch (status) {
                case STOPPING: 
                case STARTED: {
                    this.setStatus((ServiceStatus)((Object)status));
                    started[0] = true;
                    break;
                }
                case STOPPED: {
                    if (!started[0]) break;
                    this.database.stop();
                    break;
                }
            }
        });
    }

    @Override
    protected void publish(String line) {
        super.publish(line);
    }

    @Override
    public boolean isInitialized() {
        return this.database.isInitialized() && this.tomcat.isInitialized();
    }

    @Override
    public void start() {
        this.database.start();
    }

    @Override
    public void stop() {
        this.tomcat.stop();
    }
}

