/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.launcher.command;

import com.axelor.launcher.command.AbstractService;
import com.axelor.launcher.command.CallableWorker;
import com.axelor.launcher.command.Command;
import com.axelor.launcher.command.CommandContext;
import com.axelor.launcher.command.ServiceStatus;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.PosixFilePermission;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.HashSet;
import javax.xml.bind.DatatypeConverter;
import org.apache.commons.io.FileUtils;

public class DatabaseService
extends AbstractService {
    private final CommandContext context = CommandContext.getInstance();
    private final Path pgPassFile;
    private final Path pgPassText;
    private final Path pgRestoreFile;
    private final Path pgMigrateFile;
    private final String dbName;
    private final String dbUser;
    private final String dbPass;
    private final String pgUser;
    private final String pgPass;
    private final Command cmdStart;
    private final Command cmdStop;
    private final Command cmdInit;
    private final Command cmdCreateUser;
    private final Command cmdCreateDb;
    private final Command cmdPgRestore;
    private final Command cmdPgMigrate;

    public DatabaseService() {
        this.pgPassFile = this.context.pgPassFile;
        this.pgPassText = this.context.pgPassText;
        this.pgRestoreFile = this.context.pgRestoreFile;
        this.pgMigrateFile = this.context.pgMigrateFile;
        this.dbName = this.context.settings.getDatabaseName();
        this.dbUser = this.context.dbUser;
        this.dbPass = this.context.dbPass;
        this.pgUser = this.context.pgUser;
        this.pgPass = this.context.pgPass;
        this.cmdStart = new Command(this.context.binPgCtl, "start", "-s", "-l", "logs/postgresql.log");
        this.cmdStop = new Command(this.context.binPgCtl, "stop", "-w");
        this.cmdInit = new Command(this.context.binInitDb, "-U", this.pgUser, "--pwfile", this.pgPassText.getFileName().toString(), "-E", "unicode", "-A", "md5");
        this.cmdCreateUser = new Command(this.context.binPsql, "-U", this.pgUser, "-w", "-c", "CREATE USER " + this.dbUser + " WITH PASSWORD '" + DatabaseService.md5(this.dbPass, this.dbUser) + "';");
        this.cmdCreateDb = new Command(this.context.binCreatedb, "-U", this.pgUser, "-w", "-O", this.dbUser, this.dbName);
        this.cmdPgRestore = new Command(this.context.binPgRestore, "-j", "" + Runtime.getRuntime().availableProcessors(), "-O", "-U", this.pgUser, "--role", this.dbUser, "-d", this.dbName, this.pgRestoreFile.toFile().getPath());
        this.cmdPgMigrate = new Command(this.context.binPsql, "-U", this.pgUser, "-w", "-d", this.dbName, "-a", "-f", this.pgMigrateFile.toFile().getPath());
        this.cmdInit.addErrConsumer(this::publish);
        this.cmdStart.addErrConsumer(this::publish);
        this.cmdCreateUser.addErrConsumer(this::publish);
        this.cmdCreateDb.addErrConsumer(this::publish);
        this.cmdPgMigrate.addErrConsumer(this::publish);
    }

    private static String md5(String passwd, String user) {
        String text = passwd + user;
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            md.update(text.getBytes(), 0, text.length());
            return "md5" + DatatypeConverter.printHexBinary((byte[])md.digest()).toLowerCase();
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
    }

    private String escape(String text, char ch, char escapeCh) {
        StringBuilder sb = new StringBuilder();
        char last = '\u0000';
        for (int i = 0; i < text.length(); ++i) {
            char c = text.charAt(i);
            if (c == ch && last != escapeCh) {
                sb.append(escapeCh);
            }
            last = c;
            sb.append(c);
        }
        return sb.toString();
    }

    private File pwfile() throws IOException {
        File file = this.pgPassText.toFile();
        try (PrintWriter writer = new PrintWriter(file);){
            writer.print(this.pgPass);
            writer.flush();
        }
        return file;
    }

    private File passfile() throws IOException {
        File file = this.pgPassFile.toFile();
        if (file.exists()) {
            file.delete();
        }
        int pgPort = this.context.settings.getDatabasePort();
        try (PrintWriter writer = new PrintWriter(file);){
            writer.println(String.format("localhost:%s:*:%s:%s", pgPort, this.pgUser, this.escape(this.pgPass, ':', '\\')));
            writer.flush();
        }
        try {
            HashSet<PosixFilePermission> perms = new HashSet<PosixFilePermission>();
            perms.add(PosixFilePermission.OWNER_READ);
            perms.add(PosixFilePermission.OWNER_WRITE);
            Files.setPosixFilePermissions(file.toPath(), perms);
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        return file;
    }

    private Integer init() throws Exception {
        if (this.isInitialized()) {
            return 0;
        }
        try {
            this.cmdStop.call();
        }
        catch (Exception exception) {
            // empty catch block
        }
        FileUtils.deleteDirectory(this.context.pgData.toFile());
        Files.createDirectories(this.context.fromData("logs", new String[0]), new FileAttribute[0]);
        this.context.settings.updateDDL("update");
        File pwfile = this.pwfile();
        this.cmdInit.start().waitFor();
        pwfile.delete();
        this.passfile();
        this.cmdStart.start().waitFor();
        Thread.sleep(5000L);
        try {
            this.cmdCreateUser.start().waitFor();
        }
        catch (Exception e) {
            System.err.println("WARN: " + e);
        }
        int res = this.cmdCreateDb.start().waitFor();
        if (Files.exists(this.pgRestoreFile, new LinkOption[0])) {
            this.publish("Restoring database, please wait...");
            res = this.cmdPgRestore.start().waitFor();
            Files.move(this.pgRestoreFile, this.pgRestoreFile.getParent().resolve("done-" + this.pgRestoreFile.getFileName().toString()), new CopyOption[0]);
        }
        if (this.doMigrate() != 0) {
            this.stop();
            return -1;
        }
        return res;
    }

    private int doMigrate() throws Exception {
        if (Files.notExists(this.pgMigrateFile, new LinkOption[0])) {
            return 0;
        }
        this.publish("Migrating database, please wait...");
        Thread.sleep(2000L);
        int res = this.cmdPgMigrate.start().waitFor();
        if (res != 0) {
            return res;
        }
        Files.move(this.pgMigrateFile, this.pgMigrateFile.getParent().resolve("done-" + this.pgMigrateFile.getFileName().toString()), new CopyOption[0]);
        return 0;
    }

    private Integer doStart() throws Exception {
        if (this.isInitialized()) {
            int res = this.cmdStart.start().waitFor();
            if (this.doMigrate() != 0) {
                this.stop();
                return -1;
            }
            return res;
        }
        try {
            return this.init();
        }
        catch (Exception e) {
            try {
                FileUtils.deleteDirectory(this.context.dataDir.toFile());
            }
            catch (IOException iOException) {
                // empty catch block
            }
            throw new RuntimeException(e);
        }
    }

    @Override
    public boolean isInitialized() {
        return Files.exists(this.pgPassFile, new LinkOption[0]) && Files.notExists(this.pgRestoreFile, new LinkOption[0]);
    }

    @Override
    public void start() {
        this.setStatus(ServiceStatus.STARTING);
        CallableWorker.execute(() -> {
            Integer res = this.doStart();
            this.setStatus(ServiceStatus.STARTED);
            return res;
        });
    }

    @Override
    public void stop() {
        this.setStatus(ServiceStatus.STOPPING);
        CallableWorker.execute(() -> {
            Integer res = this.cmdStop.call();
            this.setStatus(ServiceStatus.STOPPED);
            return res;
        });
    }
}

