/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.launcher.gui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.text.BadLocationException;

public final class StatusPanel
extends JPanel {
    private static final long serialVersionUID = -4178490442150994663L;
    private static final int MAX_LINES = 200;
    private JTextArea textLog;

    public StatusPanel() {
        this.setLayout(new BorderLayout());
        this.textLog = new JTextArea();
        this.textLog.setEditable(false);
        this.textLog.setFont(new Font("Monospaced", this.getFont().getStyle(), this.getFont().getSize()));
        this.textLog.setBackground(Color.BLACK);
        this.textLog.setForeground(Color.LIGHT_GRAY);
        this.add((Component)new JScrollPane(this.textLog), "Center");
    }

    public void clear() {
        this.textLog.setText(null);
        this.textLog.setCaretPosition(0);
    }

    public void log(String line) {
        if (this.textLog.getText() == null) {
            this.textLog.setText("\n");
        }
        try {
            int removeLines = this.textLog.getLineCount() - 200;
            if (removeLines > 0) {
                int removePos = this.textLog.getLineEndOffset(removeLines - 1);
                this.textLog.replaceRange("", 0, removePos);
            }
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
        try {
            this.textLog.insert(line + "\n", this.textLog.getLineStartOffset(this.textLog.getLineCount() - 1));
            this.textLog.setCaretPosition(this.textLog.getLineStartOffset(this.textLog.getLineCount() - 1));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

