/*
 * Decompiled with CFR 0.152.
 */
package dorkbox.systemTray;

import dorkbox.systemTray.Menu;
import dorkbox.systemTray.MenuItem;
import dorkbox.systemTray.Tray;
import dorkbox.systemTray.jna.linux.AppIndicator;
import dorkbox.systemTray.jna.linux.Gtk;
import dorkbox.systemTray.nativeUI.NativeUI;
import dorkbox.systemTray.nativeUI._AppIndicatorNativeTray;
import dorkbox.systemTray.nativeUI._AwtTray;
import dorkbox.systemTray.nativeUI._GtkStatusIconNativeTray;
import dorkbox.systemTray.swingUI.SwingUIFactory;
import dorkbox.systemTray.swingUI._SwingTray;
import dorkbox.systemTray.util.ImageUtils;
import dorkbox.systemTray.util.JavaFX;
import dorkbox.systemTray.util.Swt;
import dorkbox.systemTray.util.SystemTrayFixes;
import dorkbox.util.CacheUtil;
import dorkbox.util.IO;
import dorkbox.util.OS;
import dorkbox.util.OSUtil;
import dorkbox.util.Property;
import dorkbox.util.SwingUtil;
import dorkbox.util.process.ShellProcessBuilder;
import java.awt.Component;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileReader;
import java.io.InputStream;
import java.io.PrintStream;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.concurrent.atomic.AtomicReference;
import javax.imageio.stream.ImageInputStream;
import javax.swing.Icon;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JSeparator;
import javax.swing.SwingUtilities;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SystemTray {
    public static final Logger logger;
    @Property
    public static boolean AUTO_TRAY_SIZE;
    @Property
    public static int DEFAULT_TRAY_SIZE;
    @Property
    public static int DEFAULT_MENU_SIZE;
    @Property
    public static boolean FORCE_GTK2;
    @Property
    public static TrayType FORCE_TRAY_TYPE;
    @Property
    public static boolean ENABLE_SHUTDOWN_HOOK;
    @Property
    public static boolean AUTO_FIX_INCONSISTENCIES;
    @Property
    public static SwingUIFactory SWING_UI;
    @Property
    public static boolean DEBUG;
    private static volatile SystemTray systemTray;
    private static volatile Tray systemTrayMenu;
    public static final boolean isJavaFxLoaded;
    public static final boolean isSwtLoaded;

    private static boolean isTrayType(Class<? extends Tray> tray, TrayType trayType) {
        switch (trayType) {
            case GtkStatusIcon: {
                return tray == _GtkStatusIconNativeTray.class;
            }
            case AppIndicator: {
                return tray == _AppIndicatorNativeTray.class;
            }
            case Swing: {
                return tray == _SwingTray.class;
            }
            case AWT: {
                return tray == _AwtTray.class;
            }
        }
        return false;
    }

    private static Class<? extends Tray> selectType(TrayType trayType) throws Exception {
        if (trayType == TrayType.GtkStatusIcon) {
            return _GtkStatusIconNativeTray.class;
        }
        if (trayType == TrayType.AppIndicator) {
            return _AppIndicatorNativeTray.class;
        }
        if (trayType == TrayType.Swing) {
            return _SwingTray.class;
        }
        if (trayType == TrayType.AWT) {
            return _AwtTray.class;
        }
        return null;
    }

    private static Class<? extends Tray> selectTypeQuietly(TrayType trayType) {
        try {
            return SystemTray.selectType(trayType);
        }
        catch (Throwable t) {
            if (DEBUG) {
                logger.error("Cannot initialize {}", (Object)trayType.name(), (Object)t);
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static void init() {
        Class<? extends Tray> trayType;
        block113: {
            block108: {
                if (systemTray != null) {
                    return;
                }
                systemTray = new SystemTray();
                if (OS.isMacOsX() && isJavaFxLoaded && OS.javaVersion <= 7 && !System.getProperty("javafx.macosx.embedded", "false").equals("true")) {
                    logger.error("MacOSX JavaFX (Java7) is incompatible with the SystemTray by default. See issue: 'https://bugs.openjdk.java.net/browse/JDK-8116017'  and 'https://bugs.openjdk.java.net/browse/JDK-8118714'\nTo fix this do one of the following: \n - Upgrade to Java 8\n - Add : '-Djavafx.macosx.embedded=true' as a JVM parameter\n - Set the system property via 'System.setProperty(\"javafx.macosx.embedded\", \"true\");'  before JavaFX isinitialized, used, or accessed. NOTE: You may need to change the class (that your main method is in) so it does NOT extend the JavaFX 'Application' class.");
                    systemTrayMenu = null;
                    systemTray = null;
                    return;
                }
                if (GraphicsEnvironment.isHeadless()) {
                    logger.error("Cannot use the SystemTray in a headless environment");
                    systemTrayMenu = null;
                    systemTray = null;
                    return;
                }
                if (OS.isWindows()) {
                    if (FORCE_TRAY_TYPE != TrayType.AutoDetect && FORCE_TRAY_TYPE != TrayType.Swing) {
                        FORCE_TRAY_TYPE = TrayType.AutoDetect;
                        logger.warn("Windows cannot use the '" + (Object)((Object)FORCE_TRAY_TYPE) + "' SystemTray type, defaulting to Swing");
                    }
                } else if (OS.isMacOsX()) {
                    if (FORCE_TRAY_TYPE != TrayType.AutoDetect && FORCE_TRAY_TYPE != TrayType.Swing && FORCE_TRAY_TYPE != TrayType.AWT) {
                        FORCE_TRAY_TYPE = TrayType.AutoDetect;
                        logger.warn("MacOS cannot use the '" + (Object)((Object)FORCE_TRAY_TYPE) + "' SystemTray type, defaulting to Awt");
                    }
                } else if ((OS.isLinux() || OS.isUnix()) && FORCE_TRAY_TYPE != TrayType.Swing) {
                    if (isSwtLoaded) {
                        boolean isSwt_GTK3;
                        String swt_gtk3 = System.getProperty("SWT_GTK3");
                        boolean bl = isSwt_GTK3 = swt_gtk3 != null && !swt_gtk3.equals("0");
                        if (!isSwt_GTK3) {
                            String property = System.getProperty("org.eclipse.swt.internal.gtk.version");
                            boolean bl2 = isSwt_GTK3 = property != null && !property.startsWith("2.");
                        }
                        if (isSwt_GTK3 && FORCE_GTK2) {
                            logger.error("Unable to use the SystemTray when SWT is configured to use GTK3 and the SystemTray is configured to use GTK2. Please configure SWT to use GTK2, via `System.setProperty(\"SWT_GTK3\", \"0\");` before SWT is initialized, or set `SystemTray.FORCE_GTK2=false;`");
                            systemTrayMenu = null;
                            systemTray = null;
                            return;
                        }
                        if (!isSwt_GTK3 && !FORCE_GTK2 && AUTO_FIX_INCONSISTENCIES) {
                            logger.warn("Forcing GTK2 because SWT is GTK2");
                            FORCE_GTK2 = true;
                        }
                    } else if (isJavaFxLoaded) {
                        boolean isJFX_GTK3 = System.getProperty("jdk.gtk.version", "2").equals("3");
                        if (isJFX_GTK3 && FORCE_GTK2) {
                            if (OS.javaVersion == 9 && AUTO_FIX_INCONSISTENCIES) {
                                logger.warn("Unable to use the SystemTray when JavaFX is configured to use GTK3 and the SystemTray is configured to use GTK2. Please configure JavaFX to use GTK2 (via `System.setProperty(\"jdk.gtk.version\", \"3\");`) before JavaFX is initialized, or set `SystemTray.FORCE_GTK2=false;`  Undoing `FORCE_GTK2`.");
                                FORCE_GTK2 = false;
                                break block108;
                            } else {
                                logger.error("Unable to use the SystemTray when JavaFX is configured to use GTK3 and the SystemTray is configured to use GTK2. Please set `SystemTray.FORCE_GTK2=false;`  if that is not possible then it will not work.");
                                systemTrayMenu = null;
                                systemTray = null;
                                return;
                            }
                        }
                        if (!isJFX_GTK3 && !FORCE_GTK2 && AUTO_FIX_INCONSISTENCIES) {
                            logger.warn("Forcing GTK2 because JavaFX is GTK2");
                            FORCE_GTK2 = true;
                        }
                    }
                }
            }
            trayType = null;
            if (DEBUG) {
                logger.debug("OS: {}", (Object)System.getProperty("os.name"));
                logger.debug("Arch: {}", (Object)System.getProperty("os.arch"));
                String jvmName = System.getProperty("java.vm.name", "");
                String jvmVersion = System.getProperty("java.version", "");
                String jvmVendor = System.getProperty("java.vm.specification.vendor", "");
                logger.debug("{} {} {}", jvmVendor, jvmName, jvmVersion);
                logger.debug("Is AutoTraySize? {}", (Object)AUTO_TRAY_SIZE);
                logger.debug("Is JavaFX detected? {}", (Object)isJavaFxLoaded);
                logger.debug("Is SWT detected? {}", (Object)isSwtLoaded);
                logger.debug("Forced tray type: {}", (Object)FORCE_TRAY_TYPE.name());
                logger.debug("FORCE_GTK2: {}", (Object)FORCE_GTK2);
            }
            if (OS.isWindows()) {
                SystemTrayFixes.fixWindows();
                try {
                    trayType = SystemTray.selectType(TrayType.Swing);
                }
                catch (Throwable e) {
                    logger.error("You might need to grant the AWTPermission `accessSystemTray` to the SecurityManager.");
                }
            } else if (OS.isMacOsX()) {
                SystemTrayFixes.fixMacOS();
                try {
                    trayType = SystemTray.selectType(TrayType.AWT);
                }
                catch (Throwable e) {
                    logger.error("You might need to grant the AWTPermission `accessSystemTray` to the SecurityManager.");
                }
            } else if (OS.isLinux() || OS.isUnix()) {
                block110: {
                    boolean isReallyGnome;
                    String XDG;
                    if (FORCE_TRAY_TYPE != TrayType.AutoDetect) {
                        trayType = SystemTray.selectTypeQuietly(FORCE_TRAY_TYPE);
                    }
                    if (FORCE_TRAY_TYPE == TrayType.Swing && isSwtLoaded) {
                        if (!AUTO_FIX_INCONSISTENCIES) {
                            logger.error("Cannot initialize Swing type if SWT is loaded.");
                            systemTrayMenu = null;
                            systemTray = null;
                            return;
                        }
                        logger.warn("Forcing AWT because SWT cannot load Swing type.");
                        trayType = SystemTray.selectTypeQuietly(TrayType.AWT);
                    }
                    if ((XDG = System.getenv("XDG_CURRENT_DESKTOP")) == null) {
                        XDG = "unknown";
                    }
                    if (isReallyGnome = OSUtil.DesktopEnv.isGnome()) {
                        if (DEBUG) {
                            logger.error("Auto-detected that gnome-shell is running");
                        }
                        XDG = "gnome";
                    }
                    if (DEBUG) {
                        logger.debug("Currently using the '{}' desktop", (Object)XDG);
                    }
                    if (trayType == null) {
                        if ("unity".equalsIgnoreCase(XDG)) {
                            trayType = SystemTray.selectTypeQuietly(TrayType.AppIndicator);
                        } else if ("xfce".equalsIgnoreCase(XDG)) {
                            trayType = SystemTray.selectTypeQuietly(TrayType.GtkStatusIcon);
                        } else if ("lxde".equalsIgnoreCase(XDG)) {
                            trayType = SystemTray.selectTypeQuietly(TrayType.GtkStatusIcon);
                        } else if ("kde".equalsIgnoreCase(XDG)) {
                            trayType = OSUtil.Linux.isFedora() ? SystemTray.selectTypeQuietly(TrayType.GtkStatusIcon) : SystemTray.selectTypeQuietly(TrayType.AppIndicator);
                        } else if ("pantheon".equalsIgnoreCase(XDG)) {
                            trayType = SystemTray.selectTypeQuietly(TrayType.AppIndicator);
                        } else if ("gnome".equalsIgnoreCase(XDG)) {
                            String GDM = System.getenv("GDMSESSION");
                            if (DEBUG) {
                                logger.debug("Currently using the '{}' session type", (Object)GDM);
                            }
                            if ("gnome".equalsIgnoreCase(GDM)) {
                                Tray.usingGnome = true;
                                if (OSUtil.Linux.isFedora()) {
                                    if (DEBUG) {
                                        logger.debug("Running Fedora");
                                    }
                                    trayType = SystemTray.selectTypeQuietly(TrayType.GtkStatusIcon);
                                } else {
                                    trayType = OSUtil.Linux.isUbuntu() ? SystemTray.selectTypeQuietly(TrayType.GtkStatusIcon) : (OSUtil.Unix.isFreeBSD() ? SystemTray.selectTypeQuietly(TrayType.GtkStatusIcon) : SystemTray.selectTypeQuietly(TrayType.AppIndicator));
                                }
                            } else if ("cinnamon".equalsIgnoreCase(GDM)) {
                                trayType = SystemTray.selectTypeQuietly(TrayType.GtkStatusIcon);
                            } else if ("default".equalsIgnoreCase(GDM)) {
                                if (OSUtil.Linux.isDebian()) {
                                    logger.warn("Debian with Gnome detected. SystemTray support is not known to work.");
                                }
                                trayType = SystemTray.selectTypeQuietly(TrayType.GtkStatusIcon);
                            } else if ("gnome-classic".equalsIgnoreCase(GDM)) {
                                trayType = SystemTray.selectTypeQuietly(TrayType.GtkStatusIcon);
                            } else if ("gnome-fallback".equalsIgnoreCase(GDM)) {
                                trayType = SystemTray.selectTypeQuietly(TrayType.GtkStatusIcon);
                            } else if ("ubuntu".equalsIgnoreCase(GDM)) {
                                trayType = SystemTray.selectTypeQuietly(TrayType.AppIndicator);
                            }
                        }
                    }
                    if (trayType == null) {
                        BufferedReader bin = null;
                        try {
                            File proc = new File("/proc");
                            File[] listFiles = proc.listFiles();
                            if (listFiles == null) break block110;
                            for (File procs : listFiles) {
                                block111: {
                                    block112: {
                                        File status;
                                        String name = procs.getName();
                                        if (!Character.isDigit(name.charAt(0)) || !(status = new File(procs, "status")).canRead()) continue;
                                        try {
                                            bin = new BufferedReader(new FileReader(status));
                                            String readLine = bin.readLine();
                                            if (readLine == null || !readLine.contains("indicator-app")) break block111;
                                            try {
                                                trayType = SystemTray.selectType(TrayType.AppIndicator);
                                            }
                                            catch (Exception e) {
                                                if (DEBUG) {
                                                    logger.error("AppIndicator support detected, but unable to load the library. Falling back to GTK", e);
                                                    break block112;
                                                }
                                                logger.error("AppIndicator support detected, but unable to load the library. Falling back to GTK");
                                            }
                                        }
                                        catch (Throwable throwable) {
                                            IO.closeQuietly(bin);
                                            throw throwable;
                                        }
                                    }
                                    IO.closeQuietly(bin);
                                    break;
                                }
                                IO.closeQuietly(bin);
                            }
                        }
                        catch (Throwable e) {
                            if (!DEBUG) break block110;
                            logger.error("Error detecting gnome version", e);
                        }
                    }
                }
                if (trayType == null) {
                    trayType = SystemTray.selectTypeQuietly(TrayType.GtkStatusIcon);
                    logger.warn("Unable to determine the system window manager type. Falling back to GtkStatusIcon.");
                }
                if (trayType == null) {
                    logger.error("SystemTray initialization failed. Unable to load the system tray native libraries. Please write an issue and include your OS type and configuration");
                    systemTrayMenu = null;
                    systemTray = null;
                    return;
                }
                if (SystemTray.isTrayType(trayType, TrayType.AppIndicator)) {
                    String sudoUser = System.getenv("SUDO_USER");
                    if (sudoUser != null) {
                        logger.error("Attempting to load the SystemTray as the 'root' user. This will likely not work because of dbus restrictions.");
                    } else {
                        try {
                            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(8196);
                            PrintStream outputStream = new PrintStream(byteArrayOutputStream);
                            ShellProcessBuilder shell = new ShellProcessBuilder(outputStream);
                            shell.setExecutable("id");
                            shell.addArgument("-u");
                            shell.start();
                            String output = ShellProcessBuilder.getOutput(byteArrayOutputStream);
                            if ("0".equals(output)) {
                                logger.error("Attempting to load the SystemTray as the 'root' user. This will likely not work because of dbus restrictions.");
                            }
                        }
                        catch (Throwable e) {
                            if (!DEBUG) break block113;
                            logger.error("Cannot get id for root", e);
                        }
                    }
                }
            }
        }
        if (trayType == null) {
            logger.error("SystemTray initialization failed. (Unable to discover which implementation to use). Something is seriously wrong.");
            systemTrayMenu = null;
            systemTray = null;
            return;
        }
        ImageUtils.determineIconSize();
        final AtomicReference<Tray> reference = new AtomicReference<Tray>();
        CacheUtil.tempDir = "SysTray";
        try {
            if (OS.isLinux() || OS.isUnix()) {
                if (!Gtk.isLoaded) {
                    logger.error("Unable to initialize GTK! Something is severely wrong!");
                    systemTrayMenu = null;
                    systemTray = null;
                    return;
                }
                if (OSUtil.Linux.isArch() && SystemTray.isTrayType(trayType, TrayType.AppIndicator) && !AppIndicator.isLoaded) {
                    if (Gtk.isGtk2) {
                        logger.error("Unable to initialize AppIndicator for Arch linux, it requires GTK2! Please install libappindicator, for example: 'sudo pacman -S libappindicator'");
                        systemTrayMenu = null;
                        systemTray = null;
                        return;
                    }
                    logger.error("Unable to initialize AppIndicator for Arch linux, it requires GTK3! Please install libappindicator3, for example: 'sudo pacman -S libappindicator3'");
                    systemTrayMenu = null;
                    systemTray = null;
                    return;
                }
                if (SystemTray.isTrayType(trayType, TrayType.AppIndicator)) {
                    if (Gtk.isGtk2 && AppIndicator.isVersion3) {
                        try {
                            trayType = SystemTray.selectType(TrayType.GtkStatusIcon);
                            logger.warn("AppIndicator3 detected with GTK2, falling back to GTK2 system tray type.  Please install libappindicator1 OR GTK3, for example: 'sudo apt-get install libappindicator1'");
                        }
                        catch (Throwable e) {
                            if (DEBUG) {
                                logger.error("Cannot initialize _GtkStatusIconTray", e);
                            }
                            logger.error("AppIndicator3 detected with GTK2 and unable to fallback to using GTK2 system tray type.AppIndicator3 requires GTK3 to be fully functional, and while this will work -- the menu icons WILL NOT be visible. Please install libappindicator1 OR GTK3, for example: 'sudo apt-get install libappindicator1'");
                            systemTrayMenu = null;
                            systemTray = null;
                            return;
                        }
                    }
                    if (!AppIndicator.isLoaded) {
                        logger.warn("Unable to initialize the AppIndicator correctly, falling back to GtkStatusIcon type");
                        trayType = SystemTray.selectTypeQuietly(TrayType.GtkStatusIcon);
                    }
                }
            }
            if (isJavaFxLoaded) {
                JavaFX.init();
            } else if (isSwtLoaded) {
                Swt.init();
            }
            if ((isJavaFxLoaded || isSwtLoaded) && SwingUtilities.isEventDispatchThread()) {
                logger.error("SystemTray initialization for JavaFX or SWT **CAN NOT** occur on the Swing Event Dispatch Thread (EDT). Something is seriously wrong.");
                systemTrayMenu = null;
                systemTray = null;
                return;
            }
            if (isJavaFxLoaded || isSwtLoaded || (OS.isLinux() || OS.isUnix()) && NativeUI.class.isAssignableFrom(trayType) && trayType != _AwtTray.class) {
                try {
                    reference.set((Tray)trayType.getConstructors()[0].newInstance(systemTray));
                }
                catch (Exception e) {
                    logger.error("Unable to create tray type: '" + trayType.getSimpleName() + "'", e);
                }
            } else {
                if (trayType == _AwtTray.class) {
                    Toolkit.getDefaultToolkit();
                }
                final Class<? extends Tray> finalTrayType = trayType;
                SwingUtil.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            reference.set((Tray)finalTrayType.getConstructors()[0].newInstance(systemTray));
                        }
                        catch (Exception e) {
                            logger.error("Unable to create tray type: '" + finalTrayType.getSimpleName() + "'", e);
                        }
                    }
                });
            }
        }
        catch (Exception e) {
            logger.error("Unable to create tray type: '" + trayType.getSimpleName() + "'", e);
        }
        systemTrayMenu = (Tray)reference.get();
        if (systemTrayMenu != null) {
            if (DEBUG) {
                logger.info("Successfully loaded type: {}", (Object)trayType.getSimpleName());
            } else {
                logger.info("Successfully loaded");
            }
        }
        if (!ENABLE_SHUTDOWN_HOOK) return;
        if (isJavaFxLoaded) {
            JavaFX.onShutdown(new Runnable(){

                @Override
                public void run() {
                    if (systemTray != null) {
                        systemTray.shutdown();
                    }
                }
            });
            return;
        }
        if (!isSwtLoaded) return;
        Swt.onShutdown(new Runnable(){

            @Override
            public void run() {
                if (systemTray != null) {
                    systemTray.shutdown();
                }
            }
        });
    }

    public static String getVersion() {
        return "3.0";
    }

    public static SystemTray get() {
        SystemTray.init();
        return systemTray;
    }

    public void shutdown() {
        Tray menu = systemTrayMenu;
        if (menu != null) {
            menu.remove();
        }
        systemTrayMenu = null;
    }

    public String getStatus() {
        Tray tray = systemTrayMenu;
        if (tray != null) {
            return tray.getStatus();
        }
        return "";
    }

    public void setStatus(String statusText) {
        Tray tray = systemTrayMenu;
        if (tray != null) {
            tray.setStatus(statusText);
        }
    }

    public Menu getMenu() {
        return systemTrayMenu;
    }

    public Menu setMenu(JMenu jMenu) {
        Tray menu = systemTrayMenu;
        if (menu != null) {
            Component[] menuComponents;
            Icon icon = jMenu.getIcon();
            BufferedImage bimage = new BufferedImage(icon.getIconWidth(), icon.getIconHeight(), 2);
            this.setImage(bimage);
            for (Component c : menuComponents = jMenu.getMenuComponents()) {
                if (c instanceof JMenu) {
                    menu.add((JMenu)c);
                    continue;
                }
                if (c instanceof JCheckBoxMenuItem) {
                    menu.add((JCheckBoxMenuItem)c);
                    continue;
                }
                if (c instanceof JMenuItem) {
                    menu.add((JMenuItem)c);
                    continue;
                }
                if (!(c instanceof JSeparator)) continue;
                menu.add((JSeparator)c);
            }
        }
        return menu;
    }

    public void setEnabled(boolean enabled) {
        Tray menu = systemTrayMenu;
        if (menu != null) {
            menu.setEnabled(enabled);
        }
    }

    public void setTooltip(String tooltipText) {
        Tray tray = systemTrayMenu;
        if (tray != null) {
            tray.setTooltip(tooltipText);
        }
    }

    public void setImage(File imageFile) {
        if (imageFile == null) {
            throw new NullPointerException("imageFile cannot be null!");
        }
        Tray menu = systemTrayMenu;
        if (menu != null) {
            ((MenuItem)menu).setImage(imageFile);
        }
    }

    public void setImage(String imagePath) {
        if (imagePath == null) {
            throw new NullPointerException("imagePath cannot be null!");
        }
        Tray menu = systemTrayMenu;
        if (menu != null) {
            ((MenuItem)menu).setImage(imagePath);
        }
    }

    public void setImage(URL imageUrl) {
        if (imageUrl == null) {
            throw new NullPointerException("imageUrl cannot be null!");
        }
        Tray menu = systemTrayMenu;
        if (menu != null) {
            ((MenuItem)menu).setImage(imageUrl);
        }
    }

    public void setImage(InputStream imageStream) {
        if (imageStream == null) {
            throw new NullPointerException("imageStream cannot be null!");
        }
        Tray menu = systemTrayMenu;
        if (menu != null) {
            ((MenuItem)menu).setImage(imageStream);
        }
    }

    public void setImage(Image image) {
        if (image == null) {
            throw new NullPointerException("image cannot be null!");
        }
        Tray menu = systemTrayMenu;
        if (menu != null) {
            ((MenuItem)menu).setImage(image);
        }
    }

    public void setImage(ImageInputStream imageStream) {
        if (imageStream == null) {
            throw new NullPointerException("image cannot be null!");
        }
        Tray menu = systemTrayMenu;
        if (menu != null) {
            ((MenuItem)menu).setImage(imageStream);
        }
    }

    static {
        boolean isSwtLoaded_;
        boolean isJavaFxLoaded_;
        block2: {
            logger = LoggerFactory.getLogger(SystemTray.class);
            AUTO_TRAY_SIZE = true;
            DEFAULT_TRAY_SIZE = 16;
            DEFAULT_MENU_SIZE = 16;
            FORCE_GTK2 = false;
            FORCE_TRAY_TYPE = TrayType.AutoDetect;
            ENABLE_SHUTDOWN_HOOK = true;
            AUTO_FIX_INCONSISTENCIES = true;
            SWING_UI = null;
            DEBUG = false;
            systemTray = null;
            systemTrayMenu = null;
            isJavaFxLoaded_ = false;
            isSwtLoaded_ = false;
            try {
                Method m = ClassLoader.class.getDeclaredMethod("findLoadedClass", String.class);
                m.setAccessible(true);
                ClassLoader cl = ClassLoader.getSystemClassLoader();
                isJavaFxLoaded_ = null != m.invoke((Object)cl, "com.sun.javafx.tk.Toolkit") || null != m.invoke((Object)cl, "javafx.application.Application");
                isSwtLoaded_ = null != m.invoke((Object)cl, "org.eclipse.swt.widgets.Display");
            }
            catch (Throwable e) {
                if (!DEBUG) break block2;
                logger.debug("Error detecting javaFX/SWT mode", e);
            }
        }
        isJavaFxLoaded = isJavaFxLoaded_;
        isSwtLoaded = isSwtLoaded_;
    }

    public static enum TrayType {
        AutoDetect,
        GtkStatusIcon,
        AppIndicator,
        Swing,
        AWT;

    }
}

