/*
 * Decompiled with CFR 0.152.
 */
package dorkbox.systemTray.swingUI;

import dorkbox.systemTray.Checkbox;
import dorkbox.systemTray.Entry;
import dorkbox.systemTray.Menu;
import dorkbox.systemTray.MenuItem;
import dorkbox.systemTray.Separator;
import dorkbox.systemTray.Status;
import dorkbox.systemTray.SystemTray;
import dorkbox.systemTray.peer.MenuPeer;
import dorkbox.systemTray.swingUI.SwingMenuItem;
import dorkbox.systemTray.swingUI.SwingMenuItemCheckbox;
import dorkbox.systemTray.swingUI.SwingMenuItemSeparator;
import dorkbox.systemTray.swingUI.SwingMenuItemStatus;
import dorkbox.systemTray.swingUI.TrayPopup;
import dorkbox.systemTray.util.ImageUtils;
import dorkbox.util.SwingUtil;
import java.io.File;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JPopupMenu;

class SwingMenu
implements MenuPeer {
    final JComponent _native;
    private final SwingMenu parent;

    SwingMenu(SwingMenu parent, Menu entry) {
        this.parent = parent;
        if (parent == null) {
            TrayPopup trayPopup = new TrayPopup();
            if (ImageUtils.ENTRY_FONT != null) {
                trayPopup.setFont(ImageUtils.ENTRY_FONT);
            }
            if (SystemTray.SWING_UI != null) {
                trayPopup.setUI(SystemTray.SWING_UI.getMenuUI(trayPopup, null));
            }
            this._native = trayPopup;
        } else {
            JMenu jMenu = new JMenu();
            JPopupMenu popupMenu = jMenu.getPopupMenu();
            jMenu.setFont(ImageUtils.ENTRY_FONT);
            if (SystemTray.SWING_UI != null) {
                jMenu.setUI(SystemTray.SWING_UI.getItemUI(jMenu, entry));
                popupMenu.setUI(SystemTray.SWING_UI.getMenuUI(popupMenu, entry));
            }
            this._native = jMenu;
            parent._native.add(jMenu);
        }
    }

    @Override
    public void add(final Menu parentMenu, final Entry entry, int index) {
        SwingUtil.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (entry instanceof Menu) {
                    SwingMenu swingMenu = new SwingMenu(SwingMenu.this, (Menu)entry);
                    ((Menu)entry).bind(swingMenu, parentMenu, parentMenu.getSystemTray());
                } else if (entry instanceof Separator) {
                    SwingMenuItemSeparator item = new SwingMenuItemSeparator(SwingMenu.this);
                    entry.bind(item, parentMenu, parentMenu.getSystemTray());
                } else if (entry instanceof Checkbox) {
                    SwingMenuItemCheckbox item = new SwingMenuItemCheckbox(SwingMenu.this, entry);
                    ((Checkbox)entry).bind(item, parentMenu, parentMenu.getSystemTray());
                } else if (entry instanceof Status) {
                    SwingMenuItemStatus item = new SwingMenuItemStatus(SwingMenu.this, entry);
                    ((Status)entry).bind(item, parentMenu, parentMenu.getSystemTray());
                } else if (entry instanceof MenuItem) {
                    SwingMenuItem item = new SwingMenuItem(SwingMenu.this, entry);
                    ((MenuItem)entry).bind(item, parentMenu, parentMenu.getSystemTray());
                }
            }
        });
    }

    @Override
    public void setImage(final MenuItem menuItem) {
        SwingUtil.invokeLater(new Runnable(){

            @Override
            public void run() {
                File imageFile = menuItem.getImage();
                if (imageFile != null) {
                    ImageIcon origIcon = new ImageIcon(imageFile.getAbsolutePath());
                    ((JMenu)SwingMenu.this._native).setIcon(origIcon);
                } else {
                    ((JMenu)SwingMenu.this._native).setIcon(null);
                }
            }
        });
    }

    @Override
    public void setEnabled(final MenuItem menuItem) {
        SwingUtil.invokeLater(new Runnable(){

            @Override
            public void run() {
                SwingMenu.this._native.setEnabled(menuItem.getEnabled());
            }
        });
    }

    @Override
    public void setText(final MenuItem menuItem) {
        SwingUtil.invokeLater(new Runnable(){

            @Override
            public void run() {
                ((JMenu)SwingMenu.this._native).setText(menuItem.getText());
            }
        });
    }

    @Override
    public void setCallback(MenuItem menuItem) {
    }

    @Override
    public void setShortcut(MenuItem menuItem) {
        char shortcut = menuItem.getShortcut();
        final int vKey = SwingUtil.getVirtualKey(shortcut);
        SwingUtil.invokeLater(new Runnable(){

            @Override
            public void run() {
                ((JMenu)SwingMenu.this._native).setMnemonic(vKey);
            }
        });
    }

    @Override
    public synchronized void remove() {
        SwingUtil.invokeLater(new Runnable(){

            @Override
            public void run() {
                SwingMenu.this._native.setVisible(false);
                SwingMenu.this._native.removeAll();
                if (SwingMenu.this.parent != null) {
                    ((SwingMenu)SwingMenu.this).parent._native.remove(SwingMenu.this._native);
                } else {
                    ((TrayPopup)SwingMenu.this._native).close();
                }
            }
        });
    }
}

