/*
 * Decompiled with CFR 0.152.
 */
package dorkbox.systemTray.swingUI;

import dorkbox.systemTray.SystemTray;
import dorkbox.util.OS;
import dorkbox.util.ScreenUtil;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Method;
import javax.imageio.ImageIO;
import javax.swing.ImageIcon;
import javax.swing.JDialog;
import javax.swing.JPopupMenu;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;

class TrayPopup
extends JPopupMenu {
    private static final long serialVersionUID = 1L;
    private final JDialog hiddenDialog;
    private volatile File iconFile;

    TrayPopup() {
        this.setFocusable(true);
        this.hiddenDialog = new JDialog((Frame)null, "Tray menu");
        this.hiddenDialog.setUndecorated(true);
        this.hiddenDialog.setDefaultCloseOperation(2);
        this.hiddenDialog.setAlwaysOnTop(true);
        this.hiddenDialog.getContentPane().setLayout(null);
        if (OS.javaVersion >= 7) {
            try {
                Method[] methods;
                Class<?> hiddenDialogClass = this.hiddenDialog.getClass();
                for (Method method : methods = hiddenDialogClass.getMethods()) {
                    if (!method.getName().equals("setType")) continue;
                    Class<?> cl = Class.forName("java.awt.Window$Type");
                    method.invoke((Object)this.hiddenDialog, Enum.valueOf(cl, "POPUP"));
                    break;
                }
            }
            catch (Exception e) {
                SystemTray.logger.error("Error setting the tray popup menu type. The parent window might show on the task bar.");
            }
        }
        this.hiddenDialog.pack();
        this.hiddenDialog.setBounds(0, 0, 0, 0);
        this.addPopupMenuListener(new PopupMenuListener(){

            @Override
            public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
            }

            @Override
            public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
                TrayPopup.this.hiddenDialog.setVisible(false);
                TrayPopup.this.hiddenDialog.toBack();
            }

            @Override
            public void popupMenuCanceled(PopupMenuEvent e) {
            }
        });
    }

    void setTitleBarImage(File imageFile) {
        if (this.iconFile == null || !this.iconFile.equals(imageFile)) {
            this.iconFile = imageFile;
            try {
                Image image = new ImageIcon(ImageIO.read(imageFile)).getImage();
                image.flush();
                this.hiddenDialog.setIconImage(image);
            }
            catch (IOException e) {
                SystemTray.logger.error("Error setting the title-bar image for the popup menu task tray dialog");
            }
        }
    }

    void close() {
        this.hiddenDialog.setVisible(false);
        this.hiddenDialog.dispatchEvent(new WindowEvent(this.hiddenDialog, 201));
    }

    void doShow(Point point, int offset) {
        Dimension size = this.getPreferredSize();
        Rectangle bounds = ScreenUtil.getScreenBoundsAt(point);
        int x = point.x;
        int y = point.y;
        if (y < bounds.y) {
            y = bounds.y;
        } else if (y + size.height > bounds.y + bounds.height) {
            y -= size.height;
        }
        if (x < bounds.x) {
            x = bounds.x;
        } else if (x + size.width > bounds.x + bounds.width) {
            x -= size.width;
            offset = -offset;
        }
        this.setInvoker(this.hiddenDialog.getContentPane());
        this.hiddenDialog.setLocation(x -= offset, y);
        this.hiddenDialog.setVisible(true);
        this.setLocation(x, y);
        this.setVisible(true);
        this.requestFocusInWindow();
    }
}

