/*
 * Decompiled with CFR 0.152.
 */
package dorkbox.util;

import dorkbox.util.OS;
import dorkbox.util.process.ShellProcessBuilder;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileReader;
import java.io.PrintStream;
import java.util.LinkedList;
import java.util.Scanner;

public class OSUtil {

    public static class DesktopEnv {
        public static boolean isGnome() {
            if (!OS.isLinux() && !OS.isUnix()) {
                return false;
            }
            try {
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(8196);
                PrintStream outputStream = new PrintStream(byteArrayOutputStream);
                ShellProcessBuilder shell = new ShellProcessBuilder(outputStream);
                shell.setExecutable("ps");
                shell.addArgument("x");
                shell.start();
                String output = ShellProcessBuilder.getOutput(byteArrayOutputStream);
                boolean contains = output.contains("gnome-shell");
                if (!contains && OS.isLinux()) {
                    shell = new ShellProcessBuilder(outputStream);
                    shell.setExecutable("ps");
                    shell.addArgument("a");
                    shell.start();
                    output = ShellProcessBuilder.getOutput(byteArrayOutputStream);
                    contains = output.contains("gnome-shell");
                }
                return contains;
            }
            catch (Throwable throwable) {
                return false;
            }
        }

        public static String getGnomeVersion() {
            if (!OS.isLinux() && !OS.isUnix()) {
                return "";
            }
            try {
                String version;
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(8196);
                PrintStream outputStream = new PrintStream(byteArrayOutputStream);
                ShellProcessBuilder shellVersion = new ShellProcessBuilder(outputStream);
                shellVersion.setExecutable("gnome-shell");
                shellVersion.addArgument("--version");
                shellVersion.start();
                String versionString = ShellProcessBuilder.getOutput(byteArrayOutputStream);
                if (!versionString.isEmpty() && (version = versionString.replaceAll("[^\\d.]", "")).length() > 0 && version.indexOf(46) > 0) {
                    return version;
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            return null;
        }

        public static double getPlasmaVersion() {
            String versionAsString = DesktopEnv.getPlasmaVersionFull();
            if (versionAsString.startsWith("0")) {
                return 0.0;
            }
            String[] split = versionAsString.split("\\.", 3);
            if (split.length > 2) {
                return Double.parseDouble(split[0] + "." + split[1]);
            }
            return Double.parseDouble(split[0]);
        }

        public static String getPlasmaVersionFull() {
            if (!OS.isLinux() && !OS.isUnix()) {
                return "";
            }
            try {
                String s;
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(8196);
                PrintStream outputStream = new PrintStream(byteArrayOutputStream);
                ShellProcessBuilder shellVersion = new ShellProcessBuilder(outputStream);
                shellVersion.setExecutable("plasmashell");
                shellVersion.addArgument("--version");
                shellVersion.start();
                String output = ShellProcessBuilder.getOutput(byteArrayOutputStream);
                if (!output.isEmpty() && output.contains(s = "plasmashell ") && !output.contains("not installed")) {
                    return output.substring(output.indexOf(s) + s.length(), output.length());
                }
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
            return "0";
        }
    }

    public static class Linux {
        public static String getInfo() {
            if (!OS.isLinux()) {
                return "";
            }
            try {
                File[] list;
                LinkedList<Object> releaseFiles = new LinkedList<Object>();
                int totalLength = 0;
                File file = new File("/etc");
                if (file.isDirectory() && (list = file.listFiles()) != null) {
                    for (File f : list) {
                        if (!f.getName().contains("release")) continue;
                        releaseFiles.add(f);
                        totalLength += (int)file.length();
                    }
                }
                if (totalLength > 0) {
                    StringBuilder fileContents = new StringBuilder(totalLength);
                    for (File file2 : releaseFiles) {
                        String currentLine;
                        Scanner scanner = new Scanner(file2);
                        BufferedReader reader = new BufferedReader(new FileReader(file2));
                        while ((currentLine = reader.readLine()) != null) {
                            fileContents.append(currentLine).append("\n");
                        }
                    }
                    return fileContents.toString();
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            return "";
        }

        public static int getFedoraVersion() {
            try {
                String output = Linux.getInfo();
                if (output.contains("ID=fedora\n")) {
                    int beginIndex = output.indexOf("VERSION_ID=") + 11;
                    String fedoraVersion_ = output.substring(beginIndex, output.indexOf("\n", beginIndex));
                    return Integer.parseInt(fedoraVersion_);
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            return 0;
        }

        public static boolean getInfo(String id) {
            String output = Linux.getInfo();
            return output.contains("ID=" + id + "\n");
        }

        public static boolean isArch() {
            return Linux.getInfo("arch");
        }

        public static boolean isDebian() {
            return Linux.getInfo("debian");
        }

        public static boolean isElementaryOS() {
            try {
                String output = Linux.getInfo();
                return output.contains("ID=\"elementary\"\n") || output.contains("ID=elementary\n") || output.contains("ID=\"elementary OS\"\n");
            }
            catch (Throwable throwable) {
                return false;
            }
        }

        public static boolean isFedora() {
            return Linux.getInfo("fedora");
        }

        public static boolean isLinuxMint() {
            return Linux.getInfo("linuxmint");
        }

        public static boolean isUbuntu() {
            return Linux.getInfo("ubuntu");
        }
    }

    public static class Unix {
        public static boolean isFreeBSD() {
            if (!OS.isUnix()) {
                return false;
            }
            try {
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(8196);
                PrintStream outputStream = new PrintStream(byteArrayOutputStream);
                ShellProcessBuilder shell = new ShellProcessBuilder(outputStream);
                shell.setExecutable("uname");
                shell.start();
                String output = ShellProcessBuilder.getOutput(byteArrayOutputStream);
                return output.startsWith("FreeBSD");
            }
            catch (Throwable throwable) {
                return false;
            }
        }
    }

    public static class Windows {
        public static int[] getVersion() {
            int[] version = new int[]{0, 0, 0};
            if (!OS.isWindows()) {
                return version;
            }
            try {
                int endIndex;
                int beginIndex;
                String versionString;
                String[] split;
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(8196);
                PrintStream outputStream = new PrintStream(byteArrayOutputStream);
                ShellProcessBuilder shellVersion = new ShellProcessBuilder(outputStream);
                shellVersion.setExecutable("cmd.exe");
                shellVersion.addArgument("/c");
                shellVersion.addArgument("ver");
                shellVersion.start();
                String output = ShellProcessBuilder.getOutput(byteArrayOutputStream);
                if (!output.isEmpty() && output.contains("ersion ") && (split = (versionString = output.substring(beginIndex = output.indexOf("ersion ") + 7, endIndex = output.lastIndexOf("]"))).split("\\.", -1)).length <= 3) {
                    for (int i = 0; i < split.length; ++i) {
                        version[i] = Integer.parseInt(split[i]);
                    }
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            return version;
        }
    }
}

