/*
 * Decompiled with CFR 0.152.
 */
package org.zeroturnaround.process;

import java.lang.management.RuntimeMXBean;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class SunPidUtil {
    private static final Logger log = LoggerFactory.getLogger(SunPidUtil.class);

    SunPidUtil() {
    }

    static Integer tryGetPid(RuntimeMXBean runtime) {
        log.debug("RuntimeMXBean is an instance of {}", (Object)runtime.getClass().getName());
        if (runtime.getClass().getName().equals("sun.management.RuntimeImpl")) {
            try {
                return SunPidUtil.getPid(runtime);
            }
            catch (Exception e) {
                log.debug("Could not detect my PID:", e);
            }
        }
        return null;
    }

    private static int getPid(RuntimeMXBean runtime) throws Exception {
        return SunPidUtil.getPidFromVManagement(SunPidUtil.getJvm(runtime));
    }

    private static Object getJvm(Object runtime) throws Exception {
        Field f = runtime.getClass().getDeclaredField("jvm");
        f.setAccessible(true);
        return f.get(runtime);
    }

    private static int getPidFromVManagement(Object vMManagement) throws Exception {
        Method m = vMManagement.getClass().getDeclaredMethod("getProcessId", new Class[0]);
        m.setAccessible(true);
        return (Integer)m.invoke(vMManagement, new Object[0]);
    }
}

