/*
 * Decompiled with CFR 0.152.
 */
package org.zeroturnaround.process.win;

import java.io.File;
import java.util.Map;
import org.apache.commons.lang.SystemUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WmicUtil {
    private static final Logger log = LoggerFactory.getLogger(WmicUtil.class);
    private static final String EXECUTABLE_NAME = "WMIC.exe";
    private static final String DEFAULT_ROOT = "C:/Windows";
    private static final String DEFAULT_DIR = "System32/Wbem/";
    private static final File PATH = WmicUtil.findPath();

    public static File getPath() {
        return PATH;
    }

    private static File findPath() {
        String rootDir;
        File path = new File(EXECUTABLE_NAME);
        if (SystemUtils.IS_OS_WINDOWS && (rootDir = WmicUtil.getSystemRoot()) != null) {
            path = new File(rootDir, "System32/Wbem/WMIC.exe");
        }
        log.debug("Using {} at {}", (Object)EXECUTABLE_NAME, (Object)path);
        return path;
    }

    private static String getSystemRoot() {
        Map<String, String> envMap = System.getenv();
        for (Map.Entry<String, String> envVar : envMap.entrySet()) {
            if (!"systemroot".equalsIgnoreCase(envVar.getKey())) continue;
            return envVar.getValue();
        }
        if (new File(DEFAULT_ROOT).exists()) {
            return DEFAULT_ROOT;
        }
        return null;
    }
}

