/*
 * Decompiled with CFR 0.152.
 */
package org.hotswap.agent.plugin.tomcat;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import org.hotswap.agent.annotation.Plugin;
import org.hotswap.agent.config.PluginConfiguration;
import org.hotswap.agent.config.PluginManager;
import org.hotswap.agent.logging.AgentLogger;
import org.hotswap.agent.plugin.tomcat.WebappLoaderTransformer;
import org.hotswap.agent.util.PluginManagerInvoker;
import org.hotswap.agent.util.ReflectionHelper;
import org.hotswap.agent.util.classloader.WatchResourcesClassLoader;

@Plugin(name="Tomcat", description="Catalina based servlet containers.", testedVersions={"7.0.50"}, expectedVersions={"6x", "7x", "8x"}, supportClass={WebappLoaderTransformer.class})
public class TomcatPlugin {
    private static AgentLogger LOGGER = AgentLogger.getLogger(TomcatPlugin.class);
    private static final String TOMCAT_WEBAPP_CLASS_LOADER = "org.apache.catalina.loader.WebappClassLoader";
    private static final String TOMCAT_PARALLEL_WEBAPP_CLASS_LOADER = "org.apache.catalina.loader.ParallelWebappClassLoader";
    private static final String GLASSFISH_WEBAPP_CLASS_LOADER = "org.glassfish.web.loader.WebappClassLoader";
    private static final String TOMEE_WEBAPP_CLASS_LOADER = "org.apache.tomee.catalina.TomEEWebappClassLoader";
    private static final String WEB_INF_CLASSES = "/WEB-INF/classes/";
    int tomcatMajorVersion = 8;
    static Map<Object, ClassLoader> registeredResourcesMap = new HashMap<Object, ClassLoader>();
    private static Map<ClassLoader, Map<String, ClassLoader>> extraRepositories = new HashMap<ClassLoader, Map<String, ClassLoader>>();

    public static void init(ClassLoader appClassLoader, Object resource) {
        Object plugin;
        String version = TomcatPlugin.resolveTomcatVersion(appClassLoader);
        int majorVersion = TomcatPlugin.resolveTomcatMajorVersion(version);
        String classLoaderName = appClassLoader.getClass().getName();
        if (classLoaderName.equals(TOMCAT_WEBAPP_CLASS_LOADER) || classLoaderName.equals(TOMCAT_PARALLEL_WEBAPP_CLASS_LOADER) || classLoaderName.equals(GLASSFISH_WEBAPP_CLASS_LOADER) || classLoaderName.equals(TOMEE_WEBAPP_CLASS_LOADER)) {
            URL[] watchResources;
            registeredResourcesMap.put(resource, appClassLoader);
            PluginConfiguration pluginConfiguration = new PluginConfiguration(appClassLoader);
            WatchResourcesClassLoader watchResourcesClassLoader = new WatchResourcesClassLoader(false);
            URL[] extraClasspath = pluginConfiguration.getExtraClasspath();
            if (extraClasspath.length > 0) {
                if (majorVersion >= 7) {
                    watchResourcesClassLoader.initExtraPath(extraClasspath);
                } else {
                    TomcatPlugin.addRepositoriesAtStart(appClassLoader, extraClasspath, false);
                }
            }
            if ((watchResources = pluginConfiguration.getWatchResources()).length > 0) {
                if (majorVersion >= 7) {
                    watchResourcesClassLoader.initWatchResources(watchResources, PluginManager.getInstance().getWatcher());
                } else {
                    TomcatPlugin.addRepositoriesAtStart(appClassLoader, watchResources, true);
                }
            }
            TomcatPlugin.getExtraRepositories(appClassLoader).put(WEB_INF_CLASSES, (ClassLoader)watchResourcesClassLoader);
            URL[] webappDir = pluginConfiguration.getWebappDir();
            if (webappDir.length > 0) {
                for (URL url : webappDir) {
                    LOGGER.debug("Watching 'webappDir' for changes: {}", new Object[]{url});
                }
                WatchResourcesClassLoader webappDirClassLoader = new WatchResourcesClassLoader(false);
                webappDirClassLoader.initExtraPath(webappDir);
                TomcatPlugin.getExtraRepositories(appClassLoader).put("/", (ClassLoader)webappDirClassLoader);
            }
        }
        if ((plugin = PluginManagerInvoker.callInitializePlugin(TomcatPlugin.class, (ClassLoader)appClassLoader)) != null) {
            ReflectionHelper.invoke((Object)plugin, plugin.getClass(), (String)"init", (Class[])new Class[]{String.class, ClassLoader.class}, (Object[])new Object[]{version, appClassLoader});
        } else {
            LOGGER.debug("TomcatPlugin is disabled in {}", new Object[]{appClassLoader});
        }
    }

    private void init(String version, ClassLoader appClassLoader) {
        if (appClassLoader.getClass().getName().equals(GLASSFISH_WEBAPP_CLASS_LOADER)) {
            LOGGER.info("Tomcat plugin initialized - GlassFish embedded Tomcat version '{}'", new Object[]{version});
        } else {
            LOGGER.info("Tomcat plugin initialized - Tomcat version '{}'", new Object[]{version});
        }
        this.tomcatMajorVersion = TomcatPlugin.resolveTomcatMajorVersion(version);
    }

    private static void addRepositoriesAtStart(ClassLoader appClassLoader, URL[] newRepositories, boolean watchResources) {
        int i;
        int i2;
        String[] currentRepositories = (String[])ReflectionHelper.get((Object)appClassLoader, (String)"repositories");
        String[] repositories = new String[currentRepositories.length + newRepositories.length];
        for (i2 = 0; i2 < newRepositories.length; ++i2) {
            repositories[i2] = "extraClasspath:" + newRepositories[i2].toString();
        }
        for (i2 = 0; i2 < currentRepositories.length; ++i2) {
            repositories[i2 + newRepositories.length] = currentRepositories[i2];
        }
        ReflectionHelper.set((Object)appClassLoader, appClassLoader.getClass(), (String)"repositories", (Object)repositories);
        File[] files = (File[])ReflectionHelper.get((Object)appClassLoader, (String)"files");
        File[] result2 = new File[files.length + newRepositories.length];
        for (i = 0; i < newRepositories.length; ++i) {
            try {
                WatchResourcesClassLoader watchResourcesClassLoader = new WatchResourcesClassLoader();
                if (watchResources) {
                    watchResourcesClassLoader.initWatchResources(new URL[]{newRepositories[i]}, PluginManager.getInstance().getWatcher());
                } else {
                    watchResourcesClassLoader.initExtraPath(new URL[]{newRepositories[i]});
                }
                TomcatPlugin.getExtraRepositories(appClassLoader).put(repositories[i], (ClassLoader)watchResourcesClassLoader);
                result2[i] = new File(newRepositories[i].toURI());
                continue;
            }
            catch (URISyntaxException e) {
                e.printStackTrace();
            }
        }
        for (i = 0; i < files.length; ++i) {
            result2[i + newRepositories.length] = files[i];
        }
        ReflectionHelper.set((Object)appClassLoader, appClassLoader.getClass(), (String)"files", (Object)result2);
    }

    private static Map<String, ClassLoader> getExtraRepositories(ClassLoader appClassLoader) {
        if (!extraRepositories.containsKey(appClassLoader)) {
            extraRepositories.put(appClassLoader, new HashMap());
        }
        return extraRepositories.get(appClassLoader);
    }

    public static InputStream getExtraResource(Object resource, String name) {
        URL url = TomcatPlugin.getExtraResource0(resource, name);
        if (url != null) {
            try {
                return url.openStream();
            }
            catch (IOException e) {
                LOGGER.error("Unable to open stream from URL {}", (Throwable)e, new Object[]{url});
            }
        }
        return null;
    }

    public static File getExtraResourceFile(Object resource, String name) {
        URL url;
        ClassLoader appClassLoader = registeredResourcesMap.get(resource);
        if (appClassLoader == null) {
            return null;
        }
        Map<String, ClassLoader> classLoaderExtraRepositories = TomcatPlugin.getExtraRepositories(appClassLoader);
        if (name.startsWith(WEB_INF_CLASSES) && classLoaderExtraRepositories.containsKey(WEB_INF_CLASSES)) {
            String resourceName = name.substring(WEB_INF_CLASSES.length());
            URL url2 = classLoaderExtraRepositories.get(WEB_INF_CLASSES).getResource(resourceName);
            if (url2 != null) {
                try {
                    return new File(url2.toURI());
                }
                catch (Exception e) {
                    LOGGER.error("Unable to open stream from URL {}", (Throwable)e, new Object[]{url2});
                }
            }
        } else if (classLoaderExtraRepositories.containsKey("/") && (url = classLoaderExtraRepositories.get("/").getResource(name.substring(1))) != null) {
            try {
                return new File(url.toURI());
            }
            catch (Exception e) {
                LOGGER.error("Unable to open stream from URL {}", (Throwable)e, new Object[]{url});
            }
        }
        return null;
    }

    public static long getExtraResourceLength(Object resource, String name) {
        URL url = TomcatPlugin.getExtraResource0(resource, name);
        if (url != null) {
            try {
                return new File(url.toURI()).length();
            }
            catch (Exception e) {
                LOGGER.error("Unable to open file at URL {}", (Throwable)e, new Object[]{url});
            }
        }
        return 0L;
    }

    private static URL getExtraResource0(Object resource, String name) {
        ClassLoader appClassLoader = registeredResourcesMap.get(resource);
        if (appClassLoader == null) {
            return null;
        }
        for (Map.Entry<String, ClassLoader> repo : TomcatPlugin.getExtraRepositories(appClassLoader).entrySet()) {
            if (!name.startsWith(repo.getKey())) continue;
            String resourceName = name.substring(repo.getKey().length());
            return repo.getValue().getResource(resourceName);
        }
        return null;
    }

    private static String resolveTomcatVersion(ClassLoader appClassLoader) {
        try {
            Class<?> serverInfo = appClassLoader.loadClass("org.apache.catalina.util.ServerInfo");
            if (appClassLoader.getClass().getName().equals(GLASSFISH_WEBAPP_CLASS_LOADER)) {
                return (String)ReflectionHelper.invoke(null, serverInfo, (String)"getPublicServerInfo", (Class[])new Class[0], (Object[])new Object[0]);
            }
            return (String)ReflectionHelper.invoke(null, serverInfo, (String)"getServerNumber", (Class[])new Class[0], (Object[])new Object[0]);
        }
        catch (Exception e) {
            LOGGER.debug("Unable to resolve server version", (Throwable)e, new Object[0]);
            return "unknown";
        }
    }

    private static int resolveTomcatMajorVersion(String version) {
        try {
            return Integer.valueOf(version.substring(0, 1));
        }
        catch (Exception e) {
            LOGGER.debug("Unable to resolve server main version from version string {}", (Throwable)e, new Object[]{version});
            return 8;
        }
    }
}

