/*
 * Decompiled with CFR 0.152.
 */
package org.jcrom;

import java.util.logging.Level;
import java.util.logging.Logger;
import javax.jcr.Session;
import net.sf.cglib.proxy.LazyLoader;
import org.jcrom.Jcrom;
import org.jcrom.Mapper;
import org.jcrom.SessionFactory;
import org.jcrom.util.SessionFactoryUtils;

public abstract class AbstractLazyLoader
implements LazyLoader {
    private static final Logger logger = Logger.getLogger(AbstractLazyLoader.class.getName());
    private final Session session;
    private final Mapper mapper;

    public AbstractLazyLoader(Session session, Mapper mapper) {
        this.session = session;
        this.mapper = mapper;
    }

    private Session getSession() {
        Session sessionToUse;
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("Getting the session");
        }
        Session session = sessionToUse = Jcrom.getCurrentSession() != null ? Jcrom.getCurrentSession() : this.session;
        if (sessionToUse == null || !sessionToUse.isLive()) {
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("Creating a new session");
            }
            SessionFactory sessionFactory = this.mapper.getJcrom().getSessionFactory();
            sessionToUse = SessionFactoryUtils.getSession(sessionFactory);
        }
        return sessionToUse;
    }

    private void releaseSession(Session session) {
        if (session != null) {
            Session sessionToUse;
            Session session2 = sessionToUse = Jcrom.getCurrentSession() != null ? Jcrom.getCurrentSession() : this.session;
            if (!sessionToUse.equals(session)) {
                SessionFactoryUtils.releaseSession(session);
                if (logger.isLoggable(Level.FINE)) {
                    logger.fine("Closing the newly created session");
                }
            }
        }
    }

    public final Object loadObject() throws Exception {
        Session sessionToUse = this.getSession();
        Object obj = this.doLoadObject(sessionToUse, this.mapper);
        this.releaseSession(sessionToUse);
        return obj;
    }

    protected abstract Object doLoadObject(Session var1, Mapper var2) throws Exception;
}

