/*
 * Decompiled with CFR 0.152.
 */
package org.jcrom;

import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.jcr.Binary;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.RepositoryException;
import javax.jcr.ValueFactory;
import org.jcrom.JcrDataProvider;
import org.jcrom.JcrDataProviderImpl;
import org.jcrom.JcrFile;
import org.jcrom.Mapper;
import org.jcrom.ProxyFactory;
import org.jcrom.annotations.JcrFileNode;
import org.jcrom.annotations.JcrNode;
import org.jcrom.util.NodeFilter;
import org.jcrom.util.ReflectionUtils;

class FileNodeMapper {
    private final Mapper mapper;

    public FileNodeMapper(Mapper mapper) {
        this.mapper = mapper;
    }

    private String getNodeName(Field field) {
        JcrFileNode jcrFileNode = this.mapper.getJcrom().getAnnotationReader().getAnnotation(field, JcrFileNode.class);
        String name = field.getName();
        if (!jcrFileNode.name().equals("fieldName")) {
            name = jcrFileNode.name();
        }
        return name;
    }

    private Node createFileFolderNode(JcrNode jcrNode, String containerName, Node parentNode, Mapper mapper) throws RepositoryException {
        if (!parentNode.hasNode(mapper.getCleanName(containerName))) {
            if (jcrNode != null && (jcrNode.nodeType().equals("nt:unstructured") || jcrNode.nodeType().equals("{http://www.jcp.org/jcr/nt/1.0}unstructured"))) {
                return parentNode.addNode(mapper.getCleanName(containerName));
            }
            return parentNode.addNode(mapper.getCleanName(containerName), "{http://www.jcp.org/jcr/nt/1.0}folder");
        }
        return parentNode.getNode(mapper.getCleanName(containerName));
    }

    private <T extends JcrFile> void setFileNodeProperties(Node contentNode, T file) throws RepositoryException, IOException {
        JcrDataProvider dataProvider;
        contentNode.setProperty("{http://www.jcp.org/jcr/1.0}mimeType", file.getMimeType());
        contentNode.setProperty("{http://www.jcp.org/jcr/1.0}lastModified", file.getLastModified());
        if (file.getEncoding() != null) {
            contentNode.setProperty("{http://www.jcp.org/jcr/1.0}encoding", file.getEncoding());
        }
        if ((dataProvider = file.getDataProvider()) != null) {
            ValueFactory valueFactory = contentNode.getSession().getValueFactory();
            if (dataProvider.isFile() && dataProvider.getFile() != null) {
                Binary binary = valueFactory.createBinary((InputStream)new FileInputStream(dataProvider.getFile()));
                contentNode.setProperty("{http://www.jcp.org/jcr/1.0}data", binary);
            } else if (dataProvider.isBytes() && dataProvider.getBytes() != null) {
                Binary binary = valueFactory.createBinary((InputStream)new ByteArrayInputStream(dataProvider.getBytes()));
                contentNode.setProperty("{http://www.jcp.org/jcr/1.0}data", binary);
            } else if (dataProvider.isStream() && dataProvider.getInputStream() != null) {
                try {
                    Binary binary = valueFactory.createBinary(dataProvider.getInputStream());
                    contentNode.setProperty("{http://www.jcp.org/jcr/1.0}data", binary);
                }
                catch (RepositoryException re) {
                    System.out.println("FILE NODE: " + contentNode.getPath() + " " + ((FileInputStream)dataProvider.getInputStream()).available());
                    throw re;
                }
            }
        }
    }

    private <T extends JcrFile> void addFileNode(JcrNode jcrNode, Node parentNode, T file, Mapper mapper) throws IllegalAccessException, RepositoryException, IOException {
        Node fileNode = jcrNode == null || jcrNode.nodeType().equals("nt:unstructured") || jcrNode.nodeType().equals("{http://www.jcp.org/jcr/nt/1.0}unstructured") ? parentNode.addNode(mapper.getCleanName(file.getName())) : parentNode.addNode(mapper.getCleanName(file.getName()), jcrNode.nodeType());
        if (jcrNode != null && jcrNode.mixinTypes() != null) {
            String[] stringArray = jcrNode.mixinTypes();
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String mixinType = stringArray[n2];
                if (fileNode.canAddMixin(mixinType)) {
                    fileNode.addMixin(mixinType);
                }
                ++n2;
            }
        }
        file.setName(fileNode.getName());
        file.setPath(fileNode.getPath());
        mapper.setId(file, fileNode.getIdentifier());
        if (fileNode.hasProperty("{http://www.jcp.org/jcr/1.0}uuid")) {
            mapper.setUUID(file, fileNode.getIdentifier());
        }
        Node contentNode = fileNode.addNode("{http://www.jcp.org/jcr/1.0}content", "{http://www.jcp.org/jcr/nt/1.0}resource");
        this.setFileNodeProperties(contentNode, file);
        mapper.addNode(fileNode, file, null, false);
    }

    <T extends JcrFile> void addFileNode(Node fileNode, T file, Mapper mapper) throws IllegalAccessException, RepositoryException, IOException {
        file.setName(fileNode.getName());
        file.setPath(fileNode.getPath());
        mapper.setId(file, fileNode.getIdentifier());
        if (fileNode.hasProperty("{http://www.jcp.org/jcr/1.0}uuid")) {
            mapper.setUUID(file, fileNode.getIdentifier());
        }
        Node contentNode = fileNode.hasNode("{http://www.jcp.org/jcr/1.0}content") ? fileNode.getNode("{http://www.jcp.org/jcr/1.0}content") : fileNode.addNode("{http://www.jcp.org/jcr/1.0}content", "{http://www.jcp.org/jcr/nt/1.0}resource");
        this.setFileNodeProperties(contentNode, file);
    }

    private <T extends JcrFile> void updateFileNode(Node fileNode, T file, NodeFilter nodeFilter, int depth, Mapper mapper) throws RepositoryException, IllegalAccessException, IOException {
        Node contentNode = fileNode.getNode("{http://www.jcp.org/jcr/1.0}content");
        this.setFileNodeProperties(contentNode, file);
        mapper.updateNode(fileNode, file, file.getClass(), nodeFilter, depth + 1);
    }

    private void removeChildren(Node containerNode) throws RepositoryException {
        NodeIterator nodeIterator = containerNode.getNodes();
        while (nodeIterator.hasNext()) {
            nodeIterator.nextNode().remove();
        }
    }

    private void addSingleFileToNode(Field field, Object obj, String nodeName, Node node, Mapper mapper, int depth, NodeFilter nodeFilter) throws IllegalAccessException, RepositoryException, IOException {
        JcrNode fileJcrNode = ReflectionUtils.getJcrNodeAnnotation(field.getType());
        Node fileContainer = this.createFileFolderNode(fileJcrNode, nodeName, node, mapper);
        if (!fileContainer.hasNodes()) {
            if (field.get(obj) != null) {
                this.addFileNode(fileJcrNode, fileContainer, (JcrFile)field.get(obj), mapper);
            }
        } else if (field.get(obj) != null) {
            this.updateFileNode(fileContainer.getNodes().nextNode(), (JcrFile)field.get(obj), nodeFilter, depth, mapper);
        } else {
            this.removeChildren(fileContainer);
        }
    }

    private void updateFileList(List<?> children, Node fileContainer, JcrNode fileJcrNode, Mapper mapper, int depth, NodeFilter nodeFilter) throws IllegalAccessException, RepositoryException, IOException {
        if (children != null && !children.isEmpty()) {
            if (fileContainer.hasNodes()) {
                NodeIterator childNodes = fileContainer.getNodes();
                while (childNodes.hasNext()) {
                    Object child = childNodes.nextNode();
                    JcrFile childEntity = (JcrFile)mapper.findEntityByPath(children, child.getPath());
                    if (childEntity == null) {
                        child.remove();
                        continue;
                    }
                    this.updateFileNode((Node)child, (JcrFile)childEntity, nodeFilter, depth, mapper);
                }
                for (Object child : children) {
                    String childPath = mapper.getNodePath(child);
                    if (childPath != null && !childPath.equals("") && fileContainer.hasNode(mapper.getCleanName(mapper.getNodeName(child)))) continue;
                    this.addFileNode(fileJcrNode, fileContainer, (JcrFile)child, mapper);
                }
            } else {
                int i = 0;
                while (i < children.size()) {
                    this.addFileNode(fileJcrNode, fileContainer, (JcrFile)children.get(i), mapper);
                    ++i;
                }
            }
        } else {
            this.removeChildren(fileContainer);
        }
    }

    private void addMultipleFilesToNode(Field field, Object obj, String nodeName, Node node, Mapper mapper, int depth, NodeFilter nodeFilter) throws IllegalAccessException, RepositoryException, IOException {
        JcrNode fileJcrNode = ReflectionUtils.getJcrNodeAnnotation(ReflectionUtils.getParameterizedClass(field));
        Node fileContainer = this.createFileFolderNode(fileJcrNode, nodeName, node, mapper);
        List children = (List)field.get(obj);
        this.updateFileList(children, fileContainer, fileJcrNode, mapper, depth, nodeFilter);
    }

    private void addMapOfFilesToNode(Field field, Object obj, String nodeName, Node node, Mapper mapper, int depth, NodeFilter nodeFilter) throws IllegalAccessException, RepositoryException, IOException {
        Class<?> fileClass = ReflectionUtils.implementsInterface(ReflectionUtils.getParameterizedClass(field, 1), List.class) ? ReflectionUtils.getTypeArgumentOfParameterizedClass(field, 1, 0) : ReflectionUtils.getParameterizedClass(field, 1);
        JcrNode fileJcrNode = ReflectionUtils.getJcrNodeAnnotation(fileClass);
        String cleanName = mapper.getCleanName(nodeName);
        Node fileContainer = node.hasNode(cleanName) ? node.getNode(cleanName) : node.addNode(cleanName);
        Map children = (Map)field.get(obj);
        if (children != null && !children.isEmpty()) {
            Class<?> paramClass = ReflectionUtils.getParameterizedClass(field, 1);
            if (fileContainer.hasNodes()) {
                HashMap<String, String> mapWithCleanKeys = new HashMap<String, String>();
                for (String key : children.keySet()) {
                    String cleanKey = mapper.getCleanName(key);
                    if (fileContainer.hasNode(cleanKey)) {
                        if (ReflectionUtils.implementsInterface(paramClass, List.class)) {
                            List childList = (List)children.get(key);
                            Node listContainer = this.createFileFolderNode(fileJcrNode, cleanKey, fileContainer, mapper);
                            this.updateFileList(childList, listContainer, fileJcrNode, mapper, depth, nodeFilter);
                        } else {
                            this.updateFileNode(fileContainer.getNode(cleanKey), (JcrFile)children.get(key), nodeFilter, depth, mapper);
                        }
                    } else {
                        this.addMapFile(paramClass, fileJcrNode, fileContainer, children, key, mapper);
                    }
                    mapWithCleanKeys.put(cleanKey, "1");
                }
                NodeIterator childNodes = fileContainer.getNodes();
                while (childNodes.hasNext()) {
                    Node child = childNodes.nextNode();
                    if (mapWithCleanKeys.containsKey(child.getName())) continue;
                    child.remove();
                }
            } else {
                for (String key : children.keySet()) {
                    this.addMapFile(paramClass, fileJcrNode, fileContainer, children, key, mapper);
                }
            }
        } else {
            this.removeChildren(fileContainer);
        }
    }

    private void addMapFile(Class<?> paramClass, JcrNode fileJcrNode, Node fileContainer, Map<?, ?> childMap, String key, Mapper mapper) throws IllegalAccessException, RepositoryException, IOException {
        if (ReflectionUtils.implementsInterface(paramClass, List.class)) {
            List childList = (List)childMap.get(key);
            Node listContainer = this.createFileFolderNode(fileJcrNode, mapper.getCleanName(key), fileContainer, mapper);
            int i = 0;
            while (i < childList.size()) {
                this.addFileNode(fileJcrNode, listContainer, (JcrFile)childList.get(i), mapper);
                ++i;
            }
        } else {
            this.addFileNode(fileJcrNode, fileContainer, (JcrFile)childMap.get(key), mapper);
        }
    }

    private void setFiles(Field field, Object obj, Node node, Mapper mapper, int depth, NodeFilter nodeFilter) throws IllegalAccessException, RepositoryException, IOException {
        String nodeName = this.getNodeName(field);
        if (nodeFilter == null || nodeFilter.isIncluded(field.getName(), depth)) {
            if (ReflectionUtils.implementsInterface(field.getType(), List.class)) {
                this.addMultipleFilesToNode(field, obj, nodeName, node, mapper, depth, nodeFilter);
            } else if (ReflectionUtils.implementsInterface(field.getType(), Map.class)) {
                this.addMapOfFilesToNode(field, obj, nodeName, node, mapper, depth, nodeFilter);
            } else {
                this.addSingleFileToNode(field, obj, nodeName, node, mapper, depth, nodeFilter);
            }
        }
    }

    private <T extends JcrFile> void mapNodeToFileObject(JcrFileNode jcrFileNode, T fileObj, Node fileNode, NodeFilter nodeFilter, Object parentObject, int depth, Mapper mapper) throws ClassNotFoundException, InstantiationException, RepositoryException, IllegalAccessException, IOException {
        Node contentNode = fileNode.getNode("{http://www.jcp.org/jcr/1.0}content");
        ((JcrFile)fileObj).setName(fileNode.getName());
        ((JcrFile)fileObj).setPath(fileNode.getPath());
        ((JcrFile)fileObj).setMimeType(contentNode.getProperty("{http://www.jcp.org/jcr/1.0}mimeType").getString());
        ((JcrFile)fileObj).setLastModified(contentNode.getProperty("{http://www.jcp.org/jcr/1.0}lastModified").getDate());
        if (contentNode.hasProperty("{http://www.jcp.org/jcr/1.0}encoding")) {
            ((JcrFile)fileObj).setEncoding(contentNode.getProperty("{http://www.jcp.org/jcr/1.0}encoding").getString());
        }
        if (jcrFileNode == null || jcrFileNode.loadType() == JcrFileNode.LoadType.STREAM) {
            InputStream is = contentNode.getProperty("{http://www.jcp.org/jcr/1.0}data").getBinary().getStream();
            JcrDataProviderImpl dataProvider = new JcrDataProviderImpl(is, contentNode.getProperty("{http://www.jcp.org/jcr/1.0}data").getLength());
            ((JcrFile)fileObj).setDataProvider(dataProvider);
        } else if (jcrFileNode.loadType() == JcrFileNode.LoadType.BYTES) {
            InputStream is = contentNode.getProperty("{http://www.jcp.org/jcr/1.0}data").getBinary().getStream();
            JcrDataProviderImpl dataProvider = new JcrDataProviderImpl(Mapper.readBytes(is));
            ((JcrFile)fileObj).setDataProvider(dataProvider);
        }
        fileObj = (JcrFile)mapper.mapNodeToClass(fileObj, fileNode, nodeFilter, parentObject, depth + 1);
    }

    void addFiles(Field field, Object obj, Node node, Mapper mapper) throws IllegalAccessException, RepositoryException, IOException {
        this.setFiles(field, obj, node, mapper, -1, null);
    }

    void updateFiles(Field field, Object obj, Node node, Mapper mapper, int depth, NodeFilter nodeFilter) throws IllegalAccessException, RepositoryException, IOException {
        this.setFiles(field, obj, node, mapper, depth, nodeFilter);
    }

    List<JcrFile> getFileList(Class<?> childObjClass, Node fileContainer, Object obj, JcrFileNode jcrFileNode, int depth, NodeFilter nodeFilter, Mapper mapper) throws ClassNotFoundException, InstantiationException, RepositoryException, IllegalAccessException, IOException {
        List children = jcrFileNode.listContainerClass().newInstance();
        NodeIterator iterator = fileContainer.getNodes();
        while (iterator.hasNext()) {
            JcrFile fileObj = (JcrFile)childObjClass.newInstance();
            this.mapNodeToFileObject(jcrFileNode, fileObj, iterator.nextNode(), nodeFilter, obj, depth, mapper);
            children.add(fileObj);
        }
        return children;
    }

    void mapSingleFile(JcrFile fileObj, Node fileNode, Object obj, int depth, NodeFilter nodeFilter, Mapper mapper) throws ClassNotFoundException, InstantiationException, RepositoryException, IllegalAccessException, IOException {
        this.mapNodeToFileObject(null, fileObj, fileNode, nodeFilter, obj, depth, mapper);
    }

    JcrFile getSingleFile(Class<?> childObjClass, Node fileContainer, Object obj, JcrFileNode jcrFileNode, int depth, NodeFilter nodeFilter, Mapper mapper) throws ClassNotFoundException, InstantiationException, RepositoryException, IllegalAccessException, IOException {
        JcrFile fileObj = (JcrFile)childObjClass.newInstance();
        this.mapNodeToFileObject(jcrFileNode, fileObj, fileContainer.getNodes().nextNode(), nodeFilter, obj, depth, mapper);
        return fileObj;
    }

    private Map<?, ?> getFileMap(Field field, Node fileContainer, JcrFileNode jcrFileNode, Object obj, int depth, NodeFilter nodeFilter, Mapper mapper) throws ClassNotFoundException, InstantiationException, RepositoryException, IllegalAccessException, IOException {
        Class<?> mapParamClass = ReflectionUtils.getParameterizedClass(field, 1);
        Map children = jcrFileNode.mapContainerClass().newInstance();
        NodeIterator iterator = fileContainer.getNodes();
        while (iterator.hasNext()) {
            Node childNode = iterator.nextNode();
            if (ReflectionUtils.implementsInterface(mapParamClass, List.class)) {
                Class<?> childObjClass = ReflectionUtils.getTypeArgumentOfParameterizedClass(field, 1, 0);
                if (jcrFileNode.lazy()) {
                    children.put(childNode.getName(), ProxyFactory.createFileNodeListProxy(childObjClass, obj, fileContainer.getPath(), fileContainer.getSession(), mapper, depth, nodeFilter, jcrFileNode));
                    continue;
                }
                children.put(childNode.getName(), this.getFileList(childObjClass, childNode, obj, jcrFileNode, depth, nodeFilter, mapper));
                continue;
            }
            if (jcrFileNode.lazy()) {
                children.put(childNode.getName(), ProxyFactory.createFileNodeProxy(mapParamClass, obj, fileContainer.getPath(), fileContainer.getSession(), mapper, depth, nodeFilter, jcrFileNode));
                continue;
            }
            children.put(childNode.getName(), this.getSingleFile(mapParamClass, fileContainer, obj, jcrFileNode, depth, nodeFilter, mapper));
        }
        return children;
    }

    void getFilesFromNode(Field field, Node node, Object obj, int depth, NodeFilter nodeFilter, Mapper mapper) throws ClassNotFoundException, InstantiationException, RepositoryException, IllegalAccessException, IOException {
        String nodeName = this.getNodeName(field);
        JcrFileNode jcrFileNode = mapper.getJcrom().getAnnotationReader().getAnnotation(field, JcrFileNode.class);
        if (node.hasNode(nodeName) && nodeFilter.isIncluded(field.getName(), depth)) {
            Node fileContainer = node.getNode(nodeName);
            if (ReflectionUtils.implementsInterface(field.getType(), List.class)) {
                Class<?> childObjClass = ReflectionUtils.getParameterizedClass(field);
                List<JcrFile> children = jcrFileNode.lazy() ? ProxyFactory.createFileNodeListProxy(childObjClass, obj, fileContainer.getPath(), node.getSession(), mapper, depth, nodeFilter, jcrFileNode) : this.getFileList(childObjClass, fileContainer, obj, jcrFileNode, depth, nodeFilter, mapper);
                field.set(obj, children);
            } else if (ReflectionUtils.implementsInterface(field.getType(), Map.class)) {
                field.set(obj, this.getFileMap(field, fileContainer, jcrFileNode, obj, depth, nodeFilter, mapper));
            } else if (fileContainer.hasNodes()) {
                if (jcrFileNode.lazy()) {
                    field.set(obj, ProxyFactory.createFileNodeProxy(field.getType(), obj, fileContainer.getPath(), node.getSession(), mapper, depth, nodeFilter, jcrFileNode));
                } else {
                    field.set(obj, this.getSingleFile(field.getType(), fileContainer, obj, jcrFileNode, depth, nodeFilter, mapper));
                }
            }
        }
    }
}

