/*
 * Decompiled with CFR 0.152.
 */
package org.jcrom;

import java.io.IOException;
import java.util.Calendar;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.jcr.Node;
import javax.jcr.Property;
import javax.jcr.PropertyIterator;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.Value;
import org.jcrom.AnnotationReader;
import org.jcrom.JcrMappingException;
import org.jcrom.Mapper;
import org.jcrom.ReflectionAnnotationReader;
import org.jcrom.SessionFactory;
import org.jcrom.Validator;
import org.jcrom.util.NodeFilter;
import org.jcrom.util.ReflectionUtils;

public class Jcrom {
    private final Mapper mapper;
    private final Validator validator;
    private AnnotationReader annotationReader;
    private static final ThreadLocal<Session> currentSession = new ThreadLocal();
    private SessionFactory sessionFactory;

    public Jcrom() {
        this(true);
    }

    public Jcrom(boolean cleanNames) {
        this(cleanNames, false);
    }

    public Jcrom(boolean cleanNames, boolean dynamicInstantiation) {
        this(cleanNames, dynamicInstantiation, new HashSet());
    }

    public Jcrom(Set<Class<?>> classesToMap) {
        this(true, false, classesToMap);
    }

    public Jcrom(boolean cleanNames, Set<Class<?>> classesToMap) {
        this(cleanNames, false, classesToMap);
    }

    public Jcrom(boolean cleanNames, boolean dynamicInstantiation, Set<Class<?>> classesToMap) {
        this.mapper = new Mapper(cleanNames, dynamicInstantiation, this);
        this.validator = new Validator(this);
        this.annotationReader = new ReflectionAnnotationReader();
        for (Class<?> c : classesToMap) {
            this.map(c);
        }
    }

    public synchronized Jcrom map(Class<?> entityClass) {
        if (!this.mapper.isMapped(entityClass)) {
            Set<Class<?>> validClasses = this.validator.validate(entityClass, this.mapper.isDynamicInstantiation());
            for (Class<?> c : validClasses) {
                this.mapper.addMappedClass(c);
            }
        }
        return this;
    }

    public synchronized Jcrom mapPackage(String packageName) {
        return this.mapPackage(packageName, false);
    }

    public synchronized Jcrom mapPackage(String packageName, boolean ignoreInvalidClasses) {
        try {
            for (Class<?> c : ReflectionUtils.getClasses(packageName)) {
                try {
                    this.map(c);
                }
                catch (JcrMappingException ex) {
                    if (ignoreInvalidClasses) continue;
                    throw ex;
                }
            }
            return this;
        }
        catch (IOException ioex) {
            throw new JcrMappingException("Could not get map classes from package " + packageName, ioex);
        }
        catch (ClassNotFoundException cnfex) {
            throw new JcrMappingException("Could not get map classes from package " + packageName, cnfex);
        }
    }

    public Set<Class<?>> getMappedClasses() {
        return Collections.unmodifiableSet(this.mapper.getMappedClasses());
    }

    public boolean isMapped(Class<?> entityClass) {
        return this.mapper.isMapped(entityClass);
    }

    public String getName(Object object) throws JcrMappingException {
        try {
            return this.mapper.getNodeName(object);
        }
        catch (IllegalAccessException e) {
            throw new JcrMappingException("Could not get node name from object", e);
        }
    }

    public String getPath(Object object) throws JcrMappingException {
        try {
            return this.mapper.getNodePath(object);
        }
        catch (IllegalAccessException e) {
            throw new JcrMappingException("Could not get node path from object", e);
        }
    }

    public Object getParentObject(Object childObject) throws JcrMappingException {
        try {
            return this.mapper.getParentObject(childObject);
        }
        catch (IllegalAccessException e) {
            throw new JcrMappingException("Could not get parent object with Annotation JcrParentNode from child object", e);
        }
    }

    public String getChildContainerPath(Object childObject, Object parentObject, Node parentNode) {
        try {
            return this.mapper.getChildContainerNodePath(childObject, parentObject, parentNode);
        }
        catch (IllegalAccessException e) {
            throw new JcrMappingException("Could not get child object with Annotation @JcrChildNode and with the type '" + childObject.getClass() + "' from parent object", e);
        }
        catch (RepositoryException e) {
            throw new JcrMappingException("Could not get child object with Annotation @JcrChildNode and with the type '" + childObject.getClass() + "' from parent object", e);
        }
    }

    public void setBaseVersionInfo(Object object, String name, Calendar created) throws JcrMappingException {
        try {
            this.mapper.setBaseVersionInfo(object, name, created);
        }
        catch (IllegalAccessException e) {
            throw new JcrMappingException("Could not set base version info on object", e);
        }
    }

    public <T> T fromNode(Class<T> entityClass, Node node) throws JcrMappingException {
        return this.fromNode(entityClass, node, "*", -1);
    }

    public <T> T fromNode(Class<T> entityClass, Node node, String childNodeFilter, int maxDepth) throws JcrMappingException {
        return this.fromNode(entityClass, node, new NodeFilter(childNodeFilter, maxDepth));
    }

    public <T> T fromNode(Class<T> entityClass, Node node, NodeFilter nodeFilter) throws JcrMappingException {
        if (!this.mapper.isDynamicInstantiation() && !this.mapper.isMapped(entityClass)) {
            throw new JcrMappingException("Trying to map to an unmapped class: " + entityClass.getName());
        }
        try {
            Object object = this.mapper.fromNodeWithParent(entityClass, node, nodeFilter);
            return (T)object;
        }
        catch (ClassNotFoundException e) {
            throw new JcrMappingException("Could not map Object from node", e);
        }
        catch (InstantiationException e) {
            throw new JcrMappingException("Could not map Object from node", e);
        }
        catch (RepositoryException e) {
            throw new JcrMappingException("Could not map Object from node", e);
        }
        catch (IllegalAccessException e) {
            throw new JcrMappingException("Could not map Object from node", e);
        }
        catch (IOException e) {
            throw new JcrMappingException("Could not map Object from node", e);
        }
        finally {
            this.mapper.clearHistory();
        }
    }

    public Node addNode(Node parentNode, Object entity) throws JcrMappingException {
        return this.addNode(parentNode, entity, null);
    }

    public Node addNode(Node parentNode, Object entity, String[] mixinTypes) throws JcrMappingException {
        if (!this.mapper.isMapped(entity.getClass())) {
            throw new JcrMappingException("Trying to map an unmapped class: " + entity.getClass().getName());
        }
        try {
            Node node = this.mapper.addNode(parentNode, entity, mixinTypes);
            return node;
        }
        catch (RepositoryException e) {
            throw new JcrMappingException("Could not create node from object", e);
        }
        catch (IllegalAccessException e) {
            throw new JcrMappingException("Could not create node from object", e);
        }
        catch (IOException e) {
            throw new JcrMappingException("Could not create node from object", e);
        }
        finally {
            this.mapper.clearHistory();
        }
    }

    public Node updateNode(Node node, Object entity) throws JcrMappingException {
        return this.updateNode(node, entity, new NodeFilter("*", -1));
    }

    public Node updateNode(Node node, Object entity, String childNodeFilter, int maxDepth) throws JcrMappingException {
        return this.updateNode(node, entity, new NodeFilter(childNodeFilter, maxDepth));
    }

    public Node updateNode(Node node, Object entity, NodeFilter nodeFilter) throws JcrMappingException {
        if (!this.mapper.isMapped(entity.getClass())) {
            throw new JcrMappingException("Trying to map an unmapped class: " + entity.getClass().getName());
        }
        try {
            Node node2 = this.mapper.updateNode(node, entity, nodeFilter);
            return node2;
        }
        catch (RepositoryException e) {
            throw new JcrMappingException("Could not update node from object", e);
        }
        catch (IllegalAccessException e) {
            throw new JcrMappingException("Could not update node from object", e);
        }
        catch (IOException e) {
            throw new JcrMappingException("Could not update node from object", e);
        }
        finally {
            this.mapper.clearHistory();
        }
    }

    public static void setCurrentSession(Session session) {
        currentSession.set(session);
    }

    public static Session getCurrentSession() {
        return currentSession.get();
    }

    public void setAnnotationReader(AnnotationReader annotationReader) {
        this.annotationReader = annotationReader;
    }

    public AnnotationReader getAnnotationReader() {
        return this.annotationReader;
    }

    public void setSessionFactory(SessionFactory sessionFactory) {
        this.sessionFactory = sessionFactory;
    }

    public SessionFactory getSessionFactory() {
        return this.sessionFactory;
    }

    public void logNodeInfos(Node node) throws RepositoryException {
        Value value;
        int n;
        int n2;
        Value[] valueArray;
        Property p;
        PropertyIterator iter = node.getProperties();
        while (iter.hasNext()) {
            p = iter.nextProperty();
            if (p.isMultiple()) {
                valueArray = p.getValues();
                n2 = valueArray.length;
                n = 0;
                while (n < n2) {
                    value = valueArray[n];
                    System.out.println(String.valueOf(p.getName()) + " = " + value.getString());
                    ++n;
                }
                continue;
            }
            System.out.println(String.valueOf(p.getName()) + " = " + p.getValue().getString());
        }
        iter = node.getReferences();
        while (iter.hasNext()) {
            p = iter.nextProperty();
            if (p.isMultiple()) {
                valueArray = p.getValues();
                n2 = valueArray.length;
                n = 0;
                while (n < n2) {
                    value = valueArray[n];
                    System.out.println(String.valueOf(p.getName()) + " = " + value.getString());
                    ++n;
                }
                continue;
            }
            System.out.println(String.valueOf(p.getName()) + " = " + p.getValue().getString());
        }
        iter = node.getWeakReferences();
        while (iter.hasNext()) {
            p = iter.nextProperty();
            if (p.isMultiple()) {
                valueArray = p.getValues();
                n2 = valueArray.length;
                n = 0;
                while (n < n2) {
                    value = valueArray[n];
                    System.out.println(String.valueOf(p.getName()) + " = " + value.getString());
                    ++n;
                }
                continue;
            }
            System.out.println(String.valueOf(p.getName()) + " = " + p.getValue().getString());
        }
    }
}

