/*
 * Decompiled with CFR 0.152.
 */
package org.jcrom;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.sql.Timestamp;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArraySet;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.RepositoryException;
import javax.jcr.nodetype.NodeType;
import javax.jcr.version.Version;
import javax.jcr.version.VersionManager;
import net.sf.cglib.proxy.LazyLoader;
import org.jcrom.ChildNodeMapper;
import org.jcrom.FileNodeMapper;
import org.jcrom.JcrFile;
import org.jcrom.JcrMappingException;
import org.jcrom.Jcrom;
import org.jcrom.PropertyMapper;
import org.jcrom.ReferenceMapper;
import org.jcrom.annotations.JcrBaseVersionCreated;
import org.jcrom.annotations.JcrBaseVersionName;
import org.jcrom.annotations.JcrCheckedout;
import org.jcrom.annotations.JcrChildNode;
import org.jcrom.annotations.JcrCreated;
import org.jcrom.annotations.JcrFileNode;
import org.jcrom.annotations.JcrIdentifier;
import org.jcrom.annotations.JcrName;
import org.jcrom.annotations.JcrNode;
import org.jcrom.annotations.JcrParentNode;
import org.jcrom.annotations.JcrPath;
import org.jcrom.annotations.JcrProperty;
import org.jcrom.annotations.JcrReference;
import org.jcrom.annotations.JcrSerializedProperty;
import org.jcrom.annotations.JcrUUID;
import org.jcrom.annotations.JcrVersionCreated;
import org.jcrom.annotations.JcrVersionName;
import org.jcrom.util.JcrUtils;
import org.jcrom.util.NodeFilter;
import org.jcrom.util.PathUtils;
import org.jcrom.util.ReflectionUtils;

class Mapper {
    static final String DEFAULT_FIELDNAME = "fieldName";
    private final CopyOnWriteArraySet<Class<?>> mappedClasses = new CopyOnWriteArraySet();
    private final boolean cleanNames;
    private final boolean dynamicInstantiation;
    private final PropertyMapper propertyMapper;
    private final ReferenceMapper referenceMapper;
    private final FileNodeMapper fileNodeMapper;
    private final ChildNodeMapper childNodeMapper;
    private final Jcrom jcrom;
    private final ThreadLocal<Map<HistoryKey, Object>> history = new ThreadLocal();

    Mapper(boolean cleanNames, boolean dynamicInstantiation, Jcrom jcrom) {
        this.cleanNames = cleanNames;
        this.dynamicInstantiation = dynamicInstantiation;
        this.jcrom = jcrom;
        this.propertyMapper = new PropertyMapper(this);
        this.referenceMapper = new ReferenceMapper(this);
        this.fileNodeMapper = new FileNodeMapper(this);
        this.childNodeMapper = new ChildNodeMapper(this);
    }

    void clearHistory() {
        this.history.remove();
    }

    boolean isMapped(Class<?> c) {
        return this.mappedClasses.contains(c);
    }

    void addMappedClass(Class<?> c) {
        this.mappedClasses.add(c);
    }

    CopyOnWriteArraySet<Class<?>> getMappedClasses() {
        return this.mappedClasses;
    }

    boolean isCleanNames() {
        return this.cleanNames;
    }

    boolean isDynamicInstantiation() {
        return this.dynamicInstantiation;
    }

    Class<?> getClassForName(String className) {
        return this.getClassForName(className, null);
    }

    Class<?> getClassForName(String className, Class<?> defaultClass) {
        for (Class<?> c : this.mappedClasses) {
            if (!className.equals(c.getCanonicalName())) continue;
            return c;
        }
        try {
            return Class.forName(className, true, Thread.currentThread().getContextClassLoader());
        }
        catch (ClassNotFoundException ex) {
            return defaultClass;
        }
    }

    String getCleanName(String name) {
        if (name == null) {
            throw new JcrMappingException("Node name is null");
        }
        if (this.cleanNames) {
            return PathUtils.createValidName(name);
        }
        return name;
    }

    Object findEntityByPath(List<?> entities, String path) throws IllegalAccessException {
        for (Object entity : entities) {
            if (!path.equals(this.getNodePath(entity))) continue;
            return entity;
        }
        return null;
    }

    private Field findAnnotatedField(Object obj, Class<? extends Annotation> annotationClass) {
        Field[] fieldArray = ReflectionUtils.getDeclaredAndInheritedFields(obj.getClass(), false);
        int n = fieldArray.length;
        int n2 = 0;
        while (n2 < n) {
            Field field = fieldArray[n2];
            if (this.jcrom.getAnnotationReader().isAnnotationPresent(field, annotationClass).booleanValue()) {
                field.setAccessible(true);
                return field;
            }
            ++n2;
        }
        return null;
    }

    Field findPathField(Object obj) {
        return this.findAnnotatedField(obj, JcrPath.class);
    }

    Field findParentField(Object obj) {
        return this.findAnnotatedField(obj, JcrParentNode.class);
    }

    Field findNameField(Object obj) {
        return this.findAnnotatedField(obj, JcrName.class);
    }

    @Deprecated
    Field findUUIDField(Object obj) {
        return this.findAnnotatedField(obj, JcrUUID.class);
    }

    Field findIdField(Object obj) {
        return this.findAnnotatedField(obj, JcrIdentifier.class);
    }

    String getNodeName(Object object) throws IllegalAccessException {
        return (String)this.findNameField(object).get(object);
    }

    String getNodePath(Object object) throws IllegalAccessException {
        return (String)this.findPathField(object).get(object);
    }

    Object getParentObject(Object childObject) throws IllegalAccessException {
        Field parentField = this.findParentField(childObject);
        return parentField != null ? parentField.get(childObject) : null;
    }

    String getChildContainerNodePath(Object childObject, Object parentObject, Node parentNode) throws IllegalAccessException, RepositoryException {
        return this.childNodeMapper.getChildContainerNodePath(childObject, parentObject, parentNode);
    }

    @Deprecated
    String getNodeUUID(Object object) throws IllegalAccessException {
        return (String)this.findUUIDField(object).get(object);
    }

    String getNodeId(Object object) throws IllegalAccessException {
        Field idField = this.findIdField(object);
        return idField != null ? (String)idField.get(object) : this.getNodeUUID(object);
    }

    static boolean hasMixinType(Node node, String mixinType) throws RepositoryException {
        NodeType[] nodeTypeArray = node.getMixinNodeTypes();
        int n = nodeTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            NodeType nodeType = nodeTypeArray[n2];
            if (nodeType.getName().equals(mixinType)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    void setBaseVersionInfo(Object object, String name, Calendar created) throws IllegalAccessException {
        Field baseCreated;
        Field baseName = this.findAnnotatedField(object, JcrBaseVersionName.class);
        if (baseName != null) {
            baseName.set(object, name);
        }
        if ((baseCreated = this.findAnnotatedField(object, JcrBaseVersionCreated.class)) != null) {
            if (baseCreated.getType() == Date.class) {
                baseCreated.set(object, created.getTime());
            } else if (baseCreated.getType() == Timestamp.class) {
                baseCreated.set(object, new Timestamp(created.getTimeInMillis()));
            } else if (baseCreated.getType() == Calendar.class) {
                baseCreated.set(object, created);
            }
        }
    }

    void setNodeName(Object object, String name) throws IllegalAccessException {
        this.findNameField(object).set(object, name);
    }

    void setNodePath(Object object, String path) throws IllegalAccessException {
        this.findPathField(object).set(object, path);
    }

    @Deprecated
    void setUUID(Object object, String uuid) throws IllegalAccessException {
        Field uuidField = this.findUUIDField(object);
        if (uuidField != null) {
            uuidField.set(object, uuid);
        }
    }

    void setId(Object object, String id) throws IllegalAccessException {
        Field idField = this.findIdField(object);
        if (idField != null) {
            idField.set(object, id);
        }
    }

    Node checkIfVersionedChild(Node node) throws RepositoryException {
        if (node.hasProperty("{http://www.jcp.org/jcr/1.0}childVersionHistory")) {
            Node versionNode = Mapper.getNodeById(node, node.getProperty("{http://www.jcp.org/jcr/1.0}childVersionHistory").getString());
            NodeIterator it = versionNode.getNodes();
            while (it.hasNext()) {
                Node n = it.nextNode();
                if (n.getName().equals("jcr:rootVersion") || n.getName().equals("{http://www.jcp.org/jcr/1.0}rootVersion") || !n.isNodeType("{http://www.jcp.org/jcr/nt/1.0}version") || !n.hasNode("{http://www.jcp.org/jcr/1.0}frozenNode") || node.getPath().indexOf("/" + n.getName() + "/") == -1) continue;
                return n.getNode("{http://www.jcp.org/jcr/1.0}frozenNode");
            }
            return node;
        }
        return node;
    }

    Object findParentObjectFromNode(Node node) throws RepositoryException, IllegalAccessException, ClassNotFoundException, InstantiationException, IOException {
        Object parentObj = null;
        Node parentNode = node.getParent();
        while (parentNode != null) {
            Class<?> parentClass = this.findClassFromNode(Object.class, parentNode);
            if (parentClass != null && !parentClass.equals(Object.class)) {
                parentObj = this.fromNode(parentClass, parentNode, new NodeFilter("*", 0));
                break;
            }
            try {
                parentNode = parentNode.getParent();
            }
            catch (Exception ignore) {
                parentNode = null;
            }
        }
        return parentObj;
    }

    Class<?> findClassFromNode(Class<?> defaultClass, Node node) throws RepositoryException, IllegalAccessException, ClassNotFoundException, InstantiationException {
        if (this.dynamicInstantiation) {
            String classNameProperty = "className";
            JcrNode jcrNode = ReflectionUtils.getJcrNodeAnnotation(defaultClass);
            if (jcrNode != null && !jcrNode.classNameProperty().equals("none")) {
                classNameProperty = jcrNode.classNameProperty();
            }
            if (node.hasProperty(classNameProperty)) {
                String className = node.getProperty(classNameProperty).getString();
                Class<?> c = this.getClassForName(className, defaultClass);
                if (this.isMapped(c)) {
                    return c;
                }
                throw new JcrMappingException("Trying to instantiate unmapped class: " + c.getName());
            }
            return defaultClass;
        }
        return defaultClass;
    }

    Object createInstanceForNode(Class<?> objClass, Node node) throws RepositoryException, IllegalAccessException, ClassNotFoundException, InstantiationException {
        return this.findClassFromNode(objClass, node).newInstance();
    }

    Object fromNodeWithParent(Class<?> entityClass, Node node, NodeFilter nodeFilter) throws ClassNotFoundException, InstantiationException, RepositoryException, IllegalAccessException, IOException {
        this.history.set(new HashMap());
        Object obj = this.createInstanceForNode(entityClass, node);
        Object parentObj = this.findParentObjectFromNode(node);
        if (ReflectionUtils.extendsClass(obj.getClass(), JcrFile.class)) {
            this.fileNodeMapper.mapSingleFile((JcrFile)obj, node, parentObj, 0, nodeFilter, this);
        }
        this.mapNodeToClass(obj, node, nodeFilter, parentObj, 0);
        this.history.remove();
        return obj;
    }

    Object fromNode(Class<?> entityClass, Node node, NodeFilter nodeFilter) throws ClassNotFoundException, InstantiationException, RepositoryException, IllegalAccessException, IOException {
        this.history.set(new HashMap());
        Object obj = this.createInstanceForNode(entityClass, node);
        if (ReflectionUtils.extendsClass(obj.getClass(), JcrFile.class)) {
            this.fileNodeMapper.mapSingleFile((JcrFile)obj, node, null, 0, nodeFilter, this);
        }
        this.mapNodeToClass(obj, node, nodeFilter, null, 0);
        this.history.remove();
        return obj;
    }

    Node updateNode(Node node, Object entity, NodeFilter nodeFilter) throws RepositoryException, IllegalAccessException, IOException {
        return this.updateNode(node, entity, entity.getClass(), nodeFilter, 0);
    }

    Node updateNode(Node node, Object obj, Class<?> objClass, NodeFilter nodeFilter, int depth) throws RepositoryException, IllegalAccessException, IOException {
        obj = this.clearCglib(obj);
        JcrNode jcrNode = ReflectionUtils.getJcrNodeAnnotation(objClass);
        if (jcrNode != null && !jcrNode.classNameProperty().equals("none")) {
            Class<?> oldClass;
            String oldClassName;
            if (node.hasProperty(jcrNode.classNameProperty()) && !(oldClassName = node.getProperty(jcrNode.classNameProperty()).getString()).equals(obj.getClass().getCanonicalName()) && (oldClass = this.getClassForName(oldClassName)) != null) {
                Class<?> newClass = obj.getClass();
                HashSet<Field> oldFields = new HashSet<Field>();
                oldFields.addAll(Arrays.asList(ReflectionUtils.getDeclaredAndInheritedFields(oldClass, true)));
                oldFields.removeAll(Arrays.asList(ReflectionUtils.getDeclaredAndInheritedFields(newClass, true)));
                for (Field field : oldFields) {
                    if (!node.hasProperty(field.getName())) continue;
                    node.getProperty(field.getName()).remove();
                }
            }
            node.setProperty(jcrNode.classNameProperty(), obj.getClass().getCanonicalName());
        }
        if (ReflectionUtils.extendsClass(obj.getClass(), JcrFile.class) && depth == 0) {
            this.fileNodeMapper.addFileNode(node, (JcrFile)obj, this);
        }
        Field[] fieldArray = ReflectionUtils.getDeclaredAndInheritedFields(objClass, true);
        int n = fieldArray.length;
        int oldClass = 0;
        while (oldClass < n) {
            Field field = fieldArray[oldClass];
            field.setAccessible(true);
            if (this.jcrom.getAnnotationReader().isAnnotationPresent(field, JcrProperty.class).booleanValue()) {
                this.propertyMapper.mapFieldToProperty(field, obj, node, this);
            } else if (this.jcrom.getAnnotationReader().isAnnotationPresent(field, JcrSerializedProperty.class).booleanValue()) {
                this.propertyMapper.mapSerializedFieldToProperty(field, obj, node);
            } else if (this.jcrom.getAnnotationReader().isAnnotationPresent(field, JcrChildNode.class).booleanValue() && nodeFilter.isDepthIncluded(depth)) {
                this.childNodeMapper.updateChildren(field, obj, node, depth, nodeFilter, this);
            } else if (this.jcrom.getAnnotationReader().isAnnotationPresent(field, JcrReference.class).booleanValue()) {
                this.referenceMapper.updateReferences(field, obj, node, nodeFilter);
            } else if (this.jcrom.getAnnotationReader().isAnnotationPresent(field, JcrFileNode.class).booleanValue() && nodeFilter.isDepthIncluded(depth)) {
                this.fileNodeMapper.updateFiles(field, obj, node, this, depth, nodeFilter);
            }
            ++oldClass;
        }
        if (!node.getName().equals(this.getCleanName(this.getNodeName(obj)))) {
            boolean isVersionable = JcrUtils.hasMixinType(node, "mix:versionable") || JcrUtils.hasMixinType(node, "{http://www.jcp.org/jcr/mix/1.0}versionable");
            Node parent = node.getParent();
            if (isVersionable && (JcrUtils.hasMixinType(parent, "mix:versionable") || JcrUtils.hasMixinType(parent, "{http://www.jcp.org/jcr/mix/1.0}versionable"))) {
                JcrUtils.checkout(parent);
            }
            if (parent.getPath().equals("/")) {
                node.getSession().move(node.getPath(), String.valueOf(parent.getPath()) + this.getCleanName(this.getNodeName(obj)));
            } else {
                node.getSession().move(node.getPath(), String.valueOf(parent.getPath()) + "/" + this.getCleanName(this.getNodeName(obj)));
            }
            if (isVersionable && (JcrUtils.hasMixinType(parent, "mix:versionable") || JcrUtils.hasMixinType(parent, "{http://www.jcp.org/jcr/mix/1.0}versionable")) && parent.isCheckedOut()) {
                node.getSession().save();
                JcrUtils.checkin(parent);
            }
            this.setNodeName(obj, node.getName());
            this.setNodePath(obj, node.getPath());
        }
        return node;
    }

    Node addNode(Node parentNode, Object entity, String[] mixinTypes) throws IllegalAccessException, RepositoryException, IOException {
        return this.addNode(parentNode, entity, mixinTypes, true);
    }

    Node addNode(Node parentNode, Object entity, String[] mixinTypes, boolean createNode) throws IllegalAccessException, RepositoryException, IOException {
        int n;
        int n2;
        Object[] objectArray;
        Node node;
        entity = this.clearCglib(entity);
        JcrNode jcrNode = ReflectionUtils.getJcrNodeAnnotation(entity.getClass());
        if (createNode) {
            Object mixinType;
            node = jcrNode == null || jcrNode.nodeType().equals("nt:unstructured") || jcrNode.nodeType().equals("{http://www.jcp.org/jcr/nt/1.0}unstructured") ? parentNode.addNode(this.getCleanName(this.getNodeName(entity))) : parentNode.addNode(this.getCleanName(this.getNodeName(entity)), jcrNode.nodeType());
            if (mixinTypes != null) {
                objectArray = mixinTypes;
                n2 = mixinTypes.length;
                n = 0;
                while (n < n2) {
                    mixinType = objectArray[n];
                    if (node.canAddMixin((String)mixinType)) {
                        node.addMixin((String)mixinType);
                    }
                    ++n;
                }
            }
            if (jcrNode != null && jcrNode.mixinTypes() != null) {
                objectArray = jcrNode.mixinTypes();
                n2 = objectArray.length;
                n = 0;
                while (n < n2) {
                    mixinType = objectArray[n];
                    if (node.canAddMixin((String)mixinType)) {
                        node.addMixin((String)mixinType);
                    }
                    ++n;
                }
            }
            this.setId(entity, node.getIdentifier());
            this.setNodeName(entity, node.getName());
            this.setNodePath(entity, node.getPath());
            if (node.hasProperty("{http://www.jcp.org/jcr/1.0}uuid")) {
                this.setUUID(entity, node.getIdentifier());
            }
        } else {
            node = parentNode;
        }
        if (jcrNode != null && !jcrNode.classNameProperty().equals("none")) {
            node.setProperty(jcrNode.classNameProperty(), entity.getClass().getCanonicalName());
        }
        if (ReflectionUtils.extendsClass(entity.getClass(), JcrFile.class)) {
            this.fileNodeMapper.addFileNode(node, (JcrFile)entity, this);
        }
        objectArray = ReflectionUtils.getDeclaredAndInheritedFields(entity.getClass(), true);
        n2 = objectArray.length;
        n = 0;
        while (n < n2) {
            Object field = objectArray[n];
            ((Field)field).setAccessible(true);
            if (this.jcrom.getAnnotationReader().isAnnotationPresent((Field)field, JcrProperty.class).booleanValue()) {
                this.propertyMapper.mapFieldToProperty((Field)field, entity, node, this);
            } else if (this.jcrom.getAnnotationReader().isAnnotationPresent((Field)field, JcrSerializedProperty.class).booleanValue()) {
                this.propertyMapper.mapSerializedFieldToProperty((Field)field, entity, node);
            } else if (this.jcrom.getAnnotationReader().isAnnotationPresent((Field)field, JcrChildNode.class).booleanValue()) {
                this.childNodeMapper.addChildren((Field)field, entity, node, this);
            } else if (this.jcrom.getAnnotationReader().isAnnotationPresent((Field)field, JcrReference.class).booleanValue()) {
                this.referenceMapper.addReferences((Field)field, entity, node);
            } else if (this.jcrom.getAnnotationReader().isAnnotationPresent((Field)field, JcrFileNode.class).booleanValue()) {
                this.fileNodeMapper.addFiles((Field)field, entity, node, this);
            }
            ++n;
        }
        return node;
    }

    private boolean isVersionable(Node node) throws RepositoryException {
        NodeType[] nodeTypeArray = node.getMixinNodeTypes();
        int n = nodeTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            NodeType mixinType = nodeTypeArray[n2];
            if (mixinType.getName().equals("mix:versionable") || mixinType.getName().equals("{http://www.jcp.org/jcr/mix/1.0}versionable")) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    Object mapNodeToClass(Object obj, Node node, NodeFilter nodeFilter, Object parentObject, int depth) throws ClassNotFoundException, InstantiationException, RepositoryException, IllegalAccessException, IOException {
        if (!ReflectionUtils.extendsClass(obj.getClass(), JcrFile.class)) {
            this.setNodeName(obj, node.getName());
        }
        HistoryKey key = new HistoryKey();
        key.path = node.getPath();
        if (nodeFilter.getMaxDepth() == -1) {
            key.depth = -1;
        } else {
            key.depth = nodeFilter.getMaxDepth() - depth;
        }
        if (this.history.get() == null) {
            this.history.set(new HashMap());
        }
        if (this.history.get().containsKey(key)) {
            return this.history.get().get(key);
        }
        this.history.get().put(key, obj);
        Field[] fieldArray = ReflectionUtils.getDeclaredAndInheritedFields(obj.getClass(), false);
        int n = fieldArray.length;
        int n2 = 0;
        while (n2 < n) {
            Version baseVersion;
            Field field = fieldArray[n2];
            field.setAccessible(true);
            if (this.jcrom.getAnnotationReader().isAnnotationPresent(field, JcrProperty.class).booleanValue()) {
                this.propertyMapper.mapPropertyToField(obj, field, node);
            } else if (this.jcrom.getAnnotationReader().isAnnotationPresent(field, JcrSerializedProperty.class).booleanValue()) {
                this.propertyMapper.mapSerializedPropertyToField(obj, field, node);
            } else if (this.jcrom.getAnnotationReader().isAnnotationPresent(field, JcrUUID.class).booleanValue()) {
                if (node.hasProperty("{http://www.jcp.org/jcr/1.0}uuid")) {
                    field.set(obj, node.getIdentifier());
                }
            } else if (this.jcrom.getAnnotationReader().isAnnotationPresent(field, JcrIdentifier.class).booleanValue()) {
                field.set(obj, node.getIdentifier());
            } else if (this.jcrom.getAnnotationReader().isAnnotationPresent(field, JcrBaseVersionName.class).booleanValue()) {
                if (this.isVersionable(node)) {
                    baseVersion = Mapper.getVersionManager(node).getBaseVersion(node.getPath());
                    field.set(obj, baseVersion.getName());
                }
            } else if (this.jcrom.getAnnotationReader().isAnnotationPresent(field, JcrBaseVersionCreated.class).booleanValue()) {
                if (this.isVersionable(node)) {
                    baseVersion = Mapper.getVersionManager(node).getBaseVersion(node.getPath());
                    field.set(obj, this.propertyMapper.getValue(field.getType(), node.getSession().getValueFactory().createValue(baseVersion.getCreated())));
                }
            } else if (this.jcrom.getAnnotationReader().isAnnotationPresent(field, JcrVersionName.class).booleanValue()) {
                if (node.getParent() != null && node.getParent().isNodeType("{http://www.jcp.org/jcr/nt/1.0}version")) {
                    field.set(obj, node.getParent().getName());
                } else if (this.isVersionable(node)) {
                    baseVersion = Mapper.getVersionManager(node).getBaseVersion(node.getPath());
                    field.set(obj, baseVersion.getName());
                }
            } else if (this.jcrom.getAnnotationReader().isAnnotationPresent(field, JcrVersionCreated.class).booleanValue()) {
                if (node.getParent() != null && node.getParent().isNodeType("{http://www.jcp.org/jcr/nt/1.0}version")) {
                    Version version = (Version)node.getParent();
                    field.set(obj, this.propertyMapper.getValue(field.getType(), node.getSession().getValueFactory().createValue(version.getCreated())));
                } else if (this.isVersionable(node)) {
                    baseVersion = Mapper.getVersionManager(node).getBaseVersion(node.getPath());
                    field.set(obj, this.propertyMapper.getValue(field.getType(), node.getSession().getValueFactory().createValue(baseVersion.getCreated())));
                }
            } else if (this.jcrom.getAnnotationReader().isAnnotationPresent(field, JcrCheckedout.class).booleanValue()) {
                field.set(obj, node.isCheckedOut());
            } else if (this.jcrom.getAnnotationReader().isAnnotationPresent(field, JcrCreated.class).booleanValue()) {
                if (node.hasProperty("{http://www.jcp.org/jcr/1.0}created")) {
                    field.set(obj, this.propertyMapper.getValue(field.getType(), node.getProperty("{http://www.jcp.org/jcr/1.0}created").getValue()));
                }
            } else if (this.jcrom.getAnnotationReader().isAnnotationPresent(field, JcrParentNode.class).booleanValue()) {
                if (parentObject != null && field.getType().isInstance(parentObject)) {
                    field.set(obj, parentObject);
                }
            } else if (this.jcrom.getAnnotationReader().isAnnotationPresent(field, JcrChildNode.class).booleanValue() && nodeFilter.isDepthIncluded(depth)) {
                this.childNodeMapper.getChildrenFromNode(field, node, obj, depth, nodeFilter, this);
            } else if (this.jcrom.getAnnotationReader().isAnnotationPresent(field, JcrReference.class).booleanValue()) {
                this.referenceMapper.getReferencesFromNode(field, node, obj, depth, nodeFilter, this);
            } else if (this.jcrom.getAnnotationReader().isAnnotationPresent(field, JcrFileNode.class).booleanValue() && nodeFilter.isDepthIncluded(depth)) {
                this.fileNodeMapper.getFilesFromNode(field, node, obj, depth, nodeFilter, this);
            } else if (this.jcrom.getAnnotationReader().isAnnotationPresent(field, JcrPath.class).booleanValue()) {
                field.set(obj, node.getPath());
            }
            ++n2;
        }
        return obj;
    }

    static byte[] readBytes(InputStream in) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            int len;
            byte[] buf = new byte[1024];
            while ((len = in.read(buf)) > 0) {
                out.write(buf, 0, len);
            }
        }
        finally {
            in.close();
            out.close();
        }
        return out.toByteArray();
    }

    static VersionManager getVersionManager(Node node) throws RepositoryException {
        VersionManager versionMgr = node.getSession().getWorkspace().getVersionManager();
        return versionMgr;
    }

    static Node getNodeById(Node node, String id) throws RepositoryException {
        return node.getSession().getNodeByIdentifier(id);
    }

    Object clearCglib(Object obj) throws IllegalAccessException {
        Field[] fieldArray = ReflectionUtils.getDeclaredAndInheritedFields(obj.getClass(), true);
        int n = fieldArray.length;
        int n2 = 0;
        while (n2 < n) {
            Field field = fieldArray[n2];
            field.setAccessible(true);
            if (field.getName().equals("CGLIB$LAZY_LOADER_0")) {
                if (field.get(obj) != null) {
                    return field.get(obj);
                }
                return this.triggerLazyLoading(obj);
            }
            ++n2;
        }
        return obj;
    }

    Object triggerLazyLoading(Object obj) throws IllegalAccessException {
        Field[] fieldArray = ReflectionUtils.getDeclaredAndInheritedFields(obj.getClass(), false);
        int n = fieldArray.length;
        int n2 = 0;
        while (n2 < n) {
            Field field = fieldArray[n2];
            field.setAccessible(true);
            if (field.getName().equals("CGLIB$CALLBACK_0")) {
                try {
                    return ((LazyLoader)field.get(obj)).loadObject();
                }
                catch (Exception e) {
                    throw new JcrMappingException("Could not trigger lazy loading", e);
                }
            }
            ++n2;
        }
        return obj;
    }

    PropertyMapper getPropertyMapper() {
        return this.propertyMapper;
    }

    ReferenceMapper getReferenceMapper() {
        return this.referenceMapper;
    }

    FileNodeMapper getFileNodeMapper() {
        return this.fileNodeMapper;
    }

    ChildNodeMapper getChildNodeMapper() {
        return this.childNodeMapper;
    }

    Jcrom getJcrom() {
        return this.jcrom;
    }

    private static class HistoryKey {
        private String path;
        private int depth;

        private HistoryKey() {
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.depth;
            result = 31 * result + (this.path == null ? 0 : this.path.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            HistoryKey other = (HistoryKey)obj;
            if (this.depth != other.depth) {
                return false;
            }
            return !(this.path == null ? other.path != null : !this.path.equals(other.path));
        }
    }
}

