/*
 * Decompiled with CFR 0.152.
 */
package org.jcrom;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.StringTokenizer;
import javax.jcr.Binary;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.Property;
import javax.jcr.PropertyIterator;
import javax.jcr.RepositoryException;
import javax.jcr.Value;
import javax.jcr.ValueFactory;
import org.jcrom.Mapper;
import org.jcrom.annotations.JcrProperty;
import org.jcrom.annotations.JcrSerializedProperty;
import org.jcrom.util.ReflectionUtils;

class PropertyMapper {
    private final Mapper mapper;

    public PropertyMapper(Mapper mapper) {
        this.mapper = mapper;
    }

    void mapPropertiesToMap(Object obj, Field field, Class<?> valueType, PropertyIterator propIterator) throws RepositoryException, IOException, IllegalAccessException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        while (propIterator.hasNext()) {
            Property p = propIterator.nextProperty();
            if (p.getName().startsWith("jcr:") || p.getName().startsWith("http://www.jcp.org/jcr/1.0") || p.getName().startsWith("nt:") || p.getName().startsWith("http://www.jcp.org/jcr/nt/1.0")) continue;
            if (valueType.isArray()) {
                if (p.getDefinition().isMultiple()) {
                    map.put(p.getName(), this.valuesToArray(valueType.getComponentType(), p.getValues()));
                    continue;
                }
                Value[] values = new Value[]{p.getValue()};
                map.put(p.getName(), this.valuesToArray(valueType.getComponentType(), values));
                continue;
            }
            map.put(p.getName(), this.getValue(valueType, p.getValue()));
        }
        field.set(obj, map);
    }

    private Object[] valuesToArray(Class<?> type, Value[] values) throws RepositoryException, IOException {
        Object[] arr = (Object[])Array.newInstance(type, values.length);
        int i = 0;
        while (i < values.length) {
            arr[i] = this.getValue(type, values[i]);
            ++i;
        }
        return arr;
    }

    void mapSerializedPropertyToField(Object obj, Field field, Node node) throws RepositoryException, IOException, IllegalAccessException, ClassNotFoundException {
        String propertyName = this.getSerializedPropertyName(field);
        if (node.hasProperty(propertyName)) {
            Property p = node.getProperty(propertyName);
            field.set(obj, this.deserialize(p.getBinary().getStream()));
        }
    }

    private Locale parseLocale(String localeString) {
        if (localeString != null && localeString.length() > 0) {
            StringTokenizer st = new StringTokenizer(localeString, "_");
            String language = st.hasMoreElements() ? st.nextToken() : Locale.getDefault().getLanguage();
            String country = st.hasMoreElements() ? st.nextToken() : "";
            String variant = st.hasMoreElements() ? st.nextToken() : "";
            return new Locale(language, country, variant);
        }
        return null;
    }

    Value createValue(Class<?> c, Object fieldValue, ValueFactory valueFactory) throws RepositoryException {
        if (c == String.class) {
            return valueFactory.createValue((String)fieldValue);
        }
        if (c == Date.class) {
            Calendar cal = Calendar.getInstance();
            cal.setTime((Date)fieldValue);
            return valueFactory.createValue(cal);
        }
        if (c == Timestamp.class) {
            Calendar cal = Calendar.getInstance();
            cal.setTimeInMillis(((Timestamp)fieldValue).getTime());
            return valueFactory.createValue(cal);
        }
        if (c == Calendar.class) {
            return valueFactory.createValue((Calendar)fieldValue);
        }
        if (c == InputStream.class) {
            Binary binary = valueFactory.createBinary((InputStream)fieldValue);
            return valueFactory.createValue(binary);
        }
        if (c.isArray() && c.getComponentType() == Byte.TYPE) {
            Binary binary = valueFactory.createBinary((InputStream)new ByteArrayInputStream((byte[])fieldValue));
            return valueFactory.createValue(binary);
        }
        if (c == Integer.class || c == Integer.TYPE) {
            return valueFactory.createValue((long)((Integer)fieldValue).intValue());
        }
        if (c == Long.class || c == Long.TYPE) {
            return valueFactory.createValue(((Long)fieldValue).longValue());
        }
        if (c == Double.class || c == Double.TYPE) {
            return valueFactory.createValue(((Double)fieldValue).doubleValue());
        }
        if (c == Boolean.class || c == Boolean.TYPE) {
            return valueFactory.createValue(((Boolean)fieldValue).booleanValue());
        }
        if (c == Locale.class) {
            return valueFactory.createValue(((Locale)fieldValue).toString());
        }
        if (c.isEnum()) {
            return valueFactory.createValue(((Enum)fieldValue).name());
        }
        return null;
    }

    Object getValue(Class<?> c, Value value) throws RepositoryException, IOException {
        if (c == String.class) {
            return value.getString();
        }
        if (c == Date.class) {
            return value.getDate().getTime();
        }
        if (c == Timestamp.class) {
            return new Timestamp(value.getDate().getTimeInMillis());
        }
        if (c == Calendar.class) {
            return value.getDate();
        }
        if (c == InputStream.class) {
            return value.getBinary().getStream();
        }
        if (c.isArray() && c.getComponentType() == Byte.TYPE) {
            return Mapper.readBytes(value.getBinary().getStream());
        }
        if (c == Integer.class || c == Integer.TYPE) {
            return (int)value.getDouble();
        }
        if (c == Long.class || c == Long.TYPE) {
            return value.getLong();
        }
        if (c == Double.class || c == Double.TYPE) {
            return value.getDouble();
        }
        if (c == Boolean.class || c == Boolean.TYPE) {
            return value.getBoolean();
        }
        if (c == Locale.class) {
            return this.parseLocale(value.getString());
        }
        if (c.isEnum()) {
            return Enum.valueOf(c, value.getString());
        }
        return null;
    }

    String getSerializedPropertyName(Field field) {
        JcrSerializedProperty jcrProperty = this.mapper.getJcrom().getAnnotationReader().getAnnotation(field, JcrSerializedProperty.class);
        String propertyName = field.getName();
        if (!jcrProperty.name().equals("fieldName")) {
            propertyName = jcrProperty.name();
        }
        return propertyName;
    }

    String getPropertyName(Field field) {
        JcrProperty jcrProperty = this.mapper.getJcrom().getAnnotationReader().getAnnotation(field, JcrProperty.class);
        String name = field.getName();
        if (!jcrProperty.name().equals("fieldName")) {
            name = jcrProperty.name();
        }
        return name;
    }

    void mapPropertyToField(Object obj, Field field, Node node) throws RepositoryException, IllegalAccessException, IOException {
        String name = this.getPropertyName(field);
        if (ReflectionUtils.implementsInterface(field.getType(), Map.class)) {
            Class<?> valueType = ReflectionUtils.getParameterizedClass(field, 1);
            Node childrenContainer = node.getNode(name);
            PropertyIterator propIterator = childrenContainer.getProperties();
            this.mapPropertiesToMap(obj, field, valueType, propIterator);
        } else if (node.hasProperty(name)) {
            Property p = node.getProperty(name);
            if (ReflectionUtils.implementsInterface(field.getType(), List.class)) {
                ArrayList<Object> properties = new ArrayList<Object>();
                Class<?> paramClass = ReflectionUtils.getParameterizedClass(field);
                Value[] valueArray = p.getValues();
                int n = valueArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Value value = valueArray[n2];
                    properties.add(this.getValue(paramClass, value));
                    ++n2;
                }
                field.set(obj, properties);
            } else if (field.getType().isArray() && field.getType().getComponentType() != Byte.TYPE) {
                Value[] values = p.getValues();
                if (field.getType().getComponentType() == Integer.TYPE) {
                    int[] arr = new int[values.length];
                    int i = 0;
                    while (i < values.length) {
                        arr[i] = (int)values[i].getDouble();
                        ++i;
                    }
                    field.set(obj, arr);
                } else if (field.getType().getComponentType() == Long.TYPE) {
                    long[] arr = new long[values.length];
                    int i = 0;
                    while (i < values.length) {
                        arr[i] = values[i].getLong();
                        ++i;
                    }
                    field.set(obj, arr);
                } else if (field.getType().getComponentType() == Double.TYPE) {
                    double[] arr = new double[values.length];
                    int i = 0;
                    while (i < values.length) {
                        arr[i] = values[i].getDouble();
                        ++i;
                    }
                    field.set(obj, arr);
                } else if (field.getType().getComponentType() == Boolean.TYPE) {
                    boolean[] arr = new boolean[values.length];
                    int i = 0;
                    while (i < values.length) {
                        arr[i] = values[i].getBoolean();
                        ++i;
                    }
                    field.set(obj, arr);
                } else if (field.getType().getComponentType() == Locale.class) {
                    Locale[] arr = new Locale[values.length];
                    int i = 0;
                    while (i < values.length) {
                        arr[i] = this.parseLocale(values[i].getString());
                        ++i;
                    }
                    field.set(obj, arr);
                } else {
                    Object[] arr = this.valuesToArray(field.getType().getComponentType(), values);
                    field.set(obj, arr);
                }
            } else {
                field.set(obj, this.getValue(field.getType(), p.getValue()));
            }
        }
    }

    void mapSerializedFieldToProperty(Field field, Object obj, Node node) throws IllegalAccessException, RepositoryException, IOException {
        String propertyName = this.getSerializedPropertyName(field);
        Object fieldValue = field.get(obj);
        if (fieldValue != null) {
            ValueFactory valueFactory = node.getSession().getValueFactory();
            Binary binary = valueFactory.createBinary((InputStream)new ByteArrayInputStream(this.serialize(fieldValue)));
            node.setProperty(propertyName, binary);
        } else {
            node.setProperty(propertyName, null);
        }
    }

    private void addChildMap(Field field, Object obj, Node node, String nodeName, Mapper mapper) throws RepositoryException, IllegalAccessException {
        Map map = (Map)field.get(obj);
        boolean nullOrEmpty = map == null || map.isEmpty();
        NodeIterator nodeIterator = node.getNodes(nodeName);
        while (nodeIterator.hasNext()) {
            nodeIterator.nextNode().remove();
        }
        Node childContainer = node.addNode(mapper.getCleanName(nodeName));
        if (!nullOrEmpty) {
            for (Map.Entry entry : map.entrySet()) {
                this.mapToProperty((String)entry.getKey(), ReflectionUtils.getParameterizedClass(field, 1), null, entry.getValue(), childContainer);
            }
        }
    }

    void mapFieldToProperty(Field field, Object obj, Node node, Mapper mapper) throws RepositoryException, IllegalAccessException {
        String name = this.getPropertyName(field);
        if (ReflectionUtils.implementsInterface(field.getType(), Map.class)) {
            this.addChildMap(field, obj, node, name, mapper);
        } else {
            Class<?> paramClass = ReflectionUtils.implementsInterface(field.getType(), List.class) ? ReflectionUtils.getParameterizedClass(field) : null;
            this.mapToProperty(name, field.getType(), paramClass, field.get(obj), node);
        }
    }

    void mapToProperty(String propertyName, Class<?> type, Class<?> paramClass, Object propertyValue, Node node) throws RepositoryException {
        if (propertyValue != null) {
            ValueFactory valueFactory = node.getSession().getValueFactory();
            if (ReflectionUtils.implementsInterface(type, List.class)) {
                List fieldValues = (List)propertyValue;
                if (!fieldValues.isEmpty()) {
                    Value[] values = new Value[fieldValues.size()];
                    int i = 0;
                    while (i < fieldValues.size()) {
                        values[i] = this.createValue(paramClass, fieldValues.get(i), valueFactory);
                        ++i;
                    }
                    node.setProperty(propertyName, values);
                } else {
                    node.setProperty(propertyName, new Value[0]);
                }
            } else if (type.isArray() && type.getComponentType() != Byte.TYPE) {
                Value[] values;
                if (type.getComponentType() == Integer.TYPE) {
                    int[] ints = (int[])propertyValue;
                    values = new Value[ints.length];
                    int i = 0;
                    while (i < ints.length) {
                        values[i] = this.createValue(Integer.TYPE, ints[i], valueFactory);
                        ++i;
                    }
                } else if (type.getComponentType() == Long.TYPE) {
                    long[] longs = (long[])propertyValue;
                    values = new Value[longs.length];
                    int i = 0;
                    while (i < longs.length) {
                        values[i] = this.createValue(Long.TYPE, longs[i], valueFactory);
                        ++i;
                    }
                } else if (type.getComponentType() == Double.TYPE) {
                    double[] doubles = (double[])propertyValue;
                    values = new Value[doubles.length];
                    int i = 0;
                    while (i < doubles.length) {
                        values[i] = this.createValue(Double.TYPE, doubles[i], valueFactory);
                        ++i;
                    }
                } else if (type.getComponentType() == Boolean.TYPE) {
                    boolean[] booleans = (boolean[])propertyValue;
                    values = new Value[booleans.length];
                    int i = 0;
                    while (i < booleans.length) {
                        values[i] = this.createValue(Boolean.TYPE, booleans[i], valueFactory);
                        ++i;
                    }
                } else if (type.getComponentType() == Locale.class) {
                    Locale[] locales = (Locale[])propertyValue;
                    values = new Value[locales.length];
                    int i = 0;
                    while (i < locales.length) {
                        values[i] = this.createValue(Locale.class, locales[i], valueFactory);
                        ++i;
                    }
                } else {
                    Object[] objects = (Object[])propertyValue;
                    values = new Value[objects.length];
                    int i = 0;
                    while (i < objects.length) {
                        values[i] = this.createValue(type.getComponentType(), objects[i], valueFactory);
                        ++i;
                    }
                }
                node.setProperty(propertyName, values);
            } else {
                Value value = this.createValue(type, propertyValue, valueFactory);
                if (value != null) {
                    node.setProperty(propertyName, value);
                }
            }
        } else if (ReflectionUtils.implementsInterface(type, List.class)) {
            node.setProperty(propertyName, null);
        } else {
            node.setProperty(propertyName, null);
        }
    }

    byte[] serialize(Object obj) throws IOException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        ObjectOutputStream out = new ObjectOutputStream(bos);
        try {
            out.writeObject(obj);
        }
        finally {
            out.close();
        }
        return bos.toByteArray();
    }

    private Object deserialize(InputStream byteStream) throws IOException, ClassNotFoundException {
        ObjectInputStream in = new ObjectInputStream(byteStream);
        try {
            Object object = in.readObject();
            return object;
        }
        finally {
            in.close();
        }
    }
}

