/*
 * Decompiled with CFR 0.152.
 */
package org.jcrom;

import java.lang.reflect.Field;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.jcr.Node;
import javax.jcr.Session;
import org.jcrom.AbstractLazyLoader;
import org.jcrom.Mapper;
import org.jcrom.util.NodeFilter;
import org.jcrom.util.PathUtils;

public class ReferenceListLoader
extends AbstractLazyLoader {
    private static final Logger logger = Logger.getLogger(ReferenceListLoader.class.getName());
    private final Class<?> objClass;
    private final Object parentObject;
    private final String nodePath;
    private final String propertyName;
    private final int depth;
    private final NodeFilter nodeFilter;
    private final Field field;

    ReferenceListLoader(Class<?> objClass, Object parentObject, String nodePath, String propertyName, Session session, Mapper mapper, int depth, NodeFilter nodeFilter, Field field) {
        super(session, mapper);
        this.objClass = objClass;
        this.parentObject = parentObject;
        this.nodePath = nodePath;
        this.propertyName = propertyName;
        this.depth = depth;
        this.nodeFilter = nodeFilter;
        this.field = field;
    }

    @Override
    protected Object doLoadObject(Session session, Mapper mapper) throws Exception {
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("Lazy loading reference list for " + this.nodePath + " " + this.propertyName);
        }
        Node node = PathUtils.getNode(this.nodePath, session);
        return mapper.getReferenceMapper().getReferenceList(this.field, this.propertyName, this.objClass, node, this.parentObject, this.depth, this.nodeFilter, mapper);
    }
}

