/*
 * Decompiled with CFR 0.152.
 */
package org.jcrom;

import java.io.IOException;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.jcr.Node;
import javax.jcr.Property;
import javax.jcr.PropertyIterator;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.Value;
import org.jcrom.Mapper;
import org.jcrom.ProxyFactory;
import org.jcrom.annotations.JcrReference;
import org.jcrom.util.NodeFilter;
import org.jcrom.util.PathUtils;
import org.jcrom.util.ReflectionUtils;

class ReferenceMapper {
    private final Mapper mapper;

    public ReferenceMapper(Mapper mapper) {
        this.mapper = mapper;
    }

    private String getPropertyName(Field field) {
        JcrReference jcrReference = this.mapper.getJcrom().getAnnotationReader().getAnnotation(field, JcrReference.class);
        String name = field.getName();
        if (!jcrReference.name().equals("fieldName")) {
            name = jcrReference.name();
        }
        return name;
    }

    private List<Value> getReferenceValues(List<?> references, Session session, JcrReference jcrReference) throws IllegalAccessException, RepositoryException {
        ArrayList<Value> refValues = new ArrayList<Value>();
        for (Object reference : references) {
            if (jcrReference.byPath()) {
                String referencePath = this.mapper.getNodePath(reference);
                if (referencePath == null || referencePath.equals("") || !session.getRootNode().hasNode(PathUtils.relativePath(referencePath))) continue;
                refValues.add(session.getValueFactory().createValue(referencePath));
                continue;
            }
            String referenceId = this.mapper.getNodeId(reference);
            if (referenceId == null || referenceId.equals("")) continue;
            Node referencedNode = PathUtils.getNodeById(referenceId, session);
            refValues.add(session.getValueFactory().createValue(referencedNode));
        }
        return refValues;
    }

    private void addSingleReferenceToNode(Field field, Object obj, String propertyName, Node node) throws IllegalAccessException, RepositoryException {
        JcrReference jcrReference = this.mapper.getJcrom().getAnnotationReader().getAnnotation(field, JcrReference.class);
        Object referenceObject = field.get(obj);
        if (referenceObject != null) {
            referenceObject = this.mapper.clearCglib(field.get(obj));
        }
        if (referenceObject != null) {
            this.mapSingleReference(jcrReference, referenceObject, node, propertyName);
        } else {
            node.setProperty(propertyName, null);
        }
    }

    private void addMultipleReferencesToNode(Field field, Object obj, String propertyName, Node node) throws IllegalAccessException, RepositoryException {
        JcrReference jcrReference = this.mapper.getJcrom().getAnnotationReader().getAnnotation(field, JcrReference.class);
        List references = (List)field.get(obj);
        if (node.hasProperty(propertyName) && !node.getProperty(propertyName).getDefinition().isMultiple()) {
            node.setProperty(propertyName, null);
            node.getSession().save();
        }
        if (references != null && !references.isEmpty()) {
            List<Value> refValues = this.getReferenceValues(references, node.getSession(), jcrReference);
            if (!refValues.isEmpty()) {
                node.setProperty(propertyName, refValues.toArray(new Value[refValues.size()]));
            } else {
                node.setProperty(propertyName, null);
            }
        } else {
            node.setProperty(propertyName, null);
        }
    }

    private void mapSingleReference(JcrReference jcrReference, Object referenceObject, Node containerNode, String propertyName) throws IllegalAccessException, RepositoryException {
        if (jcrReference.byPath()) {
            String referencePath = this.mapper.getNodePath(referenceObject);
            if (referencePath != null && !referencePath.equals("") && containerNode.getSession().getRootNode().hasNode(PathUtils.relativePath(referencePath))) {
                containerNode.setProperty(propertyName, containerNode.getSession().getValueFactory().createValue(referencePath));
            }
        } else {
            String referenceId = this.mapper.getNodeId(referenceObject);
            if (referenceId != null && !referenceId.equals("")) {
                Node referencedNode = PathUtils.getNodeById(referenceId, containerNode.getSession());
                containerNode.setProperty(propertyName, referencedNode);
            } else {
                containerNode.setProperty(propertyName, null);
            }
        }
    }

    private void addMapOfReferencesToNode(Field field, Object obj, String containerName, Node node) throws IllegalAccessException, RepositoryException {
        JcrReference jcrReference = this.mapper.getJcrom().getAnnotationReader().getAnnotation(field, JcrReference.class);
        if (node.hasNode(containerName)) {
            node.getNode(containerName).remove();
        }
        Node referenceContainer = node.addNode(containerName);
        Map referenceMap = (Map)field.get(obj);
        if (referenceMap != null && !referenceMap.isEmpty()) {
            Class<?> paramClass = ReflectionUtils.getParameterizedClass(field, 1);
            for (Map.Entry entry : referenceMap.entrySet()) {
                String key = (String)entry.getKey();
                if (ReflectionUtils.implementsInterface(paramClass, List.class)) {
                    List references = (List)entry.getValue();
                    List<Value> refValues = this.getReferenceValues(references, referenceContainer.getSession(), jcrReference);
                    if (refValues.isEmpty()) continue;
                    referenceContainer.setProperty(key, refValues.toArray(new Value[refValues.size()]));
                    continue;
                }
                Object referenceObject = entry.getValue();
                this.mapSingleReference(jcrReference, referenceObject, referenceContainer, key);
            }
        }
    }

    private void setReferenceProperties(Field field, Object obj, Node node, NodeFilter nodeFilter) throws IllegalAccessException, RepositoryException {
        String propertyName = this.getPropertyName(field);
        if (nodeFilter == null || nodeFilter.isNameIncluded(field.getName())) {
            if (ReflectionUtils.implementsInterface(field.getType(), List.class)) {
                this.addMultipleReferencesToNode(field, obj, propertyName, node);
            } else if (ReflectionUtils.implementsInterface(field.getType(), Map.class)) {
                this.addMapOfReferencesToNode(field, obj, propertyName, node);
            } else {
                this.addSingleReferenceToNode(field, obj, propertyName, node);
            }
        }
    }

    void addReferences(Field field, Object obj, Node node) throws IllegalAccessException, RepositoryException {
        this.setReferenceProperties(field, obj, node, null);
    }

    void updateReferences(Field field, Object obj, Node node, NodeFilter nodeFilter) throws IllegalAccessException, RepositoryException {
        this.setReferenceProperties(field, obj, node, nodeFilter);
    }

    private Node getSingleReferencedNode(JcrReference jcrReference, Value value, Session session) throws RepositoryException {
        if (jcrReference.byPath()) {
            if (session.getRootNode().hasNode(PathUtils.relativePath(value.getString()))) {
                return PathUtils.getNode(value.getString(), session);
            }
        } else {
            return PathUtils.getNodeById(value.getString(), session);
        }
        return null;
    }

    Object createReferencedObject(Field field, Value value, Object obj, Session session, Class<?> referenceObjClass, int depth, NodeFilter nodeFilter, Mapper mapper) throws ClassNotFoundException, InstantiationException, RepositoryException, IllegalAccessException, IOException {
        JcrReference jcrReference = mapper.getJcrom().getAnnotationReader().getAnnotation(field, JcrReference.class);
        Node referencedNode = null;
        if (jcrReference.byPath()) {
            if (session.getRootNode().hasNode(PathUtils.relativePath(value.getString()))) {
                referencedNode = PathUtils.getNode(value.getString(), session);
            }
        } else {
            referencedNode = PathUtils.getNodeById(value.getString(), session);
        }
        if (referencedNode != null) {
            Object referencedObject = mapper.createInstanceForNode(referenceObjClass, referencedNode);
            if (nodeFilter.isIncluded(field.getName(), depth)) {
                referencedObject = mapper.mapNodeToClass(referencedObject, referencedNode, nodeFilter, null, depth + 1);
            } else if (jcrReference.byPath()) {
                mapper.setNodePath(referencedObject, value.getString());
            } else {
                mapper.setUUID(referencedObject, value.getString());
                mapper.setId(referencedObject, value.getString());
            }
            return referencedObject;
        }
        return null;
    }

    List<?> getReferenceList(Field field, String propertyName, Class<?> referenceObjClass, Node node, Object obj, int depth, NodeFilter nodeFilter, Mapper mapper) throws ClassNotFoundException, InstantiationException, RepositoryException, IllegalAccessException, IOException {
        ArrayList<Object> references = new ArrayList<Object>();
        if (node.hasProperty(propertyName)) {
            Value[] refValues = node.getProperty(propertyName).getDefinition().isMultiple() ? node.getProperty(propertyName).getValues() : new Value[]{node.getProperty(propertyName).getValue()};
            Value[] valueArray = refValues;
            int n = refValues.length;
            int n2 = 0;
            while (n2 < n) {
                Value value = valueArray[n2];
                Object referencedObject = this.createReferencedObject(field, value, obj, node.getSession(), referenceObjClass, depth, nodeFilter, mapper);
                references.add(referencedObject);
                ++n2;
            }
        }
        return references;
    }

    Map<String, Object> getReferenceMap(Field field, String containerName, Class<?> mapParamClass, Node node, Object obj, int depth, NodeFilter nodeFilter, Mapper mapper, JcrReference jcrReference) throws ClassNotFoundException, InstantiationException, RepositoryException, IllegalAccessException, IOException {
        HashMap<String, Object> references = new HashMap<String, Object>();
        if (node.hasNode(containerName)) {
            Node containerNode = node.getNode(containerName);
            PropertyIterator propertyIterator = containerNode.getProperties();
            while (propertyIterator.hasNext()) {
                Property p = propertyIterator.nextProperty();
                if (p.getName().startsWith("jcr:") || p.getName().startsWith("http://www.jcp.org/jcr/1.0")) continue;
                if (ReflectionUtils.implementsInterface(mapParamClass, List.class)) {
                    if (jcrReference.lazy()) {
                        references.put(p.getName(), ProxyFactory.createReferenceListProxy(Object.class, obj, containerNode.getPath(), p.getName(), node.getSession(), mapper, depth, nodeFilter, field));
                        continue;
                    }
                    references.put(p.getName(), this.getReferenceList(field, p.getName(), Object.class, containerNode, obj, depth, nodeFilter, mapper));
                    continue;
                }
                if (jcrReference.lazy()) {
                    Node referencedNode = this.getSingleReferencedNode(jcrReference, p.getValue(), node.getSession());
                    references.put(p.getName(), ProxyFactory.createReferenceProxy(mapper.findClassFromNode(Object.class, referencedNode), obj, containerNode.getPath(), p.getName(), node.getSession(), mapper, depth, nodeFilter, field));
                    continue;
                }
                references.put(p.getName(), this.createReferencedObject(field, p.getValue(), obj, containerNode.getSession(), Object.class, depth, nodeFilter, mapper));
            }
        }
        return references;
    }

    void getReferencesFromNode(Field field, Node node, Object obj, int depth, NodeFilter nodeFilter, Mapper mapper) throws ClassNotFoundException, InstantiationException, RepositoryException, IllegalAccessException, IOException {
        String propertyName = this.getPropertyName(field);
        JcrReference jcrReference = mapper.getJcrom().getAnnotationReader().getAnnotation(field, JcrReference.class);
        if (ReflectionUtils.implementsInterface(field.getType(), List.class)) {
            Class<?> referenceObjClass = ReflectionUtils.getParameterizedClass(field);
            if (jcrReference.lazy()) {
                field.set(obj, ProxyFactory.createReferenceListProxy(referenceObjClass, obj, node.getPath(), propertyName, node.getSession(), mapper, depth, nodeFilter, field));
            } else {
                field.set(obj, this.getReferenceList(field, propertyName, referenceObjClass, node, obj, depth, nodeFilter, mapper));
            }
        } else if (ReflectionUtils.implementsInterface(field.getType(), Map.class)) {
            Class<?> mapParamClass = ReflectionUtils.getParameterizedClass(field, 1);
            field.set(obj, this.getReferenceMap(field, propertyName, mapParamClass, node, obj, depth, nodeFilter, mapper, jcrReference));
        } else if (node.hasProperty(propertyName)) {
            Class<?> referenceObjClass = field.getType();
            if (jcrReference.lazy()) {
                field.set(obj, ProxyFactory.createReferenceProxy(referenceObjClass, obj, node.getPath(), propertyName, node.getSession(), mapper, depth, nodeFilter, field));
            } else {
                field.set(obj, this.createReferencedObject(field, node.getProperty(propertyName).getValue(), obj, node.getSession(), referenceObjClass, depth, nodeFilter, mapper));
            }
        }
    }
}

