/*
 * Decompiled with CFR 0.152.
 */
package org.jcrom;

import javax.jcr.Credentials;
import javax.jcr.Repository;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.Workspace;
import javax.jcr.observation.ObservationManager;
import org.jcrom.EventListenerDefinition;
import org.jcrom.SessionFactory;

public class SessionFactoryImpl
implements SessionFactory {
    private Repository repository;
    private String workspaceName;
    private Credentials credentials;
    private EventListenerDefinition[] eventListeners = new EventListenerDefinition[0];

    public SessionFactoryImpl() {
    }

    public SessionFactoryImpl(Repository repository) {
        this(repository, null, null);
    }

    public SessionFactoryImpl(Repository repository, Credentials credentials) {
        this(repository, credentials, null);
    }

    public SessionFactoryImpl(Repository repository, Credentials credentials, String workspaceName) {
        this.repository = repository;
        this.credentials = credentials;
        this.workspaceName = workspaceName;
    }

    @Override
    public Session getSession() throws RepositoryException {
        Session session = this.repository.login(this.credentials, this.workspaceName);
        return this.addListeners(session);
    }

    private Session addListeners(Session session) throws RepositoryException {
        if (this.getRepository() == null) {
            throw new IllegalArgumentException("repository is required");
        }
        if (this.eventListeners != null && this.eventListeners.length > 0) {
            if (!SessionFactoryImpl.supportsObservation(this.getRepository())) {
                throw new IllegalArgumentException("repository " + this.getRepositoryInfo() + " does NOT support Observation; remove Listener definitions");
            }
            Workspace ws = session.getWorkspace();
            ObservationManager manager = ws.getObservationManager();
            EventListenerDefinition[] eventListenerDefinitionArray = this.eventListeners;
            int n = this.eventListeners.length;
            int n2 = 0;
            while (n2 < n) {
                EventListenerDefinition eventListener = eventListenerDefinitionArray[n2];
                manager.addEventListener(eventListener.getListener(), eventListener.getEventTypes(), eventListener.getAbsPath(), eventListener.isDeep(), eventListener.getUuid(), eventListener.getNodeTypeName(), eventListener.isNoLocal());
                ++n2;
            }
        }
        return session;
    }

    public Repository getRepository() {
        return this.repository;
    }

    public void setRepository(Repository repository) {
        this.repository = repository;
    }

    public String getWorkspaceName() {
        return this.workspaceName;
    }

    public void setWorkspaceName(String workspaceName) {
        this.workspaceName = workspaceName;
    }

    public Credentials getCredentials() {
        return this.credentials;
    }

    public void setCredentials(Credentials credentials) {
        this.credentials = credentials;
    }

    public EventListenerDefinition[] getEventListeners() {
        return this.eventListeners;
    }

    public void setEventListeners(EventListenerDefinition[] eventListenerDefinitions) {
        this.eventListeners = eventListenerDefinitions;
    }

    private String getRepositoryInfo() {
        if (this.getRepository() == null) {
            return "<N/A>";
        }
        StringBuffer buffer = new StringBuffer();
        buffer.append(this.getRepository().getDescriptor("jcr.repository.name"));
        buffer.append(" ");
        buffer.append(this.getRepository().getDescriptor("jcr.repository.version"));
        return buffer.toString();
    }

    private static boolean supportsObservation(Repository repository) {
        return "true".equals(repository.getDescriptor("option.observation.supported"));
    }
}

