/*
 * Decompiled with CFR 0.152.
 */
package org.jcrom.util;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.Calendar;
import org.apache.tika.Tika;
import org.jcrom.JcrDataProvider;
import org.jcrom.JcrDataProviderImpl;
import org.jcrom.JcrFile;
import org.jcrom.JcrMappingException;
import org.jcrom.util.io.FileUtils;
import org.jcrom.util.io.IOUtils;

public final class JcrDataUtils {
    private JcrDataUtils() {
    }

    public static JcrFile fromFile(String name, File file) {
        JcrFile jcrFile = JcrDataUtils.fromFile(name, file, null);
        try {
            jcrFile.setMimeType(new Tika().detect(file));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return jcrFile;
    }

    public static JcrFile fromFile(String name, File file, String mimeType) {
        return JcrDataUtils.fromFile(name, file, mimeType, null);
    }

    public static JcrFile fromFile(String name, File file, String mimeType, String encoding) {
        JcrFile jcrFile = new JcrFile();
        jcrFile.setName(name);
        Calendar cal = Calendar.getInstance();
        cal.setTimeInMillis(file.lastModified());
        jcrFile.setLastModified(cal);
        jcrFile.setMimeType(mimeType);
        jcrFile.setEncoding(encoding);
        jcrFile.setDataProvider(new JcrDataProviderImpl(file));
        return jcrFile;
    }

    public static JcrFile fromInputStream(String name, InputStream input) {
        JcrFile jcrFile = JcrDataUtils.fromInputStream(name, input, null);
        try {
            jcrFile.setMimeType(new Tika().detect(input));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return jcrFile;
    }

    public static JcrFile fromInputStream(String name, InputStream input, String mimeType) {
        return JcrDataUtils.fromInputStream(name, input, mimeType, null);
    }

    public static JcrFile fromInputStream(String name, InputStream input, String mimeType, String encoding) {
        JcrFile jcrFile = new JcrFile();
        jcrFile.setName(name);
        Calendar cal = Calendar.getInstance();
        cal.setTimeInMillis(cal.getTimeInMillis());
        jcrFile.setLastModified(cal);
        jcrFile.setMimeType(mimeType);
        jcrFile.setEncoding(encoding);
        jcrFile.setDataProvider(new JcrDataProviderImpl(input));
        return jcrFile;
    }

    public static JcrFile fromByteArray(String name, byte[] bytes) {
        JcrFile jcrFile = JcrDataUtils.fromByteArray(name, bytes, null);
        jcrFile.setMimeType(new Tika().detect(bytes));
        return jcrFile;
    }

    public static JcrFile fromByteArray(String name, byte[] bytes, String mimeType) {
        return JcrDataUtils.fromByteArray(name, bytes, mimeType, null);
    }

    public static JcrFile fromByteArray(String name, byte[] bytes, String mimeType, String encoding) {
        JcrFile jcrFile = new JcrFile();
        jcrFile.setName(name);
        Calendar cal = Calendar.getInstance();
        cal.setTimeInMillis(cal.getTimeInMillis());
        jcrFile.setLastModified(cal);
        jcrFile.setMimeType(mimeType);
        jcrFile.setEncoding(encoding);
        jcrFile.setDataProvider(new JcrDataProviderImpl(bytes));
        return jcrFile;
    }

    public static String toString(JcrDataProvider dataProvider, String encoding) {
        String data = null;
        switch (dataProvider.getType()) {
            case BYTES: {
                byte[] b = dataProvider.getBytes();
                try {
                    data = new String(b, encoding);
                    break;
                }
                catch (UnsupportedEncodingException e) {
                    throw new JcrMappingException(e.getMessage(), e);
                }
            }
            case FILE: {
                File f = dataProvider.getFile();
                try {
                    data = FileUtils.readFileToString(f, encoding);
                    break;
                }
                catch (IOException e) {
                    throw new JcrMappingException(e.getMessage(), e);
                }
            }
            case STREAM: {
                InputStream input = dataProvider.getInputStream();
                try {
                    data = IOUtils.toString(input, encoding);
                    break;
                }
                catch (IOException e) {
                    throw new JcrMappingException(e.getMessage(), e);
                }
            }
            default: {
                throw new IllegalArgumentException("it should never pass this way !!. The type of content found is '" + (Object)((Object)dataProvider.getType()) + "'");
            }
        }
        return data;
    }

    public static byte[] toByteArray(JcrDataProvider dataProvider) {
        byte[] data = null;
        switch (dataProvider.getType()) {
            case BYTES: {
                data = dataProvider.getBytes();
                break;
            }
            case FILE: {
                File f = dataProvider.getFile();
                try {
                    data = FileUtils.readFileToByteArray(f);
                    break;
                }
                catch (IOException e) {
                    throw new JcrMappingException(e.getMessage(), e);
                }
            }
            case STREAM: {
                InputStream input = dataProvider.getInputStream();
                try {
                    data = IOUtils.toByteArray(input);
                    break;
                }
                catch (IOException e) {
                    throw new JcrMappingException(e.getMessage(), e);
                }
            }
            default: {
                throw new IllegalArgumentException("it should never pass this way !!. The type of content found is '" + (Object)((Object)dataProvider.getType()) + "'");
            }
        }
        return data;
    }

    public static InputStream toStream(JcrDataProvider dataProvider) {
        InputStream data = null;
        switch (dataProvider.getType()) {
            case BYTES: {
                byte[] b = dataProvider.getBytes();
                data = new ByteArrayInputStream(b);
                break;
            }
            case FILE: {
                File f = dataProvider.getFile();
                try {
                    data = FileUtils.openInputStream(f);
                    break;
                }
                catch (IOException e) {
                    throw new JcrMappingException(e.getMessage(), e);
                }
            }
            case STREAM: {
                data = dataProvider.getInputStream();
                break;
            }
            default: {
                throw new IllegalArgumentException("it should never pass this way !!. The type of content found is '" + (Object)((Object)dataProvider.getType()) + "'");
            }
        }
        return data;
    }
}

