/*
 * Decompiled with CFR 0.152.
 */
package org.jcrom.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.net.URL;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import org.jcrom.annotations.JcrNode;

public class ReflectionUtils {
    public static Field[] getDeclaredAndInheritedFields(Class<?> type, boolean returnFinalFields) {
        ArrayList<Field> allFields = new ArrayList<Field>();
        allFields.addAll(ReflectionUtils.getValidFields(type.getDeclaredFields(), returnFinalFields));
        Class<?> parent = type.getSuperclass();
        while (parent != null && parent != Object.class) {
            allFields.addAll(ReflectionUtils.getValidFields(parent.getDeclaredFields(), returnFinalFields));
            parent = parent.getSuperclass();
        }
        return allFields.toArray(new Field[allFields.size()]);
    }

    public static List<Field> getValidFields(Field[] fields, boolean returnFinalFields) {
        ArrayList<Field> validFields = new ArrayList<Field>();
        Field[] fieldArray = fields;
        int n = fields.length;
        int n2 = 0;
        while (n2 < n) {
            Field field = fieldArray[n2];
            if (!(Modifier.isStatic(field.getModifiers()) || !returnFinalFields && Modifier.isFinal(field.getModifiers()))) {
                validFields.add(field);
            }
            ++n2;
        }
        return validFields;
    }

    public static boolean implementsInterface(Class<?> type, Class<?> interfaceClass) {
        if (type.isInterface()) {
            return type == interfaceClass;
        }
        Class<?>[] classArray = type.getInterfaces();
        int n = classArray.length;
        int n2 = 0;
        while (n2 < n) {
            Class<?> ifc = classArray[n2];
            if (ifc == interfaceClass) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public static boolean extendsClass(Class<?> type, Class<?> superClass) {
        if (type == superClass) {
            return true;
        }
        Class<?> c = type.getSuperclass();
        while (c != null && c != Object.class) {
            if (c == superClass) {
                return true;
            }
            c = c.getSuperclass();
        }
        return false;
    }

    public static boolean isPropertyType(Class<?> type) {
        return ReflectionUtils.isValidMapValueType(type) || type == InputStream.class || ReflectionUtils.isArrayOfType(type, Byte.TYPE);
    }

    public static boolean isValidMapValueType(Class<?> type) {
        return type == String.class || ReflectionUtils.isArrayOfType(type, String.class) || type == Date.class || ReflectionUtils.isArrayOfType(type, Date.class) || type == Calendar.class || ReflectionUtils.isArrayOfType(type, Calendar.class) || type == Timestamp.class || ReflectionUtils.isArrayOfType(type, Timestamp.class) || type == Integer.class || ReflectionUtils.isArrayOfType(type, Integer.class) || type == Integer.TYPE || ReflectionUtils.isArrayOfType(type, Integer.TYPE) || type == Long.class || ReflectionUtils.isArrayOfType(type, Long.class) || type == Long.TYPE || ReflectionUtils.isArrayOfType(type, Long.TYPE) || type == Double.class || ReflectionUtils.isArrayOfType(type, Double.class) || type == Double.TYPE || ReflectionUtils.isArrayOfType(type, Double.TYPE) || type == Boolean.class || ReflectionUtils.isArrayOfType(type, Boolean.class) || type == Boolean.TYPE || ReflectionUtils.isArrayOfType(type, Boolean.TYPE) || type == Locale.class || ReflectionUtils.isArrayOfType(type, Locale.class) || type.isEnum() || type.isArray() && type.getComponentType().isEnum();
    }

    private static boolean isArrayOfType(Class<?> c, Class<?> type) {
        return c.isArray() && c.getComponentType() == type;
    }

    public static boolean isDateType(Class<?> type) {
        return type == Date.class || type == Calendar.class || type == Timestamp.class;
    }

    public static Class<?> getParameterizedClass(Field field) {
        return ReflectionUtils.getParameterizedClass(field, 0);
    }

    public static Class<?> getParameterizedClass(Field field, int index) {
        if (field.getGenericType() instanceof ParameterizedType) {
            ParameterizedType ptype = (ParameterizedType)field.getGenericType();
            Type paramType = ptype.getActualTypeArguments()[index];
            if (paramType instanceof GenericArrayType) {
                Class arrayType = (Class)((GenericArrayType)paramType).getGenericComponentType();
                return Array.newInstance(arrayType, 0).getClass();
            }
            if (paramType instanceof ParameterizedType) {
                ParameterizedType paramPType = (ParameterizedType)paramType;
                return (Class)paramPType.getRawType();
            }
            return (Class)paramType;
        }
        return null;
    }

    public static Class<?> getTypeArgumentOfParameterizedClass(Field field, int index, int typeIndex) {
        ParameterizedType paramPType;
        Type paramParamType;
        ParameterizedType ptype;
        Type paramType;
        if (field.getGenericType() instanceof ParameterizedType && !((paramType = (ptype = (ParameterizedType)field.getGenericType()).getActualTypeArguments()[index]) instanceof GenericArrayType) && paramType instanceof ParameterizedType && !((paramParamType = (paramPType = (ParameterizedType)paramType).getActualTypeArguments()[typeIndex]) instanceof ParameterizedType)) {
            return (Class)paramParamType;
        }
        return null;
    }

    public static Class<?> getParameterizedClass(Class<?> c) {
        return ReflectionUtils.getParameterizedClass(c, 0);
    }

    public static Class<?> getParameterizedClass(Class<?> c, int index) {
        TypeVariable<Class<?>>[] typeVars = c.getTypeParameters();
        if (typeVars.length > 0) {
            return (Class)typeVars[index].getBounds()[0];
        }
        return null;
    }

    public static boolean isFieldParameterizedWithClass(Field field, Class<?> c) {
        if (field.getGenericType() instanceof ParameterizedType) {
            ParameterizedType ptype = (ParameterizedType)field.getGenericType();
            Type[] typeArray = ptype.getActualTypeArguments();
            int n = typeArray.length;
            int n2 = 0;
            while (n2 < n) {
                Type type = typeArray[n2];
                if (type == c) {
                    return true;
                }
                if (c.isInterface() && ReflectionUtils.implementsInterface((Class)type, c)) {
                    return true;
                }
                ++n2;
            }
        }
        return false;
    }

    public static boolean isFieldParameterizedWithPropertyType(Field field) {
        if (field.getGenericType() instanceof ParameterizedType) {
            ParameterizedType ptype = (ParameterizedType)field.getGenericType();
            Type[] typeArray = ptype.getActualTypeArguments();
            int n = typeArray.length;
            int n2 = 0;
            while (n2 < n) {
                Type type = typeArray[n2];
                if (ReflectionUtils.isPropertyType((Class)type)) {
                    return true;
                }
                ++n2;
            }
        }
        return false;
    }

    public static JcrNode getJcrNodeAnnotation(Class<?> c) {
        Class<?> interfaceClass;
        int n;
        int n2;
        Class<?>[] classArray;
        if (c.isAnnotationPresent(JcrNode.class)) {
            return c.getAnnotation(JcrNode.class);
        }
        Class<?> parent = c.getSuperclass();
        while (parent != null && parent != Object.class) {
            if (parent.isAnnotationPresent(JcrNode.class)) {
                return parent.getAnnotation(JcrNode.class);
            }
            classArray = parent.getInterfaces();
            n2 = classArray.length;
            n = 0;
            while (n < n2) {
                interfaceClass = classArray[n];
                if (interfaceClass.isAnnotationPresent(JcrNode.class)) {
                    return interfaceClass.getAnnotation(JcrNode.class);
                }
                ++n;
            }
            parent = parent.getSuperclass();
        }
        classArray = c.getInterfaces();
        n2 = classArray.length;
        n = 0;
        while (n < n2) {
            interfaceClass = classArray[n];
            if (interfaceClass.isAnnotationPresent(JcrNode.class)) {
                return interfaceClass.getAnnotation(JcrNode.class);
            }
            ++n;
        }
        return null;
    }

    private static String stripFilenameExtension(String filename) {
        if (filename.indexOf(46) != -1) {
            return filename.substring(0, filename.lastIndexOf(46));
        }
        return filename;
    }

    public static Set<Class<?>> getFromDirectory(File directory, String packageName) throws ClassNotFoundException {
        HashSet classes = new HashSet();
        if (directory.exists()) {
            String[] stringArray = directory.list();
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String file = stringArray[n2];
                if (file.endsWith(".class")) {
                    String name = String.valueOf(packageName) + '.' + ReflectionUtils.stripFilenameExtension(file);
                    Class<?> clazz = Class.forName(name);
                    classes.add(clazz);
                }
                ++n2;
            }
        }
        return classes;
    }

    public static Set<Class<?>> getFromJARFile(String jar, String packageName) throws IOException, FileNotFoundException, ClassNotFoundException {
        JarEntry jarEntry;
        HashSet classes = new HashSet();
        JarInputStream jarFile = new JarInputStream(new FileInputStream(jar));
        do {
            String className;
            if ((jarEntry = jarFile.getNextJarEntry()) == null || !(className = jarEntry.getName()).endsWith(".class") || !(className = ReflectionUtils.stripFilenameExtension(className)).startsWith(packageName)) continue;
            classes.add(Class.forName(className.replace('/', '.')));
        } while (jarEntry != null);
        return classes;
    }

    public static Set<Class<?>> getClasses(String packageName) throws IOException, ClassNotFoundException {
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        return ReflectionUtils.getClasses(loader, packageName);
    }

    public static Set<Class<?>> getClasses(ClassLoader loader, String packageName) throws IOException, ClassNotFoundException {
        HashSet classes = new HashSet();
        String path = packageName.replace('.', '/');
        Enumeration<URL> resources = loader.getResources(path);
        if (resources != null) {
            while (resources.hasMoreElements()) {
                String filePath = resources.nextElement().getFile();
                if (filePath.indexOf("%20") > 0) {
                    filePath = filePath.replaceAll("%20", " ");
                }
                if (filePath == null) continue;
                if (filePath.indexOf("!") > 0 & filePath.indexOf(".jar") > 0) {
                    String jarPath = filePath.substring(0, filePath.indexOf("!")).substring(filePath.indexOf(":") + 1);
                    if (jarPath.indexOf(":") >= 0) {
                        jarPath = jarPath.substring(1);
                    }
                    classes.addAll(ReflectionUtils.getFromJARFile(jarPath, path));
                    continue;
                }
                classes.addAll(ReflectionUtils.getFromDirectory(new File(filePath), packageName));
            }
        }
        return classes;
    }
}

