/*
 * Decompiled with CFR 0.152.
 */
package org.jcrom.util.io;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import org.jcrom.util.io.IOUtils;

public class FileUtils {
    public static FileInputStream openInputStream(File file) throws IOException {
        if (file.exists()) {
            if (file.isDirectory()) {
                throw new IOException("File '" + file + "' exists but is a directory");
            }
            if (!file.canRead()) {
                throw new IOException("File '" + file + "' cannot be read");
            }
        } else {
            throw new FileNotFoundException("File '" + file + "' does not exist");
        }
        return new FileInputStream(file);
    }

    public static String readFileToString(File file, String encoding) throws IOException {
        FileInputStream in = null;
        try {
            in = FileUtils.openInputStream(file);
            String string = IOUtils.toString(in, encoding);
            return string;
        }
        finally {
            IOUtils.closeQuietly(in);
        }
    }

    public static byte[] readFileToByteArray(File file) throws IOException {
        FileInputStream in = null;
        try {
            in = FileUtils.openInputStream(file);
            byte[] byArray = IOUtils.toByteArray((InputStream)in, file.length());
            return byArray;
        }
        finally {
            IOUtils.closeQuietly(in);
        }
    }
}

