/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.tool;

import com.axelor.apps.tool.ThrowConsumer;
import com.axelor.db.EntityHelper;
import com.axelor.db.JPA;
import com.axelor.db.JpaRepository;
import com.axelor.db.Model;
import com.axelor.db.mapper.Mapper;
import com.axelor.exception.AxelorException;
import com.axelor.exception.service.TraceBackService;
import com.axelor.i18n.I18n;
import com.google.common.base.Preconditions;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.persistence.Column;

public final class ModelTool {
    private ModelTool() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T extends Model> int apply(Class<? extends Model> modelClass, Collection<? extends Number> ids, ThrowConsumer<T> consumer) {
        Preconditions.checkNotNull(ids, (Object)I18n.get((String)"The collection of IDs cannot be null."));
        Preconditions.checkNotNull(consumer, (Object)I18n.get((String)"The consumer cannot be null."));
        int errorCount = 0;
        for (Number number : ids) {
            block6: {
                Model model;
                if (number == null || (model = JPA.find(modelClass, (Long)number.longValue())) == null) break block6;
                consumer.accept(model);
                JPA.clear();
                continue;
            }
            try {
                try {
                    throw new AxelorException(modelClass, 3, I18n.get((String)"Cannot find record #%s"), new Object[]{String.valueOf(number)});
                }
                catch (Exception e) {
                    ++errorCount;
                    TraceBackService.trace((Throwable)e);
                    JPA.clear();
                }
            }
            catch (Throwable throwable) {
                JPA.clear();
                throw throwable;
            }
        }
        return errorCount;
    }

    public static Map<String, String> getUniqueErrors(Model model, Map<String, String> messages) {
        HashMap<String, String> errors = new HashMap<String, String>();
        Set<Field> fields = ModelTool.checkUniqueFields(model);
        for (Field field : fields) {
            String message = messages.getOrDefault(field.getName(), "This field needs to be unique.");
            errors.put(field.getName(), message);
        }
        return errors;
    }

    public static Map<String, String> getUniqueErrors(Model model) {
        return ModelTool.getUniqueErrors(model, Collections.emptyMap());
    }

    private static Set<Field> checkUniqueFields(Model model) {
        HashSet<Field> errors = new HashSet<Field>();
        Class modelClass = EntityHelper.getEntityClass((Object)model);
        for (Field field : modelClass.getDeclaredFields()) {
            Column column = field.getAnnotation(Column.class);
            if (column == null || !column.unique()) continue;
            String filter = String.format("self.%s = :value", field.getName());
            String getterName = ModelTool.fieldNameToGetter(field.getName());
            try {
                Method getter = modelClass.getMethod(getterName, new Class[0]);
                Object value = getter.invoke((Object)model, new Object[0]);
                Model existing = JPA.all((Class)modelClass).filter(filter).bind("value", value).fetchOne();
                if (existing == null || existing.getId().equals(model.getId())) continue;
                errors.add(field);
            }
            catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
                TraceBackService.trace((Throwable)e);
            }
        }
        return errors;
    }

    private static String fieldNameToGetter(String name) {
        return "get" + ModelTool.capitalize(name);
    }

    private static String capitalize(String string) {
        return string.substring(0, 1).toUpperCase() + string.substring(1);
    }

    public static <T> T toBean(Class<T> klass, Object mapObject) {
        Map map = (Map)mapObject;
        return (T)Mapper.toBean(klass, (Map)map);
    }

    public static <T extends Model> List<T> copy(JpaRepository<T> repo, List<T> src, boolean deep) {
        ArrayList<Model> dest = new ArrayList<Model>();
        for (Model obj : src) {
            Model cpy = repo.copy(obj, deep);
            dest.add(cpy);
        }
        return dest;
    }
}

