/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.tool;

import com.jcraft.jsch.ChannelSftp;
import com.jcraft.jsch.JSch;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Session;
import com.jcraft.jsch.SftpException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;

public class SFTPUtils {
    private SFTPUtils() {
    }

    public static Session createSession(String host, int port, String username, String password, String privateKey, String passphrase) throws JSchException {
        JSch jsch = new JSch();
        if (privateKey != null) {
            jsch.addIdentity(privateKey, passphrase);
        }
        Session session = jsch.getSession(username, host, port);
        session.setPassword(password);
        session.setConfig("StrictHostKeyChecking", "no");
        return session;
    }

    public static Session createSession(String host, int port, String username, String password) throws JSchException {
        return SFTPUtils.createSession(host, port, username, password, null, null);
    }

    public static boolean isValid(Session session) throws JSchException {
        session.connect();
        boolean valid = session.isConnected();
        session.disconnect();
        return valid;
    }

    public static ChannelSftp openSftpChannel(Session session) throws JSchException {
        return (ChannelSftp)session.openChannel("sftp");
    }

    public static List<ChannelSftp.LsEntry> getFiles(ChannelSftp channel, String dir) throws SftpException {
        ArrayList<ChannelSftp.LsEntry> files = new ArrayList<ChannelSftp.LsEntry>(channel.ls(dir));
        files.sort(Comparator.comparing(file -> file.getAttrs().getMTime()).thenComparing(ChannelSftp.LsEntry::getFilename));
        return files;
    }

    public static InputStream get(ChannelSftp channel, String absoluteFilePath) throws SftpException {
        return channel.get(absoluteFilePath);
    }

    public static void put(ChannelSftp channel, InputStream file, String absoluteFilePath) throws SftpException {
        channel.put(file, absoluteFilePath);
    }

    public static void move(ChannelSftp channel, String src, String dst) throws SftpException {
        channel.rename(src, dst);
    }

    public static boolean isFile(ChannelSftp.LsEntry file) {
        return !file.getAttrs().isDir() && !file.getAttrs().isLink();
    }
}

