/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.tool;

import com.axelor.db.Model;
import java.text.Normalizer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

public final class StringTool {
    private static final String[] FILENAME_SEARCH_LIST = new String[]{"*", "\"", "/", "\\", "?", "%", ":", "|", "<", ">"};
    private static final String[] FILENAME_REPLACEMENT_LIST = new String[]{"#", "'", "_", "_", "_", "_", "_", "_", "_", "_"};

    private StringTool() {
    }

    public static String toFirstLower(String string) {
        return string.replaceFirst("\\w", Character.toString(string.toLowerCase().charAt(0)));
    }

    public static String toFirstUpper(String string) {
        return string.replaceFirst("\\w", Character.toString(string.toUpperCase().charAt(0)));
    }

    public static String fillStringRight(String s, char fillChar, int size) {
        String string = s;
        string = string.length() < size ? string + StringTool.fillString(fillChar, size - string.length()) : StringTool.truncRight(string, size);
        return string;
    }

    public static String fillStringLeft(String s, char fillChar, int size) {
        String string = s;
        string = string.length() < size ? StringTool.fillString(fillChar, size - string.length()) + string : StringTool.truncLeft(string, size);
        return string;
    }

    public static String truncRight(String s, int size) {
        String string = s;
        if (string.length() > size) {
            string = string.substring(0, size);
        }
        return string;
    }

    public static String truncLeft(String s, int size) {
        String string = s;
        if (string.length() > size) {
            string = string.substring(string.length() - size, string.length());
        }
        return string;
    }

    public static String fillString(char fillChar, int count) {
        char[] chars = new char[count];
        Arrays.fill(chars, fillChar);
        return new String(chars);
    }

    public static String deleteAccent(String s) {
        String temp = Normalizer.normalize(s, Normalizer.Form.NFD);
        return temp.replaceAll("[^\\p{ASCII}]", "");
    }

    public static boolean equalsIgnoreCaseAndAccents(String s1, String s2) {
        return StringTool.deleteAccent(s1).equalsIgnoreCase(StringTool.deleteAccent(s2));
    }

    public static boolean isDigital(String s) {
        char[] cArray = s.toCharArray();
        int n = cArray.length;
        for (int i = 0; i < n; ++i) {
            Character c = Character.valueOf(cArray[i]);
            if (Character.isDigit(c.charValue())) continue;
            return false;
        }
        return true;
    }

    public static String extractStringFromRight(String string, int startIndex, int lenght) {
        String extractString = "";
        try {
            if (string != null && startIndex >= 0 && lenght >= 0 && string.length() - startIndex + lenght <= string.length()) {
                extractString = string.substring(string.length() - startIndex, string.length() - startIndex + lenght);
            }
        }
        catch (Exception ex) {
            return "";
        }
        return extractString;
    }

    public static String getHexString(byte[] bytes) {
        StringBuilder sb = new StringBuilder(bytes.length * 2);
        String s = "";
        for (byte b : bytes) {
            s = String.format("%x", b);
            if (s.length() == 1) {
                sb.append('0');
            }
            sb.append(s);
        }
        return sb.toString();
    }

    public static String capitalizeFirstLetter(String s) {
        if (s == null) {
            return null;
        }
        if (s.length() == 0) {
            return s;
        }
        StringBuilder result = new StringBuilder(s);
        result.replace(0, 1, result.substring(0, 1).toUpperCase());
        return result.toString();
    }

    public static List<Integer> getIntegerList(String string) {
        return string != null && !"".equals(string) ? Arrays.stream(string.split("\\D+")).map(Integer::valueOf).collect(Collectors.toList()) : new ArrayList<Integer>();
    }

    public static String getIdListString(Collection<? extends Model> collection) {
        String idString;
        ArrayList<Long> idList = new ArrayList<Long>();
        if (CollectionUtils.isEmpty(collection)) {
            idString = "0";
        } else {
            for (Model model : collection) {
                if (model == null) continue;
                idList.add(model.getId());
            }
            idString = idList.stream().map(l -> l.toString()).collect(Collectors.joining(","));
        }
        return idString;
    }

    public static String getFilename(String name) {
        return StringUtils.replaceEach((String)name, (String[])FILENAME_SEARCH_LIST, (String[])FILENAME_REPLACEMENT_LIST);
    }

    public static String cutTooLongString(String str) {
        int defaultDbStrLength = 255;
        String fillString = "...";
        if (str.length() > defaultDbStrLength) {
            return str.substring(0, defaultDbStrLength - fillString.length()) + fillString;
        }
        return str;
    }
}

