/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.tool.date;

import com.axelor.common.StringUtils;
import java.lang.invoke.MethodHandles;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.temporal.ChronoUnit;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DateTool {
    private static final Logger LOG = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());

    private DateTool() {
        throw new IllegalStateException("Utility class");
    }

    public static long daysBetween(LocalDate date1, LocalDate date2, boolean days360) {
        long days = 0L;
        days = days360 ? (date1.isBefore(date2) ? (long)DateTool.days360Between(date1, date2) : (long)(-DateTool.days360Between(date2, date1))) : DateTool.daysBetween(date1, date2);
        LOG.debug("Number of days between {} - {} (month of 30 days ? {}) : {}", new Object[]{date1, date2, days360, days});
        return days;
    }

    private static long daysBetween(LocalDate date1, LocalDate date2) {
        if (date2.isBefore(date1)) {
            return ChronoUnit.DAYS.between(date1, date2) - 1L;
        }
        return ChronoUnit.DAYS.between(date1, date2) + 1L;
    }

    private static int days360Between(LocalDate startDate, LocalDate endDate) {
        int nbDayOfFirstMonth = 0;
        int nbDayOfOthersMonths = 0;
        int nbDayOfLastMonth = 0;
        LocalDate start = startDate;
        if (endDate.getMonthValue() != startDate.getMonthValue() || endDate.getYear() != startDate.getYear()) {
            if (!startDate.isEqual(startDate.withDayOfMonth(startDate.lengthOfMonth()))) {
                nbDayOfFirstMonth = 30 - startDate.getDayOfMonth();
            }
            ++nbDayOfFirstMonth;
            LocalDate date1 = startDate.plusMonths(1L).withDayOfMonth(1);
            while (endDate.getMonthValue() != date1.getMonthValue() || endDate.getYear() != date1.getYear()) {
                nbDayOfOthersMonths += 30;
                date1 = date1.plusMonths(1L);
            }
            start = endDate.withDayOfMonth(1);
        }
        nbDayOfLastMonth = endDate.isEqual(endDate.withDayOfMonth(endDate.lengthOfMonth())) ? 30 - start.getDayOfMonth() : endDate.getDayOfMonth() - start.getDayOfMonth();
        return nbDayOfFirstMonth + nbDayOfOthersMonths + ++nbDayOfLastMonth;
    }

    public static int days360MonthsBetween(LocalDate startDate, LocalDate endDate) {
        if (startDate.isBefore(endDate)) {
            return DateTool.days360Between(startDate, endDate) / 30;
        }
        return -DateTool.days360Between(endDate, startDate) / 30;
    }

    public static boolean isProrata(LocalDate dateFrame1, LocalDate dateFrame2, LocalDate date1, LocalDate date2) {
        if (date2 == null && (date1.isBefore(dateFrame2) || date1.isEqual(dateFrame2))) {
            return true;
        }
        if (date2 == null) {
            return false;
        }
        return (date1.isAfter(dateFrame1) || date1.isEqual(dateFrame1)) && (date1.isBefore(dateFrame2) || date1.isEqual(dateFrame2)) || (date2.isAfter(dateFrame1) || date2.isEqual(dateFrame1)) && (date2.isBefore(dateFrame2) || date2.isEqual(dateFrame2)) || date1.isBefore(dateFrame1) && date2.isAfter(dateFrame2);
    }

    public static boolean isBetween(LocalDate dateFrame1, LocalDate dateFrame2, LocalDate date) {
        return dateFrame2 == null && (date.isAfter(dateFrame1) || date.isEqual(dateFrame1)) || dateFrame2 != null && (date.isAfter(dateFrame1) || date.isEqual(dateFrame1)) && (date.isBefore(dateFrame2) || date.isEqual(dateFrame2));
    }

    public static LocalDate nextOccurency(LocalDate startDate, LocalDate goalDate, int frequencyInMonth) {
        if (!DateTool.checkValidInputs(startDate, goalDate, frequencyInMonth)) {
            return null;
        }
        if (startDate.isAfter(goalDate)) {
            return goalDate;
        }
        return DateTool.minusMonths(goalDate, DateTool.days360MonthsBetween(startDate.plusDays(1L), goalDate.minusDays(1L)) / frequencyInMonth * frequencyInMonth);
    }

    public LocalDate nextOccurencyStartDateIncluded(LocalDate startDate, LocalDate goalDate, int frequencyInMonth) {
        if (!DateTool.checkValidInputs(startDate, goalDate, frequencyInMonth)) {
            return null;
        }
        if (startDate.isAfter(goalDate)) {
            return goalDate;
        }
        return DateTool.minusMonths(goalDate, DateTool.days360MonthsBetween(startDate, goalDate.minusDays(1L)) / frequencyInMonth * frequencyInMonth);
    }

    public static LocalDate lastOccurency(LocalDate startDate, LocalDate endDate, int frequencyInMonth) {
        if (!DateTool.checkValidInputs(startDate, endDate, frequencyInMonth)) {
            return null;
        }
        if (startDate.isAfter(endDate)) {
            return null;
        }
        return DateTool.plusMonths(startDate, DateTool.days360MonthsBetween(startDate, endDate) / frequencyInMonth * frequencyInMonth);
    }

    private static boolean checkValidInputs(LocalDate startDate, LocalDate endDate, int frequencyInMonth) {
        if (frequencyInMonth == 0) {
            LOG.debug("The frequency should not be zero.");
            return false;
        }
        if (startDate == null) {
            LOG.debug("The start date should not be null.");
            return false;
        }
        if (endDate == null) {
            LOG.debug("The end date should not be null.");
            return false;
        }
        return true;
    }

    public static LocalDate minusMonths(LocalDate date, int nbMonths) {
        return date.plusDays(1L).minusMonths(nbMonths).minusDays(1L);
    }

    public static LocalDate plusMonths(LocalDate date, int nbMonths) {
        return date.plusDays(1L).plusMonths(nbMonths).minusDays(1L);
    }

    public static LocalDateTime plusSeconds(LocalDateTime datetime, long duration) {
        return datetime.plusSeconds(duration);
    }

    public static LocalDateTime minusSeconds(LocalDateTime datetime, long duration) {
        return datetime.minusSeconds(duration);
    }

    public static boolean dateInPeriod(LocalDate date, int dayBegin, int monthBegin, int dayEnd, int monthEnd) {
        if (monthBegin > monthEnd) {
            return date.getMonthValue() == monthBegin && date.getDayOfMonth() >= dayBegin || date.getMonthValue() > monthBegin || date.getMonthValue() < monthEnd || date.getMonthValue() == monthEnd && date.getDayOfMonth() <= dayEnd;
        }
        if (monthBegin == monthEnd) {
            return date.getMonthValue() == monthBegin && date.getDayOfMonth() >= dayBegin && date.getDayOfMonth() <= dayEnd;
        }
        return date.getMonthValue() == monthBegin && date.getDayOfMonth() >= dayBegin || date.getMonthValue() > monthBegin && date.getMonthValue() < monthEnd || date.getMonthValue() == monthEnd && date.getDayOfMonth() <= dayEnd;
    }

    public static LocalDate toLocalDate(Date date) {
        Instant instant = date.toInstant();
        return instant.atZone(ZoneId.systemDefault()).toLocalDate();
    }

    public static LocalDateTime toLocalDateT(Date date) {
        Instant instant = date.toInstant();
        return instant.atZone(ZoneId.systemDefault()).toLocalDateTime();
    }

    public static Date toDate(LocalDate date) {
        return Date.from(date.atStartOfDay(ZoneId.systemDefault()).toInstant());
    }

    public static ZonedDateTime getTodayDateTime(String timeZone) {
        return StringUtils.notBlank((CharSequence)timeZone) ? ZonedDateTime.now(ZoneId.of(timeZone)) : ZonedDateTime.now();
    }

    public static LocalDate getTodayDate(String timeZone) {
        return DateTool.getTodayDateTime(timeZone).toLocalDate();
    }
}

