/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.tool.file;

import com.axelor.i18n.I18n;
import com.axelor.meta.MetaFiles;
import com.google.common.base.Preconditions;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.lang.invoke.MethodHandles;
import java.net.URLEncoder;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Collections;
import java.util.List;
import org.apache.pdfbox.multipdf.PDFMergerUtility;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class PdfTool {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());

    private PdfTool() {
    }

    public static String mergePdfToFileLink(List<File> fileList, String fileName) throws IOException {
        return PdfTool.getFileLinkFromPdfFile(PdfTool.mergePdf(fileList), fileName);
    }

    public static File mergePdf(List<File> fileList) throws IOException {
        PDFMergerUtility pdfMergerUtility = new PDFMergerUtility();
        for (File file : fileList) {
            pdfMergerUtility.addSource(file);
        }
        Path tmpFile = MetaFiles.createTempFile(null, (String)"", (FileAttribute[])new FileAttribute[0]);
        FileOutputStream stream = new FileOutputStream(tmpFile.toFile());
        pdfMergerUtility.setDestinationStream((OutputStream)stream);
        pdfMergerUtility.mergeDocuments(null);
        return tmpFile.toFile();
    }

    public static String getFileLinkFromPdfFile(File file, String fileName) {
        String fileLink = "ws/files/report/" + file.getName();
        try {
            fileLink = fileLink + "?name=" + URLEncoder.encode(fileName, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            logger.error(e.getLocalizedMessage());
        }
        return fileLink;
    }

    public static File printCopiesToFile(File file, int copyNumber) throws IOException {
        Preconditions.checkArgument((copyNumber > 0 ? 1 : 0) != 0, (Object)I18n.get((String)"The parameter copyNumber should be superior to 0."));
        List<File> invoicePrintingToMerge = Collections.nCopies(copyNumber, file);
        return PdfTool.mergePdf(invoicePrintingToMerge);
    }
}

