/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.tool.service;

import com.axelor.apps.tool.service.TranslationService;
import com.axelor.common.StringUtils;
import com.axelor.db.Model;
import com.axelor.meta.db.MetaTranslation;
import com.axelor.meta.db.repo.MetaTranslationRepository;
import com.google.inject.Inject;
import com.google.inject.persist.Transactional;
import java.util.Collection;
import java.util.HashSet;

public class TranslationServiceImpl
implements TranslationService {
    protected MetaTranslationRepository metaTranslationRepo;
    protected static final String VALUE_KEY_PREFIX = "value:";

    @Inject
    TranslationServiceImpl(MetaTranslationRepository metaTranslationRepo) {
        this.metaTranslationRepo = metaTranslationRepo;
    }

    @Override
    @Transactional
    public void updateFormatedValueTranslations(String oldKey, String format, Object ... args) {
        this.removeValueTranslations(oldKey);
        this.createFormatedValueTranslations(format, args);
    }

    @Override
    @Transactional
    public void createFormatedValueTranslations(String format, Object ... args) {
        String key = VALUE_KEY_PREFIX + String.format(format, args);
        for (String language : this.getLanguages(args)) {
            MetaTranslation metaTranslation = this.metaTranslationRepo.findByKey(key, language);
            if (metaTranslation == null) {
                metaTranslation = new MetaTranslation();
                metaTranslation.setKey(key);
                metaTranslation.setLanguage(language);
            }
            String message = String.format(format, this.getTranslatedValueArgs(args, language));
            metaTranslation.setMessage(message);
            this.metaTranslationRepo.save((Model)metaTranslation);
        }
    }

    @Override
    @Transactional
    public void removeValueTranslations(String key) {
        if (StringUtils.isBlank((CharSequence)key)) {
            return;
        }
        for (MetaTranslation metaTranslation : this.metaTranslationRepo.all().filter("self.key = :key").bind("key", (Object)(VALUE_KEY_PREFIX + key)).fetch()) {
            this.metaTranslationRepo.remove((Model)metaTranslation);
        }
    }

    private Object[] getTranslatedValueArgs(Object[] args, String language) {
        Object[] translatedArgs = new String[args.length];
        for (int i = 0; i < args.length; ++i) {
            String key = String.valueOf(args[i]);
            translatedArgs[i] = this.getValueTranslation(key, language);
        }
        return translatedArgs;
    }

    @Override
    public String getTranslation(String key, String language) {
        MetaTranslation metaTranslation = this.metaTranslationRepo.findByKey(key, language);
        return metaTranslation != null && !StringUtils.isBlank((CharSequence)metaTranslation.getMessage()) ? metaTranslation.getMessage() : key;
    }

    @Override
    public String getTranslationKey(String message, String language) {
        MetaTranslation metaTranslation = (MetaTranslation)this.metaTranslationRepo.all().filter("self.message = ?1 AND self.language = ?2", new Object[]{message, language}).fetchOne();
        return metaTranslation != null && !StringUtils.isBlank((CharSequence)metaTranslation.getKey()) ? metaTranslation.getKey() : message;
    }

    @Override
    public String getValueTranslation(String key, String language) {
        String translation;
        String valueKey = VALUE_KEY_PREFIX + key;
        return !valueKey.equals(translation = this.getTranslation(valueKey, language)) ? translation : key;
    }

    private Collection<String> getLanguages(Object ... args) {
        HashSet<String> languages = new HashSet<String>();
        for (Object arg : args) {
            for (MetaTranslation metaTranslation : this.metaTranslationRepo.all().filter("self.key = :key").bind("key", (Object)(VALUE_KEY_PREFIX + arg)).fetch()) {
                languages.add(metaTranslation.getLanguage());
            }
        }
        return languages;
    }
}

