/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.tool.xml;

import java.lang.invoke.MethodHandles;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.NodeList;

public class XPathParse {
    private static final Logger LOG = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private Document doc;

    protected Document getDoc() {
        return this.doc;
    }

    protected void setDoc(Document doc) {
        this.doc = doc;
    }

    public XPathParse() {
    }

    public XPathParse(String xml) {
        DocumentBuilderFactory domFactory = this.getDocumentBuilderFactory();
        domFactory.setNamespaceAware(true);
        try {
            DocumentBuilder builder = domFactory.newDocumentBuilder();
            this.doc = builder.parse(xml);
        }
        catch (Exception e) {
            LOG.error(e.getMessage());
        }
    }

    public DocumentBuilderFactory getDocumentBuilderFactory() {
        DocumentBuilderFactory domFactory = DocumentBuilderFactory.newInstance();
        try {
            String feature = "http://apache.org/xml/features/disallow-doctype-decl";
            domFactory.setFeature(feature, true);
            feature = "http://xml.org/sax/features/external-general-entities";
            domFactory.setFeature(feature, false);
            feature = "http://xml.org/sax/features/external-parameter-entities";
            domFactory.setFeature(feature, false);
            feature = "http://apache.org/xml/features/nonvalidating/load-external-dtd";
            domFactory.setFeature(feature, false);
            domFactory.setXIncludeAware(false);
            domFactory.setExpandEntityReferences(false);
            domFactory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
        }
        catch (ParserConfigurationException e) {
            LOG.error(e.getMessage());
        }
        return domFactory;
    }

    public Map<String, String> parse(List<String> xpeList) {
        TreeMap<String, String> dict = new TreeMap<String, String>();
        try {
            XPathFactory factory = XPathFactory.newInstance();
            XPath xpath = factory.newXPath();
            for (String xpe : xpeList) {
                XPathExpression expr = xpath.compile(xpe);
                Object result = expr.evaluate(this.doc, XPathConstants.NODESET);
                NodeList nodes = (NodeList)result;
                if (nodes.getLength() == 1) {
                    dict.put(xpe, nodes.item(0).getNodeValue());
                    continue;
                }
                for (int i = 0; i < nodes.getLength(); ++i) {
                    dict.put(i + "__" + xpe, nodes.item(i).getNodeValue());
                }
            }
        }
        catch (Exception e) {
            LOG.error("some pb occurred during xml scan");
        }
        return dict;
    }
}

