/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.tool.template;

import com.axelor.apps.tool.date.DateTool;
import com.axelor.auth.AuthUtils;
import com.axelor.common.StringUtils;
import com.axelor.db.Model;
import com.axelor.db.mapper.Mapper;
import com.axelor.db.mapper.Property;
import com.axelor.i18n.I18n;
import com.axelor.meta.MetaStore;
import com.axelor.meta.schema.views.Selection;
import com.axelor.rpc.Resource;
import com.google.common.base.Charsets;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.Maps;
import com.google.common.io.Files;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.charset.Charset;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.format.DateTimeFormatter;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.lang3.StringEscapeUtils;
import org.stringtemplate.v4.AttributeRenderer;
import org.stringtemplate.v4.DateRenderer;
import org.stringtemplate.v4.Interpreter;
import org.stringtemplate.v4.ModelAdaptor;
import org.stringtemplate.v4.NumberRenderer;
import org.stringtemplate.v4.ST;
import org.stringtemplate.v4.STGroup;
import org.stringtemplate.v4.StringRenderer;
import org.stringtemplate.v4.misc.ObjectModelAdaptor;

public class TemplateMaker {
    private Map<String, Object> context;
    private Map<String, Object> localContext;
    private String template;
    private STGroup stGroup;
    private Locale locale;
    private String timeZone;

    public TemplateMaker(String timeZone, Locale locale, char delimiterStartChar, char delimiterStopChar) {
        this.locale = locale;
        this.timeZone = timeZone;
        this.stGroup = new STGroup(delimiterStartChar, delimiterStopChar);
        this.stGroup.registerModelAdaptor(Model.class, (ModelAdaptor)new ModelFormatRenderer());
        this.stGroup.registerRenderer(LocalDate.class, (AttributeRenderer)new LocalDateRenderer());
        this.stGroup.registerRenderer(LocalDateTime.class, (AttributeRenderer)new LocalDateTimeRenderer());
        this.stGroup.registerRenderer(LocalTime.class, (AttributeRenderer)new LocalTimeRenderer());
        this.stGroup.registerRenderer(String.class, (AttributeRenderer)new StringRenderer());
        this.stGroup.registerRenderer(Number.class, (AttributeRenderer)new NumberRenderer());
        this.stGroup.registerRenderer(Date.class, (AttributeRenderer)new DateRenderer());
    }

    public void setContext(Model model) {
        this.setContext(model, null, null);
    }

    public void setContext(Model model, String nameInContext) {
        this.setContext(model, null, nameInContext);
    }

    public void setContext(Model model, Map<String, Object> map) {
        this.setContext(model, map, null);
    }

    public void setContext(Model model, Map<String, Object> map, String nameInContext) {
        Preconditions.checkNotNull((Object)model);
        this.context = this.makeContext(nameInContext, model, map);
    }

    public void addContext(String nameInContext, Object object) {
        if (this.context == null) {
            this.context = Maps.newHashMap();
        }
        this.context.put(nameInContext, object);
    }

    private Map<String, Object> makeContext(String nameInContext, Model model, Map<String, Object> map) {
        HashMap _map = Maps.newHashMap();
        if (nameInContext != null) {
            _map.put(nameInContext, model);
        } else {
            _map.putAll(Resource.toMap((Object)model, (String[])new String[0]));
        }
        if (map != null) {
            _map.putAll(map);
        }
        return _map;
    }

    public void setTemplate(String text) {
        this.template = text;
    }

    public void setTemplate(File file) throws FileNotFoundException {
        String text;
        if (!file.isFile()) {
            throw new FileNotFoundException(I18n.get((String)"No such template") + ": " + file.getName());
        }
        try {
            text = Files.toString((File)file, (Charset)Charsets.UTF_8);
        }
        catch (IOException e) {
            throw new IllegalArgumentException(e);
        }
        this.setTemplate(text);
    }

    public void addInContext(String key, Object value) {
        if (this.localContext == null) {
            this.localContext = Maps.newHashMap();
        }
        this.localContext.put(key, value);
    }

    public void addInContext(Map<String, Object> map) {
        if (this.localContext == null) {
            this.localContext = Maps.newHashMap();
        }
        this.localContext.putAll(map);
    }

    public Class<?> getBeanClass(Model model) {
        return model.getClass();
    }

    public void setLocale(Locale locale) {
        this.locale = locale;
    }

    public Locale getLocale() {
        return this.locale;
    }

    public String make() {
        if (Strings.isNullOrEmpty((String)this.template)) {
            throw new IllegalArgumentException(I18n.get((String)"Templating can not be empty"));
        }
        ST st = new ST(this.stGroup, this.template);
        HashMap _map = Maps.newHashMap();
        if (this.localContext != null && !this.localContext.isEmpty()) {
            _map.putAll(this.localContext);
        }
        if (this.context != null) {
            _map.putAll(this.context);
        }
        _map.put("__user__", AuthUtils.getUser());
        _map.put("__date__", DateTool.getTodayDate(this.timeZone));
        _map.put("__time__", LocalTime.now());
        _map.put("__datetime__", DateTool.getTodayDateTime(this.timeZone));
        for (String key : _map.keySet()) {
            Object value = _map.get(key);
            if (value instanceof String) {
                value = StringEscapeUtils.escapeXml11((String)value.toString());
            }
            st.add(key, value);
        }
        return this._make(st);
    }

    private String _make(ST st) {
        return st.render(this.locale);
    }

    class LocalTimeRenderer
    implements AttributeRenderer {
        LocalTimeRenderer() {
        }

        public String toString(Object o, String formatString, Locale locale) {
            if (formatString == null) {
                return o.toString();
            }
            LocalTime ld = (LocalTime)o;
            return ld.format(DateTimeFormatter.ofPattern(formatString));
        }
    }

    class LocalDateTimeRenderer
    implements AttributeRenderer {
        LocalDateTimeRenderer() {
        }

        public String toString(Object o, String formatString, Locale locale) {
            if (formatString == null) {
                return o.toString();
            }
            LocalDateTime ld = (LocalDateTime)o;
            return ld.format(DateTimeFormatter.ofPattern(formatString));
        }
    }

    class LocalDateRenderer
    implements AttributeRenderer {
        LocalDateRenderer() {
        }

        public String toString(Object o, String formatString, Locale locale) {
            if (formatString == null) {
                return o.toString();
            }
            LocalDate ld = (LocalDate)o;
            return ld.format(DateTimeFormatter.ofPattern(formatString));
        }
    }

    class ModelFormatRenderer
    implements ModelAdaptor {
        ModelFormatRenderer() {
        }

        private Property getProperty(Class<?> beanClass, String name) {
            return Mapper.of(beanClass).getProperty(name);
        }

        private String getSelectionValue(Property prop, Object o, Object value) {
            if (value == null) {
                return "";
            }
            Selection.Option option = MetaStore.getSelectionItem((String)prop.getSelection(), (String)value.toString());
            if (option == null) {
                return value.toString();
            }
            if (StringUtils.notBlank((CharSequence)option.getTitle())) {
                return I18n.getBundle((Locale)TemplateMaker.this.locale).getString(option.getTitle());
            }
            return option.getValue();
        }

        public Object getProperty(Interpreter interp, ST self, Object o, Object property, String propertyName) {
            Property prop = this.getProperty(o.getClass(), (String)property);
            ModelAdaptor adap = self.groupThatCreatedThisInstance.getModelAdaptor(ObjectModelAdaptor.class);
            if (prop == null || Strings.isNullOrEmpty((String)prop.getSelection())) {
                return adap.getProperty(interp, self, o, property, propertyName);
            }
            Object value = adap.getProperty(interp, self, o, property, propertyName);
            return this.getSelectionValue(prop, o, value);
        }
    }
}

