/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.base.db;

import com.axelor.apps.base.db.AccessConfig;
import com.axelor.auth.db.AuditableModel;
import com.axelor.db.annotations.HashKey;
import com.axelor.db.annotations.Widget;
import com.axelor.meta.db.MetaFile;
import com.google.common.base.MoreObjects;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import javax.persistence.Basic;
import javax.persistence.Cacheable;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Index;
import javax.persistence.Inheritance;
import javax.persistence.InheritanceType;
import javax.persistence.Lob;
import javax.persistence.ManyToMany;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.validation.constraints.NotNull;
import org.hibernate.annotations.Type;

@Entity
@Cacheable
@Table(name="BASE_APP", indexes={@Index(columnList="name"), @Index(columnList="image")})
@Inheritance(strategy=InheritanceType.JOINED)
public class App
extends AuditableModel {
    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="BASE_APP_SEQ")
    @SequenceGenerator(name="BASE_APP_SEQ", sequenceName="BASE_APP_SEQ", allocationSize=1)
    private Long id;
    @Widget(title="Name", translatable=true)
    @NotNull
    private String name;
    @HashKey
    @Widget(title="Code")
    @NotNull
    @Column(unique=true)
    private String code;
    @Widget(title="Description", translatable=true)
    @Lob
    @Basic(fetch=FetchType.LAZY)
    @Type(type="text")
    private String description;
    @Widget(title="Modules contains in the app")
    private String modules;
    @Widget(title="Depends on")
    @ManyToMany(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Set<App> dependsOnSet;
    @Widget(title="Image")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private MetaFile image;
    @Widget(title="Init data loaded")
    private Boolean initDataLoaded = Boolean.FALSE;
    @Widget(title="Demo data loaded")
    private Boolean demoDataLoaded = Boolean.FALSE;
    @Widget(title="Roles imported")
    private Boolean isRolesImported = Boolean.FALSE;
    @Widget(title="Installed")
    private Boolean active = Boolean.FALSE;
    @Widget(title="Sequence")
    private Integer sequence = 0;
    @Widget(title="Install order")
    private Integer installOrder = 0;
    @Widget(title="Language", selection="select.language")
    private String languageSelect;
    @Widget(title="Access config")
    @OneToMany(fetch=FetchType.LAZY, mappedBy="app", cascade={CascadeType.ALL}, orphanRemoval=true)
    private List<AccessConfig> accessConfigList;
    @Widget(title="Attributes")
    @Basic(fetch=FetchType.LAZY)
    @Type(type="json")
    private String attrs;

    public App() {
    }

    public App(String name, String code) {
        this.name = name;
        this.code = code;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getCode() {
        return this.code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getModules() {
        return this.modules;
    }

    public void setModules(String modules) {
        this.modules = modules;
    }

    public Set<App> getDependsOnSet() {
        return this.dependsOnSet;
    }

    public void setDependsOnSet(Set<App> dependsOnSet) {
        this.dependsOnSet = dependsOnSet;
    }

    public void addDependsOnSetItem(App item) {
        if (this.getDependsOnSet() == null) {
            this.setDependsOnSet(new HashSet<App>());
        }
        this.getDependsOnSet().add(item);
    }

    public void removeDependsOnSetItem(App item) {
        if (this.getDependsOnSet() == null) {
            return;
        }
        this.getDependsOnSet().remove((Object)item);
    }

    public void clearDependsOnSet() {
        if (this.getDependsOnSet() != null) {
            this.getDependsOnSet().clear();
        }
    }

    public MetaFile getImage() {
        return this.image;
    }

    public void setImage(MetaFile image) {
        this.image = image;
    }

    public Boolean getInitDataLoaded() {
        return this.initDataLoaded == null ? Boolean.FALSE : this.initDataLoaded;
    }

    public void setInitDataLoaded(Boolean initDataLoaded) {
        this.initDataLoaded = initDataLoaded;
    }

    public Boolean getDemoDataLoaded() {
        return this.demoDataLoaded == null ? Boolean.FALSE : this.demoDataLoaded;
    }

    public void setDemoDataLoaded(Boolean demoDataLoaded) {
        this.demoDataLoaded = demoDataLoaded;
    }

    public Boolean getIsRolesImported() {
        return this.isRolesImported == null ? Boolean.FALSE : this.isRolesImported;
    }

    public void setIsRolesImported(Boolean isRolesImported) {
        this.isRolesImported = isRolesImported;
    }

    public Boolean getActive() {
        return this.active == null ? Boolean.FALSE : this.active;
    }

    public void setActive(Boolean active) {
        this.active = active;
    }

    public Integer getSequence() {
        return this.sequence == null ? 0 : this.sequence;
    }

    public void setSequence(Integer sequence) {
        this.sequence = sequence;
    }

    public Integer getInstallOrder() {
        return this.installOrder == null ? 0 : this.installOrder;
    }

    public void setInstallOrder(Integer installOrder) {
        this.installOrder = installOrder;
    }

    public String getLanguageSelect() {
        return this.languageSelect;
    }

    public void setLanguageSelect(String languageSelect) {
        this.languageSelect = languageSelect;
    }

    public List<AccessConfig> getAccessConfigList() {
        return this.accessConfigList;
    }

    public void setAccessConfigList(List<AccessConfig> accessConfigList) {
        this.accessConfigList = accessConfigList;
    }

    public void addAccessConfigListItem(AccessConfig item) {
        if (this.getAccessConfigList() == null) {
            this.setAccessConfigList(new ArrayList<AccessConfig>());
        }
        this.getAccessConfigList().add(item);
        item.setApp(this);
    }

    public void removeAccessConfigListItem(AccessConfig item) {
        if (this.getAccessConfigList() == null) {
            return;
        }
        this.getAccessConfigList().remove((Object)item);
    }

    public void clearAccessConfigList() {
        if (this.getAccessConfigList() != null) {
            this.getAccessConfigList().clear();
        }
    }

    public String getAttrs() {
        return this.attrs;
    }

    public void setAttrs(String attrs) {
        this.attrs = attrs;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof App)) {
            return false;
        }
        App other = (App)((Object)obj);
        if (this.getId() != null || other.getId() != null) {
            return Objects.equals(this.getId(), other.getId());
        }
        return Objects.equals(this.getCode(), other.getCode());
    }

    public int hashCode() {
        return Objects.hash(66049, this.getCode());
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)((Object)this)).add("id", (Object)this.getId()).add("name", (Object)this.getName()).add("code", (Object)this.getCode()).add("modules", (Object)this.getModules()).add("initDataLoaded", (Object)this.getInitDataLoaded()).add("demoDataLoaded", (Object)this.getDemoDataLoaded()).add("isRolesImported", (Object)this.getIsRolesImported()).add("active", (Object)this.getActive()).add("sequence", (Object)this.getSequence()).add("installOrder", (Object)this.getInstallOrder()).add("languageSelect", (Object)this.getLanguageSelect()).omitNullValues().toString();
    }
}

